package session

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/session"
)

func CreateSession(region string, profile string, retries int) (*session.Session, error) {
	config := &aws.Config{
		Region:     aws.String(region),
		MaxRetries: aws.Int(retries),
	}

	if profile == "" {
		return session.Must(session.NewSession(config)), nil
	}

	sess, err := session.NewSessionWithOptions(session.Options{
		Config:  *config,
		Profile: profile,
	})

	return sess, err
}
