package utils

import (
	"os"
)

const (
	ServiceName      = "PiperService"
	DefaultAWSRegion = "us-west-2"
)

func Environment() string {
	environment := os.Getenv("ENVIRONMENT")
	if environment == "" {
		environment = "development"
	}
	return environment
}

func Hostname() (string, error) {
	hostname, err := os.Hostname()
	if err != nil {
		return "", err
	}
	return hostname, nil
}
