freeStyleJob('insights-piper-service') {
  using 'TEMPLATE-autobuild'
  wrappers {
    credentialsBinding {
      file('COURIERD_PRIVATE_KEY', 'courierd')
      file('AWS_CONFIG_FILE', 'aws_config')
      string 'dta_tools_deploy', 'dta_tools_deploy'
      string 'AWS_ACCESS_KEY_ID', "piper-build-aws-key"
      string 'AWS_SECRET_ACCESS_KEY', "piper-build-aws-secret"
    }
  }
  scm {
    git {
      remote {
        github 'insights/piper-service', 'ssh', 'git.xarth.tv'
        credentials 'git-aws-read-key'
      }
      clean true
    }
  }
  steps {
    shell 'make ci'
    shell 'make docker-build-push'
    saveDeployArtifact 'insights/piper-service', './artifact'
  }

  publishers {
    reportQuality('insights/piper-service', 'artifact', '*.xml')
  }
}

[staging: [
    access_key: "twitch-service-piper-dev-tcs-access-key",
    secret_key: "twitch-service-piper-dev-tcs-secret-key"
],prod: [
    access_key: "twitch-service-piper-aws-tcs-access-key",
    secret_key: "twitch-service-piper-aws-tcs-secret-key"
]].each { environment, values ->
  job {
    name "insights-piper-service-eb-deploy-${environment}"
    using 'TEMPLATE-deploy-aws'
    wrappers {
        credentialsBinding {
          file('COURIERD_PRIVATE_KEY', 'courierd')
          file('AWS_CONFIG_FILE', 'aws_config')
          string 'AWS_ACCESS_KEY', "${values.access_key}"
          string 'AWS_SECRET_KEY', "${values.secret_key}"
        }
    }

    steps {
      downloadDeployArtifact "insights/piper-service"
      shell "scripts/jenkins_deploy_alb.sh"
    }
  }
}
