package reports

import (
	"time"

	"code.justin.tv/insights/piper-service/models"
)

func IsValidLimit(limit int) error {
	if limit <= 0 {
		return models.ErrInvalidLimit
	}
	return nil
}

func IsValidDates(startDate, endDate string) error {
	if startDate == "" && endDate == "" {
		return nil
	}

	if startDate == "" && endDate != "" || startDate != "" && endDate == "" {
		return models.ErrInvalidDateFormat
	}

	start, err := time.Parse(time.RFC3339, startDate)
	if err != nil {
		return models.ErrInvalidDateFormat
	}

	end, err := time.Parse(time.RFC3339, endDate)
	if err != nil {
		return models.ErrInvalidDateFormat
	}

	if start.After(end) {
		return models.ErrInvalidDateRange
	}
	return nil
}

// IsValidReportType check if a reportType is valid
// empty string is always allowed
// otherwise check if the given report ID exists for this domain
func IsValidReportType(domain, reportType string) error {
	if reportType != "" && !IsWhitelisted(domain, reportType) {
		return models.ErrInvalidReportType
	}
	return nil
}

// GetValidReportTypes assumes the given report ID is isValidReportType
// if reportType is empty, it returns all report Types for this domain
// othereise return this one single reportType
func GetValidReportTypes(domain, reportType string) []string {
	if reportType != "" {
		return []string{reportType}
	}
	return GetWhitelistedReportTypesByDomain(domain)
}
