package models

import (
	"net/http"
)

var ErrUserNotFound = CodedError{
	ErrorValue:      "User Not Found",
	CodeValue:       "user_not_found",
	StatusCodeValue: http.StatusBadRequest,
}

var ErrUserNoGames = CodedError{
	ErrorValue:      "User Has No Access To Any Games",
	CodeValue:       "user_has_no_access_to_any_games",
	StatusCodeValue: http.StatusForbidden,
}

var ErrUserNoCompany = CodedError{
	ErrorValue:      "User Has No Access To Company",
	CodeValue:       "user_has_no_access_to_company",
	StatusCodeValue: http.StatusForbidden,
}

var ErrGameNoCompany = CodedError{
	ErrorValue:      "Game Not Associated To Company",
	CodeValue:       "game_not_associated_to_company",
	StatusCodeValue: http.StatusForbidden,
}

var ErrAccessForbidden = CodedError{
	ErrorValue:      "Access Forbidden",
	CodeValue:       "access_forbidden",
	StatusCodeValue: http.StatusForbidden,
}

var ErrReportNotFound = CodedError{
	ErrorValue:      "Report Not Found",
	CodeValue:       "report_not_found",
	StatusCodeValue: http.StatusNotFound,
}

var ErrInvalidReportType = CodedError{
	ErrorValue:      "Invalid Report Type",
	CodeValue:       "invalid_report_type",
	StatusCodeValue: http.StatusBadRequest,
}

var ErrInternalError = CodedError{
	ErrorValue:      "Internal Error",
	CodeValue:       "internal_error",
	StatusCodeValue: http.StatusInternalServerError,
}

var ErrGameNotFound = CodedError{
	ErrorValue:      "Game Name Not Found",
	CodeValue:       "game_not_found",
	StatusCodeValue: http.StatusNotFound,
}

var ErrResourceNotFound = CodedError{
	ErrorValue:      "Resource Not Found",
	CodeValue:       "resource_not_found",
	StatusCodeValue: http.StatusNotFound,
}

var ErrUserNoExtensions = CodedError{
	ErrorValue:      "User Does Not Have Extensions",
	CodeValue:       "user_not_have_extensions",
	StatusCodeValue: http.StatusNotFound,
}

var ErrInvalidDateRange = CodedError{
	ErrorValue:      "Report Not Found For Date Range",
	CodeValue:       "report_not_found_for_date_range",
	StatusCodeValue: http.StatusNotFound,
}

var ErrInvalidDateFormat = CodedError{
	ErrorValue:      "Invalid Date Format",
	CodeValue:       "invalid_date_format",
	StatusCodeValue: http.StatusBadRequest,
}

var ErrInvalidOffset = CodedError{
	ErrorValue:      "Not Valid Offset",
	CodeValue:       "not_valid_offset",
	StatusCodeValue: http.StatusBadRequest,
}

var ErrInvalidLimit = CodedError{
	ErrorValue:      "Not Valid Limit",
	CodeValue:       "not_valid_limit",
	StatusCodeValue: http.StatusBadRequest,
}

var ErrInvalidGameID = CodedError{
	ErrorValue:      "Invalid Game ID",
	CodeValue:       "not_valid_game_id",
	StatusCodeValue: http.StatusBadRequest,
}

var ErrBadGameInsightsData = CodedError{
	ErrorValue:      "Bad Game Insights Data",
	CodeValue:       "bad_game_insights_data",
	StatusCodeValue: http.StatusInternalServerError,
}

var ErrUserNoMods = CodedError{
	ErrorValue:      "User Does Not Have Mods",
	CodeValue:       "user_does_not_have_mods",
	StatusCodeValue: http.StatusNotFound,
}
