package models

import (
	"fmt"
	"net/http"
)

type CodedError struct {
	CodeValue       string
	ErrorValue      string
	StatusCodeValue int
}

func (e CodedError) Code() string {
	return e.CodeValue
}

func (e CodedError) Error() string {
	return e.ErrorValue
}

func (e CodedError) StatusCode() int {
	if e.StatusCodeValue == 0 {
		return http.StatusInternalServerError
	}
	return e.StatusCodeValue
}

func NewErrorResponse(status int, err error) ErrorResponse {
	return ErrorResponse{
		Status:     status,
		Message:    err.Error(),
		StatusText: http.StatusText(status),
	}
}

// ErrorResponse is used to encode API errors and decode on client side.
type ErrorResponse struct {
	Status     int    `json:"status"`
	Message    string `json:"message"`
	StatusText string `json:"error"`
}

func (er ErrorResponse) Error() string {
	return fmt.Sprintf("Error (%d): %s", er.Status, er.Message)
}

func (er ErrorResponse) StatusCode() int {
	return er.Status
}
