package models

// For Special Event Games
var BlackListedGames = map[string]bool{
	"509660": true,
	"509669": true,
	"518203": true,
	"509667": true,
	"509658": true,
	"509673": true,
	"26936":  true,
	"509670": true,
	"509663": true,
	"509671": true,
	"417752": true,
	"509672": true,
	"515214": true,
}

type GameReport struct {
	GameID     string `json:"game_id"`
	ReportName string `json:"report"`
}

type GameReports []GameReport

type GameReportInstance struct {
	GameID     string   `json:"game"`
	ReportName string   `json:"report"`
	Instances  []string `json:"instances"`
}

type GameReportInstances []GameReportInstance

type GameReportsResp struct {
	Key GameReports `json:"reports"`
}

type GameInstancesResp struct {
	Key GameReportInstance `json:"report"`
}

type GameReportType struct {
	GameID      string   `json:"game"`
	ReportTypes []string `json:"reports"`
}

type GameReportTypeResp struct {
	Key GameReportType `json:"reports"`
}

type GameReportByDate struct {
	GameID    string `json:"game_id"`
	StartDate string `json:"start_date"`
	EndDate   string `json:"end_date"`
	URL       string `json:"URL"`
}

type GameReportByDateResp struct {
	Key GameReportByDate `json:"report"`
}
