package models

import "code.justin.tv/common/yimg"

type OnePagerData struct {
	HoursBroadcastCurrent       float64 `json:"hours_broadcast_current"`
	HoursBroadcastQoQ           float64 `json:"hours_broadcast_qoq"`
	HoursWatchedCurrent         float64 `json:"hours_watched_current"`
	HoursWatchedQoQ             float64 `json:"hours_watched_qoq"`
	UniqueBroadcastersCurrent   uint64  `json:"unique_broadcasters_current"`
	UniqueBroadcastersQoQ       float64 `json:"unique_broadcasters_qoq"`
	UniqueViewersCurrent        uint64  `json:"unique_viewers_current"`
	UniqueViewersQoQ            float64 `json:"unique_viewers_qoq"`
	BroadcastingSessionsCurrent uint64  `json:"broadcasting_sessions_current"`
	BroadcastingSessionsQoQ     float64 `json:"broadcasting_sessions_qoq"`
	ViewingSessionsCurrent      uint64  `json:"viewing_sessions_current"`
	ViewingSessionsQoQ          float64 `json:"viewing_sessions_qoq"`

	TopChannelLogin                    string  `json:"top_channel_login"`
	TopChannelDisplayName              string  `json:"top_channel_displayname"`
	TopChannelHoursBroadcast           float64 `json:"top_channel_hours_broadcast"`
	TopChannelHoursWatched             float64 `json:"top_channel_hours_watched"`
	TopChannelAvgCCU                   uint64  `json:"top_channel_avg_ccu"`
	RisingChannelLogin                 string  `json:"rising_channel_login"`
	RisingChannelDisplayname           string  `json:"rising_channel_displayname"`
	RisingChannelHoursBroadcast        float64 `json:"rising_channel_hours_broadcast"`
	RisingChannelHoursWatched          float64 `json:"rising_channel_hours_watched"`
	RisingChannelAvgCCU                uint64  `json:"rising_channel_avg_ccu"`
	MostDedicatedChannelLogin          string  `json:"most_dedicated_channel_login"`
	MostDedicatedChannelDisplayname    string  `json:"most_dedicated_channel_displayname"`
	MostDedicatedChannelSessions       uint64  `json:"most_dedicated_channel_sessions"`
	MostDedicatedChannelGamePercentage float64 `json:"most_dedicated_game_percentage"`

	TotalChatMessages      uint64  `json:"total_chat_messages"`
	UniqueChatters         uint64  `json:"unique_chatters"`
	ChatterPercent         float64 `json:"chatter_percent"`
	UniquePartnerAffiliate uint64  `json:"unique_partner_affiliate"`

	TotalActiveExtensions uint64 `json:"total_active_extensions"`
	MostPopularExtensions string `json:"most_popular_extensions"`

	DropsReceivedCurrent              uint64  `json:"drops_received_current"`
	DropsReceivedQoQ                  float64 `json:"drops_received_qoq"`
	UniqueViewersReceivedADropCurrent uint64  `json:"unique_viewers_received_a_drop_current"`
	UniqueViewersReceivedADropQoQ     float64 `json:"unique_viewers_received_a_drop_qoq"`
	ActiveCampaignsCurrent            uint64  `json:"active_campaigns_current"`
	ActiveCampaignsQoQ                float64 `json:"active_campaigns_qoq"`

	RisingCountriesByStreamers string `json:"rising_countries_by_streamers"`
	RisingCountriesByViewers   string `json:"rising_countries_by_viewers"`
	TopThreeGamesByStreamers   string `json:"top_three_games_by_streamers"`
	TopThreeGamesByViewers     string `json:"top_three_games_by_viewers"`
}

type GameInfo struct {
	GameID   string `json:"game_id"`
	GameName string `json:"game_name"`
}

type OverviewStats struct {
	HoursWatched                float64 `json:"hours_watched"`
	HoursWatchedChanges         float64 `json:"hours_watched_changes"`
	UniqueViewers               uint64  `json:"unique_viewers"`
	UniqueViewersChanges        float64 `json:"unique_viewers_change"`
	ViewingSessions             uint64  `json:"viewing_sessions"`
	ViewingSessionsChanges      float64 `json:"viewing_sessions_changes"`
	HoursBroadcast              float64 `json:"hours_broadcast"`
	HoursBroadcastChanges       float64 `json:"hours_broadcast_changes"`
	UniqueBroadcasters          uint64  `json:"unique_broadcasters"`
	UniqueBroadcastersChanges   float64 `json:"unique_broadcasters_changes"`
	BroadcastingSessions        uint64  `json:"broadcasting_sessions"`
	BroadcastingSessionsChanges float64 `json:"broadcasting_sessions_changes"`
}

type TopCountry struct {
	Name       string  `json:"name"`
	Code       string  `json:"code"`
	Percentage float64 `json:"percentage"`
}

type TopGame struct {
	Id         string  `json:"id"`
	Name       string  `json:"name"`
	Percentage float64 `json:"percentage,omitempty"`
	Img        string  `json:"img,omitempty"`
}

type AudienceStats struct {
	TopGamesToWatch         []TopGame    `json:"top_games_to_watch"`
	TopGamesToStream        []TopGame    `json:"top_games_to_stream"`
	TopBroadcasterCountries []TopCountry `json:"top_broadcaster_countries"`
	TopViewerCountries      []TopCountry `json:"top_viewer_countries"`
}

type DropStats struct {
	NumOfDropsReceived               uint64  `json:"num_of_drops_received"`
	NumOfDropsReceivedChange         float64 `json:"num_of_drops_received_change"`
	NumOfUniqueReceivingUsers        uint64  `json:"num_of_unique_receiving_users"`
	NumOfUniqueReceivingUsersChanges float64 `json:"num_of_unique_receiving_users_changes"`
	NumOfCampaigns                   uint64  `json:"num_of_campaigns"`
	NumOfCampaignsChanges            float64 `json:"num_of_campaigns_changes"`
}

type ExtensionStats struct {
	Id          string  `json:"id"`
	Name        string  `json:"name"`
	Description string  `json:"description"`
	Url         string  `json:"url"`
	IconURL     *string `json:"icon_url,omitempty"`
	SplashURL   *string `json:"splash_url,omitempty"`
}

type SocialStats struct {
	NumOfChatMessages     uint64  `json:"num_of_chat_messages"`
	PercentOfEngagement   float64 `json:"percent_of_engagement"`
	NumOfPartnersStreamed uint64  `json:"num_of_partners_streamed"`
}

type RisingStar struct {
	Name                 string  `json:"name"`
	DisplayName          string  `json:"display_name"`
	HoursStreamed        float64 `json:"hours_streamed"`
	HoursWatched         float64 `json:"hours_watched"`
	AvgConcurrentViewers uint64  `json:"avg_concurrent_viewers"`
	ProfileImage         string  `json:"profile_image"`
}

type DedicatedBroadcaster struct {
	Name                       string  `json:"name"`
	DisplayName                string  `json:"display_name"`
	StreamedSessions           uint64  `json:"streamed_sessions"`
	AvgStreamSessionsPerWeek   float64 `json:"avg_stream_sessions_per_week"`
	PercentageOfHoursBroadcast float64 `json:"percentage_of_hours_broadcast"`
	ProfileImage               string  `json:"profile_image"`
}

type TopBroadcaster struct {
	Name              string  `json:"name"`
	DisplayName       string  `json:"display_name"`
	HoursBroadcast    float64 `json:"hours_broadcast"`
	HoursWatched      float64 `json:"hours_watched"`
	ConcurrentViewers uint64  `json:"concurrent_viewers"`
	ProfileImage      string  `json:"profile_image"`
}

type PopularBroadcaster struct {
	Name         string `json:"name"`
	DisplayName  string `json:"display_name"`
	ProfileImage string `json:"profile_image"`
}

type BroadcasterStats struct {
	TopBroadcaster       *TopBroadcaster       `json:"top_broadcaster,omitempty"`
	DedicatedBroadcaster *DedicatedBroadcaster `json:"dedicated_broadcaster,omitempty"`
	RisingStar           *RisingStar           `json:"rising_star,omitempty"`
}

type TwitchOverviewStats struct {
	MinutesWatched            uint64 `json:"minutes_watched"`
	UniqueMonthlyBroadcasters uint64 `json:"unique_monthly_broadcasters"`
	UniqueDailyVisitors       uint64 `json:"unique_daily_visitors"`
	PartneredStreamers        uint64 `json:"partnered_streamers"`
	AffiliateStreamers        uint64 `json:"affiliate_streamers"`
	TotalClips                uint64 `json:"total_clips"`
}

type GameOnePagerDataResponse struct {
	GameInfo            GameInfo              `json:"game_info"`
	NumOfExtensions     uint64                `json:"num_of_extensions"`
	OverviewStats       *OverviewStats        `json:"overview_stats,omitempty"`
	BroadcasterStats    *BroadcasterStats     `json:"broadcaster_stats,omitempty"`
	SocialStats         *SocialStats          `json:"social_stats,omitempty"`
	ExtensionStats      *[]ExtensionStats     `json:"extension_stats,omitempty"`
	DropsStats          *DropStats            `json:"drops_stats,omitempty"`
	AudienceStats       *AudienceStats        `json:"audience_stats,omitempty"`
	GeneralStats        *TwitchOverviewStats  `json:"general_stats,omitempty"`
	PopularBroadcasters *[]PopularBroadcaster `json:"popular_broadcasters,omitempty"`
	PopularExtensions   *[]ExtensionStats     `json:"popular_extensions,omitempty"`
	PopularGames        *PopularGames         `json:"popular_games,omitempty"`
	ProfileImage        *yimg.Images          `json:"profile_image" `
}

type PopularGames struct {
	PopularGamesToStream []TwitchPopularGame `json:"popular_games_to_stream"`
	PopularGamesToWatch  []TwitchPopularGame `json:"popular_games_to_watch"`
}

type OnePagerSectionPresentStatus struct {
	OverviewStats    bool
	BroadcasterStats bool
	SocialStats      bool
	ExtensionStats   bool
	DropStats        bool
	AudienceStats    bool
}

type OnePagerDefaultData struct {
	MinutesWatched            uint64 `json:"minutes_watched"`
	UniqueMonthlyBroadcasters uint64 `json:"unique_monthly_broadcasters"`
	UniqueDailyVisitors       uint64 `json:"unique_daily_visitors"`
	PartneredStreamers        uint64 `json:"partnered_streamers"`
	AffiliateStreamers        uint64 `json:"affiliate_streamers"`
	TotalClips                uint64 `json:"total_clips"`
	TotalActiveExtensions     uint64 `json:"total_active_extensions"`
	TopThreeBroadcaster       string `json:"top_three_broadcaster"`
	TopThreeExtensions        string `json:"top_three_extensions"`
	TopThreeGamesByStreamers  string `json:"top_three_games_by_streamers"`
	TopThreeGamesByViewers    string `json:"top_three_games_by_viewers"`
}

type TwitchPopularGame struct {
	Id   string `json:"id"`
	Name string `json:"name"`
	Img  string `json:"img,omitempty"`
}

type QuarterStartRange struct {
	MaxQuarter string `json:"max_quarter"`
	MaxYear    string `json:"max_year"`
	MinQuarter string `json:"min_quarter"`
	MinYear    string `json:"min_year"`
}

type OnePagerCacheData struct {
	PresentStatus OnePagerSectionPresentStatus `json:"present_status"`
	DataResp      GameOnePagerDataResponse     `json:"data_resp"`
	AllPresent    bool                         `json:"all_present"`
}
