package models

import "strings"

type Report struct {
	ID         string `json:"id"`
	ReportType string `json:"report_type"`
}

type Reports []Report

type ReportInstance struct {
	ID         string   `json:"id"`
	ReportType string   `json:"report_type"`
	Instances  []string `json:"instances"`
}

type ReportInstances []ReportInstance

type ReportsResp struct {
	Key Reports `json:"reports"`
}

type InstancesResp struct {
	Key ReportInstance `json:"report_instance"`
}

type ReportType struct {
	ID          string   `json:"id"`
	ReportTypes []string `json:"report_types"`
}

type ReportTypeResp struct {
	Key ReportType `json:"report_type"`
}

type HelixReports []HelixReport

func (g HelixReports) Len() int      { return len(g) }
func (g HelixReports) Swap(i, j int) { g[i], g[j] = g[j], g[i] }

func (g HelixReports) Less(i, j int) bool {
	if strings.Compare(g[i].ID, g[j].ID) < 0 {
		return true
	} else if strings.Compare(g[i].ID, g[j].ID) > 0 {
		return false
	}
	return strings.Compare(g[i].Type, g[j].Type) < 0
}

type HelixReport struct {
	ID   string `json:"id"`
	Type string `json:"type"`
	URL  string `json:"URL"`

	StartDate string `json:"start_date"`
	EndDate   string `json:"end_date"`
}

type HelixReportsResp struct {
	Data       HelixReports `json:"data"`
	Pagination *Pagination  `json:"pagination"`
}

type Pagination struct {
	Offset int `json:"offset"`
	Limit  int `json:"limit"`
}

type HelixInputProp struct {
	UserID     string      `json:"userid"`
	Domain     string      `json:"domain"`
	Key        string      `json:"key"`
	ReportType string      `json:"type"`
	StartDate  string      `json:"start_date"`
	EndDate    string      `json:"end_date"`
	Pagination *Pagination `json:"pagination"`
}
