package models

import (
	"testing"

	"sort"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/suite"
)

const (
	extensionIDOne = "kr7m1hz7esldlrptruk0fd76l6yq36"
	extensionIDTwo = "qv0zgol1q157r7rk4nqta4atzx55jh"
	typeOverview   = "overview"
	typeOverviewV2 = "overviewV2"
)

type ReportTest struct {
	suite.Suite
	reports HelixReports
}

func (suite *ReportTest) SetupTest() {
	suite.reports = HelixReports{
		{ID: extensionIDTwo, Type: typeOverviewV2},
		{ID: extensionIDOne, Type: typeOverview},
		{ID: extensionIDTwo, Type: typeOverview},
		{ID: extensionIDOne, Type: typeOverviewV2},
	}
}

func (suite *ReportTest) TestSortReports() {
	sort.Sort(suite.reports)
	assert.Equal(suite.T(), suite.reports[0], HelixReport{ID: extensionIDOne, Type: typeOverview})
	assert.Equal(suite.T(), suite.reports[1], HelixReport{ID: extensionIDOne, Type: typeOverviewV2})
	assert.Equal(suite.T(), suite.reports[2], HelixReport{ID: extensionIDTwo, Type: typeOverview})
	assert.Equal(suite.T(), suite.reports[3], HelixReport{ID: extensionIDTwo, Type: typeOverviewV2})
}

func (suite *ReportTest) TestReportsLen() {
	assert.Equal(suite.T(), suite.reports.Len(), 4)
}

func (suite *ReportTest) TestReportsCompare() {
	assert.Equal(suite.T(), suite.reports.Less(0, 1), false)
	assert.Equal(suite.T(), suite.reports.Less(0, 2), false)
	assert.Equal(suite.T(), suite.reports.Less(0, 3), false)
	assert.Equal(suite.T(), suite.reports.Less(1, 2), true)
	assert.Equal(suite.T(), suite.reports.Less(1, 3), true)
	assert.Equal(suite.T(), suite.reports.Less(2, 3), false)
}

func TestReportSuite(t *testing.T) {
	suite.Run(t, new(ReportTest))
}
