#!/bin/bash

set -eo pipefail

# Collect packages in this repository
PKGS=$(go list ./...)

# Speed up test runs
go install ./...

if [ -e coverage.xml ]; then
    echo "remove coverage.xml"
    rm -f coverage.xml
fi

declare -a vpkg=()

for pkg in $PKGS; do
  # Ensure package name is filename friendly
  pkg_path=${pkg//\//-}
  # Exclude any integration tests
  if [[ ! "$pkg_path" =~ "tools-integration" ]]
  then
    vpkg+=($pkg)
  fi
done

# Run test coverage
retool do gocov test ${vpkg[*]} | retool do gocov-xml >> coverage.xml
