#!/bin/bash

set -e

ps ax | grep './artifact/piper-service' | awk -F ' ' '{print $1}' | xargs kill -9 || echo "try shutting down testing server"

(go run cmd/run/main.go staging ./artifact/piper-service &) || (echo "starting service")

sleep 10

echo "==> verifying applications are up"
curl -v localhost:8000/debug/running || (echo "server isn't running" && exit 1)
echo "<== verified applications are up"

echo "==> running integration tests"
SERVER_ADDRESS=localhost:8000 go test -v -coverprofile=client_coverage.out -tags=integration -coverpkg=code.justin.tv/insights/piper-service/client ./tools/integration
echo "<== completed integration tests"

ps ax | grep './artifact/piper-service' | awk -F ' ' '{print $1}' | xargs kill -9 || echo "shutting down testing server"
