data "aws_iam_policy_document" "eb_role_policy" {
  # This statement gives access to EB- and Service-related s3
  statement {
    actions = [
      "s3:Get*",
      "s3:List*",
      "s3:PutObject*",
    ]

    effect = "Allow"

    resources = [
      "arn:aws:s3:::elasticbeanstalk-*",
      "arn:aws:s3:::elasticbeanstalk-*/*",
    ]
  }

  # Access for the service's cloudwatch-logs streams
  statement {
    actions = ["logs:*"]
    effect  = "Allow"

    resources = [
      "arn:aws:logs:${var.aws_region}:*:log-group:/aws/elasticbeanstalk/${var.common_name}*",
    ]
  }
}

resource "aws_iam_role_policy" "eb" {
  name   = "${var.aws_region}-${var.common_name}"
  policy = "${data.aws_iam_policy_document.eb_role_policy.json}"
  role   = "${var.iam_role_id}"
}

resource "aws_iam_instance_profile" "eb" {
  name = "${var.aws_region}-${var.common_name}"
  role = "${var.iam_role_id}"
}

resource "aws_iam_role_policy_attachment" "eb_web_tier" {
  role       = "${var.iam_role_id}"
  policy_arn = "arn:aws:iam::aws:policy/AWSElasticBeanstalkWebTier"
}

resource "aws_iam_role_policy_attachment" "eb_enhanced_health" {
  role       = "${var.iam_role_id}"
  policy_arn = "arn:aws:iam::aws:policy/service-role/AWSElasticBeanstalkEnhancedHealth"
}

data "aws_iam_policy_document" "xray_download" {
  statement {
    effect = "Allow"

    actions = [
      "s3:GetObject",
    ]

    resources = ["arn:aws:s3:::twitch-web-aws/xray/*"]
  }
}

resource "aws_iam_role_policy" "xray" {
  name   = "${var.common_name}-eb-xray"
  policy = "${data.aws_iam_policy_document.xray_download.json}"
  role   = "${var.iam_role_id}"
}
