resource "aws_elastic_beanstalk_environment" "server" {
  name                = "${var.common_name}-${var.environment_suffix}"
  description         = "${var.common_name}"
  application         = "${var.eb_application_name}"
  tier                = "WebServer"
  solution_stack_name = "${var.solution_stack_name}"

  tags {
    Environment = "${var.env}"
    Service     = "${var.service}"
    Owner       = "${var.owner}"
    Tier        = "WebServer"
    Skeleton    = "dta/docker-eb-tf-skeleton@503764814949793d49d5e873510d1da36014b583"
  }

  wait_for_ready_timeout = "${var.wait_for_ready_timeout}"

  # Load Balancer Related Settings
  setting {
    namespace = "aws:ec2:vpc"
    name      = "ELBSubnets"
    value     = "${var.elb_subnet_ids}"
  }

  setting {
    namespace = "aws:ec2:vpc"
    name      = "ELBScheme"
    value     = "${var.elb_scheme}"
  }

  setting {
    namespace = "aws:elasticbeanstalk:application"
    name      = "Application Healthcheck URL"
    value     = "${var.healthcheck_url}"
  }

  # asg launch configuration settings
  setting {
    namespace = "aws:autoscaling:launchconfiguration"
    name      = "IamInstanceProfile"
    value     = "${coalesce(var.auto_scaling_lc_iam_instance_profile, aws_iam_instance_profile.eb.name)}"
  }

  setting {
    namespace = "aws:autoscaling:asg"
    name      = "MinSize"
    value     = "${var.asg_min_size}"
  }

  setting {
    namespace = "aws:autoscaling:asg"
    name      = "MaxSize"
    value     = "${var.asg_max_size}"
  }

  setting {
    namespace = "aws:autoscaling:launchconfiguration"
    name      = "InstanceType"
    value     = "${var.instance_type}"
  }

  setting {
    namespace = "aws:autoscaling:launchconfiguration"
    name      = "RootVolumeType"
    value     = "${var.root_volume_type}"
  }

  setting {
    namespace = "aws:autoscaling:launchconfiguration"
    name      = "RootVolumeSize"
    value     = "${var.root_volume_size}"
  }

  setting {
    namespace = "aws:autoscaling:launchconfiguration"
    name      = "RootVolumeIOPS"
    value     = "${var.root_volume_iops}"
  }

  # eb environment settings
  setting {
    namespace = "aws:elasticbeanstalk:environment"
    name      = "ServiceRole"
    value     = "${var.eb_environment_service_role}"
  }

  # Vpc  and network related settings
  setting {
    namespace = "aws:ec2:vpc"
    name      = "VPCId"
    value     = "${var.vpc_id}"
  }

  setting {
    namespace = "aws:ec2:vpc"
    name      = "Subnets"
    value     = "${var.ec2_subnet_ids}"
  }

  setting {
    namespace = "aws:autoscaling:launchconfiguration"
    name      = "MonitoringInterval"
    value     = "${var.auto_scaling_lc_monitoring_interval}"
  }

  setting {
    namespace = "aws:autoscaling:launchconfiguration"
    name      = "SecurityGroups"
    value     = "${var.auto_scaling_lc_security_groups}"
  }

  setting {
    namespace = "aws:elasticbeanstalk:application:environment"
    name      = "APP"
    value     = "${coalesce(var.app_name, var.eb_application_name)}"
  }

  setting {
    namespace = "aws:elasticbeanstalk:application:environment"
    name      = "ENVIRONMENT"
    value     = "${var.env}"
  }

  setting {
    namespace = "aws:elasticbeanstalk:application:environment"
    name      = "REGION"
    value     = "${var.aws_region}"
  }

  setting {
    namespace = "aws:elasticbeanstalk:application:environment"
    name      = "INFRA"
    value     = "beanstalk"
  }

  setting {
    namespace = "aws:elasticbeanstalk:environment"
    name      = "ServiceRole"
    value     = "${var.eb_environment_service_role}"
  }

  setting {
    namespace = "aws:elasticbeanstalk:command"
    name      = "DeploymentPolicy"
    value     = "Rolling"
  }

  setting {
    namespace = "aws:elasticbeanstalk:command"
    name      = "BatchSize"
    value     = "${var.deploy_batch_size}"
  }

  setting {
    namespace = "aws:elasticbeanstalk:command"
    name      = "BatchSizeType"
    value     = "${var.deploy_batch_size_type}"
  }

  setting {
    namespace = "aws:elasticbeanstalk:command"
    name      = "Timeout"
    value     = "${var.deploy_timeout}"
  }

  setting {
    namespace = "aws:autoscaling:updatepolicy:rollingupdate"
    name      = "RollingUpdateEnabled"
    value     = "true"
  }

  setting {
    namespace = "aws:autoscaling:updatepolicy:rollingupdate"
    name      = "RollingUpdateType"
    value     = "Health"
  }

  setting {
    namespace = "aws:autoscaling:updatepolicy:rollingupdate"
    name      = "MaxBatchSize"
    value     = "1"
  }

  setting {
    namespace = "aws:autoscaling:updatepolicy:rollingupdate"
    name      = "MinInstancesInService"
    value     = "0"
  }

  setting {
    namespace = "aws:autoscaling:updatepolicy:rollingupdate"
    name      = "Timeout"
    value     = "PT15M"
  }

  setting {
    namespace = "aws:elasticbeanstalk:healthreporting:system"
    name      = "SystemType"
    value     = "enhanced"
  }

  setting {
    namespace = "aws:elasticbeanstalk:healthreporting:system"
    name      = "ConfigDocument"
    value     = "{\"Version\":1,\"CloudWatchMetrics\":{\"Instance\":{\"RootFilesystemUtil\":60,\"CPUIrq\":60,\"LoadAverage5min\":60,\"ApplicationRequests5xx\":60,\"ApplicationRequests4xx\":60,\"CPUUser\":60,\"LoadAverage1min\":60,\"ApplicationLatencyP50\":60,\"CPUIdle\":60,\"InstanceHealth\":60,\"ApplicationLatencyP95\":60,\"ApplicationLatencyP85\":60,\"ApplicationLatencyP90\":60,\"CPUSystem\":60,\"ApplicationLatencyP75\":60,\"CPUSoftirq\":60,\"ApplicationLatencyP10\":60,\"ApplicationLatencyP99\":60,\"ApplicationRequestsTotal\":60,\"ApplicationLatencyP99.9\":60,\"ApplicationRequests3xx\":60,\"ApplicationRequests2xx\":60,\"CPUIowait\":60,\"CPUNice\":60},\"Environment\":{\"InstancesSevere\":60,\"InstancesDegraded\":60,\"ApplicationRequests5xx\":60,\"ApplicationRequests4xx\":60,\"ApplicationLatencyP50\":60,\"ApplicationLatencyP95\":60,\"ApplicationLatencyP85\":60,\"InstancesUnknown\":60,\"ApplicationLatencyP90\":60,\"InstancesInfo\":60,\"InstancesPending\":60,\"ApplicationLatencyP75\":60,\"ApplicationLatencyP10\":60,\"ApplicationLatencyP99\":60,\"ApplicationRequestsTotal\":60,\"InstancesNoData\":60,\"ApplicationLatencyP99.9\":60,\"ApplicationRequests3xx\":60,\"ApplicationRequests2xx\":60,\"InstancesOk\":60,\"InstancesWarning\":60}}}"
  }

  setting {
    namespace = "aws:elasticbeanstalk:cloudwatch:logs"
    name      = "StreamLogs"
    value     = "true"
  }

  setting {
    namespace = "aws:ec2:vpc"
    name      = "AssociatePublicIpAddress"
    value     = "false"
  }
  
  setting {
    namespace = "aws:elasticbeanstalk:environment"
    name      = "LoadBalancerType"
    value     = "${var.load_balancer_type}"
  }
}
