# Beanstalk general variables
variable "aws_region" {
  description = "AWS region"
  default = "us-west-2"
}

variable "eb_application_name" {
  description = "Name of the beanstalk application that will be deployed to this beanstalk environment. #REQUIRED"
}

variable "env" {
  description = "The AWS environment. Must begin with one of the following:  dev (development),  stage (staging), or  prod (production)."
  default     = "dev"
}

variable "owner" {
  description = "The user or team who owns this infrastructure. Will be used for tagging AWS resources. Should be an email address. #REQUIRED"
}

variable "iam_role_id" {
  description = "ID of IAM role to use for beanstalk environment"
  default     = ""
}

variable "iam_role_arn" {
  description = "ARN of IAM role to use for beanstalk environment"
  default     = ""
}

variable "wait_for_ready_timeout" {
  description = "The maximum duration that Terraform should wait for an Elastic Beanstalk Environment to be in a ready state before timing out."
  default     = "10m"
}

# Note: All of the variables below are used to define EB environment configuration.
# If the description is not sufficient, you may find additional information and context
# at: http://docs.aws.amazon.com/elasticbeanstalk/latest/dg/command-options-general.html
variable "vpc_id" {
  description = "VPC ID used for the environment. #REQUIRED"
}

variable "ec2_subnet_ids" {
  description = "Comma-separated string of vpc security groups to be used by beanstalk instances. #REQUIRED"
}

variable "elb_subnet_ids" {
  description = "Comma-separated string of vpc security groups to be used by the beanstalk ELB. #REQUIRED"
}

variable "solution_stack_name" {
  description = "Full beanstalk solution name. See: http://docs.aws.amazon.com/cli/latest/reference/elasticbeanstalk/list-available-solution-stacks.html.  #REQUIRED"
  default     = "64bit Amazon Linux 2016.09 v2.3.0 running Docker 1.11.2"
}

variable "eb_config_template_name" {
  description = "Optional eb configuration template. Used to pass additional or override existing beanstalk settings."
  default     = ""
}

variable "elb_scheme" {
  description = "Type of ELB. <internal|public>"
  default     = "internal"
}

variable "elb_loadbalancer_security_groups" {
  description = "Assign one or more security groups that you created to the load balancer. #REQUIRED"
}

variable "auto_scaling_lc_iam_instance_profile" {
  description = "An instance profile enables AWS Identity and Access Management (IAM) users and AWS services to access temporary security credentials to make AWS API calls. Specify the profile name or the ARN. One is created automatically if one is not specified."
  default     = ""
}

variable "instance_type" {
  description = "The instance type used to run your web server in an Elastic Beanstalk environment."
  default     = "t2.micro"
}

variable "asg_min_size" {
  description = "how much money do you want to spend?"
  default     = 1
}

variable "asg_max_size" {
  description = "how much money do you want to spend?"
  default     = 1
}

variable "auto_scaling_lc_monitoring_interval" {
  description = "Interval at which you want Amazon CloudWatch metrics returned."
  default     = "1 minute"
}

variable "auto_scaling_lc_security_groups" {
  description = "Comma-separated list of vpc security group ids to be used for the beanstalk instances."
  default     = "elasticbeanstalk-default"
}

variable "root_volume_type" {
  description = "Volume type (magnetic, general purpose SSD or privisioned IOPS SSD) to use for the root Amazon EBS volume attached to your environment's EC2 instances."
  default     = "gp2"
}

variable "root_volume_size" {
  description = "Storage capacity of the root Amazon EBS volume in whole GiB."
  default     = "20"
}

variable "root_volume_iops" {
  description = "Desired input/output operations per second (IOPS) for a provisioned IOPS SSD root volume."
  default     = "100"
}

variable "eb_environment_service_role" {
  description = "The name of an IAM role that Elastic Beanstalk uses to manage resources for the environment."
  default     = "aws-elasticbeanstalk-service-role"
}

variable "healthcheck_url" {
  description = "Healthcheck URL. Even workers need to be health checked."
  default     = "/debug/running"
}

variable "app_name" {
  description = "App name to expose to service env var APP"
  default     = ""
}

variable "deploy_batch_size_type" {
  description = "The type of number that is specified in BatchSize. Either 'Fixed' or 'Percentage'"
  default     = "Percentage"
}

variable "deploy_batch_size" {
  description = "Percentage or fixed number of Amazon EC2 instances in the Auto Scaling group on which to simultaneously perform deployments. Valid values vary per BatchSizeType setting."
  default     = 25
}

variable "deploy_timeout" {
  description = "Number of seconds to wait for an instance to complete executing commands"
  default     = 600
}

# dynamic variables
variable "common_name" {
  description = "Name used as a base for created resources. Must only contain upper/lower case letters, digits, and dash. Default if not specified: ${var.env}-${var.service}"
  default     = ""
}

variable "service" {
  description = "All lower­case, in  team/service/[role] format. This tag should indicate the server’s function and what is running on it;  role is optional but highly recommended. #REQUIRED"
}

variable "environment_suffix" {
  description = "Suffix for the environment. This can be used to create multiple environments for the same repository"
  default     = "server"
}

variable "load_balancer_type" {
  description = "The type of load balancer for your environment."
  default     = "classic"
}
