resource "aws_elasticache_subnet_group" "elasticache_subnet" {
  name = "${var.app_name}-${var.environment}-elasticache-subnet"
  description = "elasticache subnet for ${var.app_name}"
  subnet_ids = ["${split(",", var.subnet_ids)}"]
}

resource "aws_elasticache_replication_group" "cache" {
  replication_group_id = "${var.app_name}-cache"
  replication_group_description = "Piper Service Redis Cluster"
  engine = "${var.engine}"
  engine_version = "${var.engine_version}"
  parameter_group_name = "${var.parameter_group_name}"
  node_type = "${var.node_type}"
  port = 6379
  subnet_group_name = "${aws_elasticache_subnet_group.elasticache_subnet.name}"
  security_group_ids = ["${var.security_group_ids}"]
  automatic_failover_enabled = true
  apply_immediately = true
  cluster_mode {
    replicas_per_node_group     = "${var.replicas_per_node_group}"
    num_node_groups             = "${var.num_node_groups}"
  }

  tags {
        Name = "${var.app_name}-${var.environment}"
        Environment = "${var.environment}"
        Owner = "${var.owner}@twitch.tv"
        Service = "${var.app_name}"
    }
}

resource "aws_cloudwatch_metric_alarm" "elasticache_cpu" {
    alarm_name = "${var.app_name}-elasticache-cpu"
    comparison_operator = "GreaterThanOrEqualToThreshold"
    evaluation_periods = "3"
    metric_name = "CPUUtilization"
    namespace = "AWS/ElastiCache"
    period = "300"
    statistic = "Maximum"
    threshold = "75"
    alarm_actions = ["${aws_sns_topic.cloudwatch_alarms.arn}"]
    ok_actions = ["${aws_sns_topic.cloudwatch_alarms.arn}"]
    alarm_description = "Notify pagerduty if CPU sustains above 75% for 15 minutes."
    datapoints_to_alarm = "3"

    dimensions {
        CacheClusterId = "${var.app_name}-cache"
    }
}
