module "eb-env" {
  source                           = "../beanstalk_env"
  app_name                         = "${var.app_name}"
  eb_application_name              = "${module.eb-app.beanstalk_application_name}"
  vpc_id                           = "${var.vpc_id}"
  ec2_subnet_ids                   = "${var.ec2_subnet_ids}"
  elb_subnet_ids                   = "${var.elb_subnet_ids}"
  elb_loadbalancer_security_groups = "${var.elb_loadbalancer_security_groups}"
  auto_scaling_lc_security_groups  = "${var.auto_scaling_lc_security_groups}"
  solution_stack_name              = "${var.solution_stack_name}"
  instance_type                    = "${var.instance_type}"
  asg_min_size                     = "${var.asg_min_size}"
  asg_max_size                     = "${var.asg_max_size}"
  owner                            = "${var.owner}"
  service                          = "${var.service}"
  env                              = "${var.env}"
  common_name                      = "${coalesce(var.common_name, null_resource.vars.triggers.cn)}"
  solution_stack_name              = "${var.solution_stack_name}"
  iam_role_id                      = "${var.iam_role_id}"
  iam_role_arn                     = "${var.iam_role_arn}"
  deploy_batch_size_type           = "${var.deploy_batch_size_type}"
  deploy_batch_size                = "${var.deploy_batch_size}"
  deploy_timeout                   = "${var.deploy_timeout}"
  healthcheck_url                  = "${var.healthcheck_url}"
  environment_suffix               = "${var.environment_suffix}"
  load_balancer_type               = "${var.load_balancer_type}"
}
