variable "aws_profile" {
  description = "AWS profile to use"
}

variable "application_name" {
  description = "EB app name"
  default     = ""
}

variable "app_name" {
  description = "App name to expose to service env var APP"
  default     = ""
}

variable "solution_stack_name" {
  description = "See EB documentation for valid values"
  default     = "64bit Amazon Linux 2016.09 v2.3.0 running Docker 1.11.2"
}

variable "instance_type" {
  description = "how much money do you want to spend?"
  default     = "c4.large"
}

variable "asg_min_size" {
  description = "how much money do you want to spend?"
  default     = 1
}

variable "asg_max_size" {
  description = "how much money do you want to spend?"
  default     = 1
}

variable "owner" {
  description = "who do you want to page"
  default     = "core-user@twitch.tv"
}

variable "service" {
  description = "repo name is probably fine"
  default     = "web/users-service"
}

variable "env" {
  description = "environment"
}

variable "common_name" {
  description = "common name?"
  default     = ""
}

variable "short_env" {
  default = {
    production = "prod"
  }
}

resource "null_resource" "vars" {
  triggers {
    cn  = "${replace("${lookup(var.short_env, var.env, var.env)}-${var.service}", "/", "-")}"
    srv = "${replace("${var.service}", "/", "-")}"
  }
}

# This is used to provide special cases for regional dns. i.e. us-west-2 is actually us-west2
variable "regional_dns" {
  type = "map"

  default {
    us-west-2 = "us-west2"
  }
}

variable "vpc_id" {
  description = "VPC ID to launch environment in"
  default     = ""
}

variable "ec2_subnet_ids" {
  description = "Subnet IDs to launch EC2 instances of environment in"
  default     = ""
}

variable "elb_subnet_ids" {
  description = "Subnet IDs to launch ELB of environment in"
  default     = ""
}

variable "elb_loadbalancer_security_groups" {
  description = "Security groups to associate with ELB"
  default     = ""
}

variable "auto_scaling_lc_security_groups" {
  description = "Security groups to associate with ELB ASG"
  default     = ""
}

variable "iam_role_id" {
  description = "ID of IAM role to use for beanstalk environment"
  default     = ""
}

variable "iam_role_arn" {
  description = "ARN of IAM role to use for beanstalk environment"
  default     = ""
}

variable "aws_region" {
  description = "AWS region to operate in."
  default     = "us-west-2"
}

variable "pretty_dns_env" {
  description = "Map environment names to their DNS counterparts"
  type        = "map"

  default {
    staging    = "dev"
    production = "prod"
  }
}

variable "dns_ttl" {
  default = 30
}

variable "deploy_batch_size_type" {
  description = "The type of number that is specified in BatchSize. Either 'Fixed' or 'Percentage'"
  default     = "Percentage"
}

variable "deploy_batch_size" {
  description = "Percentage or fixed number of Amazon EC2 instances in the Auto Scaling group on which to simultaneously perform deployments. Valid values vary per BatchSizeType setting."
  default     = 25
}

variable "deploy_timeout" {
  description = "Number of seconds to wait for an instance to complete executing commands"
  default     = 600
}

variable "healthcheck_url" {
  description = "Healthcheck URL. Even workers need to be health checked."
  default     = "/debug/running"
}

variable "environment_suffix" {
  description = "Suffix for the environment. This can be used to create multiple environments for the same repository"
  default     = "server"
}

output "common_name" {
  value = "${coalesce(var.common_name, null_resource.vars.triggers.cn)}"
}

variable "load_balancer_type" {
  description = "The type of load balancer for your environment."
  default     = "classic"
}

variable "action_arn" {
  description = "pagerduty sns topic"
}
