resource "aws_sns_topic" "games_images_topic" {
  name = "games_image-callback"
}

resource "aws_sqs_queue" "games_images_callback_jobs" {
  name = "games_images-callback-jobs"
  message_retention_seconds = 345600
}

data "aws_iam_policy_document" "sqs_policy" {
  statement {
    effect = "Allow"
    principals {
        type = "aws"
        identifiers = ["*"]
    }
    actions = ["sqs:Publish"]
    resources = ["${aws_sqs_queue.games_images_callback_jobs.arn}"]
    condition {
      test = "ArnEquals"
      variable = "aws:SourceArn"
      values = ["${aws_sns_topic.games_images_topic.arn}"]
    }
  }
}

resource "aws_sqs_queue_policy" "sqs_policy" {
  queue_url = "${aws_sqs_queue.games_images_callback_jobs.id}"

  policy = <<POLICY
  {
  "Version": "2012-10-17",
  "Statement": [
    {
      "Sid": "Sid1527013240579",
      "Effect": "Allow",
      "Principal": "*",
      "Action": "SQS:SendMessage",
      "Resource": "${aws_sqs_queue.games_images_callback_jobs.arn}",
      "Condition": {
        "ArnEquals": {
          "aws:SourceArn": "${aws_sns_topic.games_images_topic.arn}"
        }
      }
    }
  ]
}
  POLICY
}

resource "aws_sns_topic_subscription" "sqs_sns_sub" {
  topic_arn = "${aws_sns_topic.games_images_topic.arn}"
  protocol = "sqs"
  endpoint = "${aws_sqs_queue.games_images_callback_jobs.arn}"
}

data "aws_iam_policy_document" "sns_policy" {
  statement {
    effect = "Allow"
    principals {
      type = "AWS"
      identifiers = ["${var.upload_service_id}"]
    }
    actions = ["SNS:Publish"]
    resources = ["${aws_sns_topic.games_images_topic.arn}"]
  }
}

resource "aws_sns_topic_policy" "sns_policy" {
  arn = "${aws_sns_topic.games_images_topic.arn}"
  policy = "${data.aws_iam_policy_document.sns_policy.json}"
}
