provider "aws" {
  region = "us-west-2"
  profile = "twitch-service-piper-aws"
}

module "app" {
  source = "../modules/service"
  environment = "prod"
  iam_role_name = "piper-service"
}

output "iam_role_arn" {
  value = "${module.app.iam_role_arn}"
}

module "beanstalk_alb" {
  source = "../modules/environment_single"
  env = "prod"
  vpc_id = "vpc-dc5a89ba"
  ec2_subnet_ids = "subnet-2495117f,subnet-a08d8ae9,subnet-da58b5bc"
  elb_subnet_ids = "subnet-2495117f,subnet-a08d8ae9,subnet-da58b5bc"
  elb_loadbalancer_security_groups = "sg-da44fea0"
  auto_scaling_lc_security_groups = "sg-da44fea0"
  asg_min_size = "2"
  asg_max_size = "8"
  iam_role_id = "${module.app.iam_role_id}"
  iam_role_arn = "${module.app.iam_role_arn}"
  app_name = "piper-service"
  instance_type = "c4.2xlarge"
  owner = "shimingr@twitch.tv"
  aws_profile = "twitch-service-piper-aws"
  service = "insights/piper-service"
  solution_stack_name = "64bit Amazon Linux 2018.03 v2.12.14 running Docker 18.06.1-ce"
  load_balancer_type = "application"
  action_arn = "arn:aws:sns:us-west-2:452744562037:piper-production-alerts"
}

terraform {
  backend "s3" {
    bucket  = "twitch-service-piper-aws"
    key     = "tfstate/d8a/piper-service/terraform/production"
    region  = "us-west-2"
    profile = "twitch-service-piper-aws"
  }

  required_version = "~> 0.9"
}

variable "pagerduty_key" {}

module "elasticcache" {
  source = "../modules/elasticache"
  environment = "prod"
  app_name = "piper-service"
  subnet_ids = "subnet-2495117f,subnet-a08d8ae9,subnet-da58b5bc"
  engine = "redis"
  engine_version = "3.2.10"
  parameter_group_name = "default.redis3.2.cluster.on"
  node_type = "cache.m3.medium"
  security_group_ids = "sg-da44fea0"
  owner = "insights-team"
  pagerduty_key = "${var.pagerduty_key}"
  pagerduty_service = "PD9W637"
}

module "upload" {
  source = "../modules/upload_service"
  env = "prod"
  upload_service_id = "arn:aws:iam::435569175256:role/prod-upload-service"
  owner = "insights-team"
}
