#!/bin/bash

if [ ! $(which terraform) ]; then
  echo "Please install terraform and ensure it is in your $PATH"
  exit 1
fi

echo ""
echo "Running 'terraform get -update'"
terraform get -update
if [ $? -gt 0 ]; then
  echo "Failed running 'terraform get -update'"
  exit 1
fi

echo ""
echo "Running 'terraform init -upgrade'"
terraform init -upgrade

if [ $? -gt 0 ]; then
  echo "Failed running terraform init"
  exit 1
fi

exit 0