
provider "aws" {
  region = "us-west-2"
  profile = "twitch-service-piper-dev"
}

module "app" {
  source = "../modules/service"
  environment = "staging"
  iam_role_name = "piper-service"
}

output "iam_role_arn" {
  value = "${module.app.iam_role_arn}"
}

module "beanstalk_alb" {
  source = "../modules/environment_single"
  env = "staging"
  vpc_id = "vpc-2d57844b"
  ec2_subnet_ids = "subnet-bf46abd9,subnet-1380875a,subnet-518f0b0a"
  elb_subnet_ids = "subnet-bf46abd9,subnet-1380875a,subnet-518f0b0a"
  elb_loadbalancer_security_groups = "sg-804df7fa"
  auto_scaling_lc_security_groups = "sg-804df7fa"
  asg_min_size = "2"
  asg_max_size = "8"
  iam_role_id = "${module.app.iam_role_id}"
  iam_role_arn = "${module.app.iam_role_arn}"
  app_name = "piper-service"
  instance_type = "c4.2xlarge"
  owner = "shimingr@twitch.tv"
  service = "insights/piper-service"
  aws_profile= "twitch-service-piper-dev"
  solution_stack_name = "64bit Amazon Linux 2018.03 v2.12.14 running Docker 18.06.1-ce"
  load_balancer_type = "application"
  action_arn = "arn:aws:sns:us-west-2:895328872748:piper-staging-alerts"
}

terraform {
    backend "s3" {
        bucket  = "twitch-service-piper-dev"
        key     = "tfstate/d8a/piper-service/terraform/staging"
        region  = "us-west-2"
        profile = "twitch-service-piper-dev"
    }

    required_version = "~> 0.9"
}

variable "pagerduty_key" {}

module "elasticcache" {
  source = "../modules/elasticache"
  environment = "staging"
  app_name = "piper-service"
  subnet_ids = "subnet-bf46abd9,subnet-1380875a,subnet-518f0b0a"
  engine = "redis"
  engine_version = "3.2.10"
  parameter_group_name = "default.redis3.2.cluster.on"
  node_type = "cache.m3.medium"
  security_group_ids = "sg-804df7fa"
  owner = "insights-team"
  pagerduty_key = "${var.pagerduty_key}"
  pagerduty_service = "PD9W637"
}


module "upload" {
  source = "../modules/upload_service"
  env = "staging"
  upload_service_id = "arn:aws:iam::995367761609:role/staging-upload-service"
  owner = "insights-team"
}
