package integration

import (
	"fmt"
	"os"
	"testing"

	"code.justin.tv/foundation/twitchclient"
	piperclient "code.justin.tv/insights/piper-service/client"
	"code.justin.tv/insights/piper-service/tools/integration/tests"
)

func TestIntegration(t *testing.T) {
	serverAddr := os.Getenv("SERVER_ADDRESS")
	if serverAddr == "" {
		return
	}

	testClient, err := piperclient.NewClient(twitchclient.ClientConf{
		Host: serverAddr,
		Transport: twitchclient.TransportConf{
			MaxIdleConnsPerHost: 50,
		},
	})

	if err != nil {
		t.Fatalf(fmt.Sprintf("failed to set up piper client with serverAdd %v. err %v", serverAddr, err))
	}

	testGetGamesReports := &tests.TestGetGamesReports{PiperClient: testClient}
	t.Run("TestGetGamesReports", testGetGamesReports.Test)

	testGetExtensionsReports := &tests.TestGetExtensionsReports{PiperClient: testClient}
	t.Run("TestGetExtensionsReports", testGetExtensionsReports.Test)

	testGetModsReports := &tests.TestGetModsReports{PiperClient: testClient}
	t.Run("TestGetModsReports", testGetModsReports.Test)

	testGetOnePager := &tests.TestGetOnePager{PiperClient: testClient}
	t.Run("testGetOnePager", testGetOnePager.Test)

	testGetDropsReports := &tests.TestGetDropsReports{PiperClient: testClient}
	t.Run("TestGetDropsReports", testGetDropsReports.Test)
}
