package tests

import (
	"fmt"
	"testing"

	"code.justin.tv/foundation/twitchclient"
	piperclient "code.justin.tv/insights/piper-service/client"
	"github.com/stretchr/testify/assert"
	"golang.org/x/net/context"
)

var (
	dropDomain     = "drops"
	resourceID     = "768c6dac-340e-4e8e-ab01-dc17a9bf9865"
	validStaffUser = "155668964"
	orgID          = "d32de13d-937e-4196-8198-1a7f875f295a"
)

type TestGetDropsReports struct {
	PiperClient piperclient.Client
}

func (f *TestGetDropsReports) Test(t *testing.T) {
	runTests(t,
		testCase{"TestGetDropsReportURL", f.TestGetDropsReportURL},
	)

	fmt.Println("Passed all tests in TestGetDropsReports.")
}

func (f *TestGetDropsReports) TestGetDropsReportURL(t *testing.T) {
	url, err := f.PiperClient.GetReportURL(context.Background(), validStaffUser, dropDomain, resourceID, "campaigns_overview", "latest", orgID, &twitchclient.ReqOpts{})
	assert.Nil(t, err)
	checkPresignedURL(t, url)

	fmt.Printf("Passed TestGetDropsReportURL")
}
