package tests

import (
	"testing"

	"code.justin.tv/insights/piper-service/models"

	"fmt"

	"code.justin.tv/foundation/twitchclient"
	piperclient "code.justin.tv/insights/piper-service/client"
	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
	"golang.org/x/net/context"
)

var (
	extDomain = "extensions"
	extUser   = "155668964"
	extID     = "mmfg25fceolzgjfu21oo3j5wu9v82s"

	extOrgUser    = "135051786"
	extNonOrgUser = "1"
	extOrgID      = "v3q54fdl6yms0jbcxlaq8lr02xpitf"
)

type TestGetExtensionsReports struct {
	PiperClient piperclient.Client
}

func (f *TestGetExtensionsReports) Test(t *testing.T) {
	runTests(t,
		testCase{"TestGetExtensionsReportType", f.TestGetExtensionsReportType},
		testCase{"TestGetExtensionsReportURL", f.TestGetExtensionsReportURL},
		testCase{"TestGetExtensionsReportRBAC", f.TestGetExtensionsReportRBAC},
	)

	fmt.Println("Passed all tests in TestGetExtensionsReports.")
}

func (f *TestGetExtensionsReports) TestGetExtensionsReportType(t *testing.T) {
	result, err := f.PiperClient.GetReportTypes(context.Background(), extUser, extDomain, extID, &twitchclient.ReqOpts{})

	if err != nil {
		t.Fatal("Failed TestGetExtensionsReportType.", err)
	}

	assert.NotNil(t, result)
	assert.Contains(t, result.Key.ReportTypes, reportType)

	fmt.Println("Passed TestGetExtensionsReportType.")
}

func (f *TestGetExtensionsReports) TestGetExtensionsReportRBAC(t *testing.T) {
	// test org user's access to extension not created by them and in their org.
	result, err := f.PiperClient.GetReportTypes(context.Background(), extOrgUser, extDomain, extOrgID, &twitchclient.ReqOpts{})
	require.NotNil(t, err)
	require.Len(t, result.Key.ReportTypes, 0, "extension is expected to have no reports")

	// user not in org shouldn't have access
	_, err = f.PiperClient.GetReportTypes(context.Background(), extNonOrgUser, extDomain, extOrgID, &twitchclient.ReqOpts{})
	checkError(t, models.ErrAccessForbidden, err, "user not in org")

	fmt.Println("Passed TestGetExtensionsReportType.")
}

func (f *TestGetExtensionsReports) TestGetExtensionsReportURL(t *testing.T) {
	signedurl, err := f.PiperClient.GetReportURL(context.Background(), extUser, extDomain, extID, reportType, instance, "", &twitchclient.ReqOpts{})

	if err != nil {
		t.Fatal(t, "Failed TestGetExtensionsReportURL.", err)
	}

	checkPresignedURL(t, signedurl)

	fmt.Println("Passed TestGetExtensionsReportURL.")
}
