package tests

import (
	"code.justin.tv/foundation/twitchclient"

	"context"
	"testing"

	piperclient "code.justin.tv/insights/piper-service/client"
	"github.com/stretchr/testify/assert"
)

var (
	modDomain = "mods"
	modUser   = "56761389"
	modID     = "261725"
)

type TestGetModsReports struct {
	PiperClient piperclient.Client
}

func (f *TestGetModsReports) Test(t *testing.T) {
	runTests(t,
		testCase{"TestGeModsReportType", f.TestGeModsReportType},
		testCase{"TestGetModsReportUrlLatest", f.TestGetModsReportUrlLatest},
	)
}

func (f *TestGetModsReports) TestGeModsReportType(t *testing.T) {
	result, err := f.PiperClient.GetReports(context.Background(), modUser, modDomain, &twitchclient.ReqOpts{})
	assert.NotEqual(t, 0, len(result.Key))
	assert.Nil(t, err)
}

func (f *TestGetModsReports) TestGetModsReportUrlLatest(t *testing.T) {
	result, err := f.PiperClient.GetReportUrlLatest(context.Background(), modUser, modDomain, modID, "overview_v1", &twitchclient.ReqOpts{})
	assert.NotNil(t, result)
	assert.Nil(t, err)
}
