package tests

import (
	"context"
	"encoding/json"
	"testing"

	"code.justin.tv/foundation/twitchclient"
	"code.justin.tv/insights/piper-service/models"

	"fmt"

	piperclient "code.justin.tv/insights/piper-service/client"
	"code.justin.tv/insights/piper-service/internal/utils"
)

var (
	onePagerUserID              = "135051786" // visage_test, test user, owning twitch gaming
	onePagerGameID              = "743"       // chess
	onePagerNoAccessGameID      = "21779"     // League Of Legends
	onePagerDefaultReportGameID = "495455"    // Twitch Drops Demo
	year                        = 2018        // the time which staging holds, staging and prod sometimes has differences in data
	quarter                     = 3
)

type TestGetOnePager struct {
	PiperClient piperclient.Client
}

func (f *TestGetOnePager) Test(t *testing.T) {
	runTests(t,
		testCase{"TestGetOnePagerWithAllData", f.TestGetOnePagerWithAllData},
		testCase{"TestGetOnePagerWithAllDefaultData", f.TestGetOnePagerWithAllDefaultData},
		testCase{"TestGetOnePagerWithNoAccess", f.TestGetOnePagerWithNoAccess},
	)

	fmt.Println("Passed all tests in TestGetOnePager.")
}

func (f *TestGetOnePager) TestGetOnePagerWithAllData(t *testing.T) {
	resp, err := f.PiperClient.GetGamesOnePagerData(context.Background(), onePagerUserID, onePagerGameID, quarter, year, false, &twitchclient.ReqOpts{})
	if err != nil {
		t.Fatal(t, "Failed TestGetOnePagerWithAllData.", err)
	}

	var expectedResp models.GameOnePagerDataResponse
	err = json.Unmarshal([]byte(onePagerWithFullDataStr), &expectedResp)
	if err != nil {
		t.Fatal(t, "Failed TestGetOnePagerWithAllData.", err)
	}

	if diff := utils.Equal(resp, expectedResp); diff != nil {
		t.Fatal(diff)
	}
}

func (f *TestGetOnePager) TestGetOnePagerWithAllDefaultData(t *testing.T) {
	resp, err := f.PiperClient.GetGamesOnePagerData(context.Background(), onePagerUserID, onePagerDefaultReportGameID, quarter, year, false, &twitchclient.ReqOpts{})
	if err != nil {
		t.Fatal(t, "Failed TestGetOnePagerWithAllDefaultData.", err)
	}

	var expectedResp models.GameOnePagerDataResponse
	err = json.Unmarshal([]byte(onePagerWithDefaultDataStr), &expectedResp)
	if err != nil {
		t.Fatal(t, "Failed TestGetOnePagerWithAllDefaultData.", err)
	}

	if diff := utils.Equal(resp, expectedResp); diff != nil {
		t.Fatal(diff)
	}
}

func (f *TestGetOnePager) TestGetOnePagerWithNoAccess(t *testing.T) {
	_, err := f.PiperClient.GetGamesOnePagerData(context.Background(), onePagerUserID, onePagerNoAccessGameID, quarter, year, false, &twitchclient.ReqOpts{})
	checkError(t, models.ErrAccessForbidden, err, "TestGetOnePagerWithNoAccess")
}
