// Code generated by protoc-gen-twirp v5.3.0, DO NOT EDIT.
// source: rpc/rbacrpc/rbacrpc.proto

/*
Package rbacrpc is a generated twirp stub package.
This code was generated with github.com/twitchtv/twirp/protoc-gen-twirp v5.3.0.

It is generated from these files:
	rpc/rbacrpc/rbacrpc.proto
*/
package rbacrpc

import bytes "bytes"
import strings "strings"
import context "context"
import fmt "fmt"
import ioutil "io/ioutil"
import http "net/http"

import jsonpb "github.com/golang/protobuf/jsonpb"
import proto "github.com/golang/protobuf/proto"
import twirp "github.com/twitchtv/twirp"
import ctxsetters "github.com/twitchtv/twirp/ctxsetters"

// Imports only used by utility functions:
import io "io"
import strconv "strconv"
import json "encoding/json"
import url "net/url"

// ==============
// RBAC Interface
// ==============

// RBAC Is the original service that evolved to have too much functionality.
// We are slowly moving away from this god-service in favor of more focused services.
type RBAC interface {
	// List all companies. Administrative endpoint
	ListCompanies(context.Context, *ListCompaniesRequest) (*ListCompaniesResponse, error)

	// List memberships by user twitch ID; the orgs that the user is member of, with permissions for that role.
	ListCompanyMemberships(context.Context, *ListCompanyMembershipsRequest) (*ListCompanyMembershipsResponse, error)

	SearchCompanies(context.Context, *SearchCompaniesRequest) (*SearchCompaniesResponse, error)

	GetCompany(context.Context, *Id) (*Company, error)

	UpdateCompany(context.Context, *UpdateCompanyRequest) (*Company, error)

	// Creates an applicaton for a company. Company applications are manually reviewed in Vienna to ensure the company and requesting user have rights to the games they are requesting. When an application does not have games, it is auto approved and the company is created. The created company has the same ID as the application thus the ID returned will be the company ID when there are games.
	CreateCompanyApplication(context.Context, *CreateCompanyApplicationRequest) (*CompanyApplication, error)

	// Get membership data for a user in an organization.
	// Some data is protected to the same user or whitelisted-admins, and will be empty for other users
	GetMembership(context.Context, *GetMembershipRequest) (*Membership, error)

	// List memberships by company ID; the users that belong to the org with their roles.
	GetUsersByCompanyId(context.Context, *GetUsersByCompanyIdRequest) (*GetUsersByCompanyIdResponse, error)

	AddUserToCompany(context.Context, *AddUserToCompanyRequest) (*Empty, error)

	RemoveCompanyMembership(context.Context, *RemoveCompanyMembershipRequest) (*Empty, error)

	UpdateUser(context.Context, *UpdateUserRequest) (*Empty, error)

	UpdateUserRole(context.Context, *UpdateUserRoleRequest) (*Membership, error)

	// List all roles, e.g. "Owner", "Manager", "Billing_Manager", etc.
	ListAllRoles(context.Context, *Empty) (*ListAllRolesResponse, error)

	// Validates if a twitch user has permission to resource. Resource is specificed as a resource type (namespace) and unique resource identifier.
	// Returns twirp NotFound with msg "resource" when resource is not found
	ValidateByTwitchID(context.Context, *ValidateQuery) (*ValidateResponse, error)

	// Creates a new resource and adds it to a company.
	// It only validates that the resource is wellformed and not duplicated.
	// Other specific validations should be done in the service that is using RBAC.
	CreateResource(context.Context, *CreateResourceRequest) (*CreateResourceResponse, error)

	// Get all resources by company and optionally type. May not be used yet
	// in production. It's for demo purposes of RBAC supporting new resource_types.
	ListResources(context.Context, *ListResourcesRequest) (*ListResourcesResponse, error)

	// Set the assigned billing manager for an extension in an organization.
	// The assigned organization member needs to have the Billing Manager role or be an Owner.
	SetExtensionBillingManager(context.Context, *SetExtensionBillingManagerRequest) (*SetExtensionBillingManagerResponse, error)

	// Get get extension billing managers for the specified extension client IDs
	GetExtensionBillingManager(context.Context, *GetExtensionBillingManagerRequest) (*GetExtensionBillingManagerResponse, error)

	TransferExtensionToCompany(context.Context, *TransferExtensionRequest) (*Empty, error)

	DetachExtensionFromCompany(context.Context, *DetachExtensionRequest) (*Empty, error)

	ListCompanyApplications(context.Context, *ListCompanyApplicationsRequest) (*ListCompanyApplicationsResponse, error)

	SearchCompanyApplications(context.Context, *SearchCompanyApplicationsRequest) (*SearchCompanyApplicationsResponse, error)

	GetCompanyApplication(context.Context, *Id) (*CompanyApplication, error)

	UpdateCompanyApplication(context.Context, *UpdateCompanyApplicationRequest) (*CompanyApplication, error)

	DeleteCompanyApplication(context.Context, *DeleteCompanyApplicationRequest) (*Empty, error)

	OnboardCompany(context.Context, *OnboardCompanyRequest) (*OnboardCompanyResponse, error)

	ListGameApplications(context.Context, *ListGameApplicationsRequest) (*ListGameApplicationsResponse, error)

	GetGameApplicationsByCompany(context.Context, *Id) (*GetGameApplicationsByCompanyResponse, error)

	CreateGameApplication(context.Context, *CreateGameApplicationRequest) (*GameApplication, error)

	DeleteGameApplication(context.Context, *DeleteGameApplicationRequest) (*Empty, error)

	OnboardGame(context.Context, *OnboardGameRequest) (*OnboardGameResponse, error)

	GetDeveloperApplications(context.Context, *GetDeveloperApplicationsRequest) (*GetDeveloperApplicationsResponse, error)

	DeleteDeveloperApplication(context.Context, *DeleteDeveloperApplicationRequest) (*Empty, error)

	OnboardDeveloper(context.Context, *OnboardDeveloperRequest) (*OnboardDeveloperResponse, error)

	GetGamesByCompany(context.Context, *Id) (*GetGamesByCompanyResponse, error)

	GetGamesByTwitchID(context.Context, *Id) (*GetGamesByTwitchIDResponse, error)

	// DEPRECATED: when multi-org is released, this will return the first of many possible companies.
	// Use ListCompanyMemberships instead of this endpoint.
	GetCompanyByTwitchID(context.Context, *Id) (*Company, error)

	CreateJWT(context.Context, *JWTRequest) (*JWT, error)

	GetAllGamesWithCompanies(context.Context, *GetAllGamesWithCompaniesRequest) (*GetAllGamesWithCompaniesResponse, error)

	// check if a feature gating is turned on
	IsFeatureEnabled(context.Context, *IsFeatureEnabledRequest) (*FeatureEnabledResponse, error)

	// check if a value is in the whitelist of a feature gating
	IsValueEnabled(context.Context, *IsValueEnabledRequest) (*FeatureEnabledResponse, error)
}

// ====================
// RBAC Protobuf Client
// ====================

type rBACProtobufClient struct {
	client HTTPClient
	urls   [41]string
}

// NewRBACProtobufClient creates a Protobuf client that implements the RBAC interface.
// It communicates using Protobuf and can be configured with a custom HTTPClient.
func NewRBACProtobufClient(addr string, client HTTPClient) RBAC {
	prefix := urlBase(addr) + RBACPathPrefix
	urls := [41]string{
		prefix + "ListCompanies",
		prefix + "ListCompanyMemberships",
		prefix + "SearchCompanies",
		prefix + "GetCompany",
		prefix + "UpdateCompany",
		prefix + "CreateCompanyApplication",
		prefix + "GetMembership",
		prefix + "GetUsersByCompanyId",
		prefix + "AddUserToCompany",
		prefix + "RemoveCompanyMembership",
		prefix + "UpdateUser",
		prefix + "UpdateUserRole",
		prefix + "ListAllRoles",
		prefix + "ValidateByTwitchID",
		prefix + "CreateResource",
		prefix + "ListResources",
		prefix + "SetExtensionBillingManager",
		prefix + "GetExtensionBillingManager",
		prefix + "TransferExtensionToCompany",
		prefix + "DetachExtensionFromCompany",
		prefix + "ListCompanyApplications",
		prefix + "SearchCompanyApplications",
		prefix + "GetCompanyApplication",
		prefix + "UpdateCompanyApplication",
		prefix + "DeleteCompanyApplication",
		prefix + "OnboardCompany",
		prefix + "ListGameApplications",
		prefix + "GetGameApplicationsByCompany",
		prefix + "CreateGameApplication",
		prefix + "DeleteGameApplication",
		prefix + "OnboardGame",
		prefix + "GetDeveloperApplications",
		prefix + "DeleteDeveloperApplication",
		prefix + "OnboardDeveloper",
		prefix + "GetGamesByCompany",
		prefix + "GetGamesByTwitchID",
		prefix + "GetCompanyByTwitchID",
		prefix + "CreateJWT",
		prefix + "GetAllGamesWithCompanies",
		prefix + "IsFeatureEnabled",
		prefix + "IsValueEnabled",
	}
	if httpClient, ok := client.(*http.Client); ok {
		return &rBACProtobufClient{
			client: withoutRedirects(httpClient),
			urls:   urls,
		}
	}
	return &rBACProtobufClient{
		client: client,
		urls:   urls,
	}
}

func (c *rBACProtobufClient) ListCompanies(ctx context.Context, in *ListCompaniesRequest) (*ListCompaniesResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.devrel.rbac")
	ctx = ctxsetters.WithServiceName(ctx, "RBAC")
	ctx = ctxsetters.WithMethodName(ctx, "ListCompanies")
	out := new(ListCompaniesResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[0], in, out)
	return out, err
}

func (c *rBACProtobufClient) ListCompanyMemberships(ctx context.Context, in *ListCompanyMembershipsRequest) (*ListCompanyMembershipsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.devrel.rbac")
	ctx = ctxsetters.WithServiceName(ctx, "RBAC")
	ctx = ctxsetters.WithMethodName(ctx, "ListCompanyMemberships")
	out := new(ListCompanyMembershipsResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[1], in, out)
	return out, err
}

func (c *rBACProtobufClient) SearchCompanies(ctx context.Context, in *SearchCompaniesRequest) (*SearchCompaniesResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.devrel.rbac")
	ctx = ctxsetters.WithServiceName(ctx, "RBAC")
	ctx = ctxsetters.WithMethodName(ctx, "SearchCompanies")
	out := new(SearchCompaniesResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[2], in, out)
	return out, err
}

func (c *rBACProtobufClient) GetCompany(ctx context.Context, in *Id) (*Company, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.devrel.rbac")
	ctx = ctxsetters.WithServiceName(ctx, "RBAC")
	ctx = ctxsetters.WithMethodName(ctx, "GetCompany")
	out := new(Company)
	err := doProtobufRequest(ctx, c.client, c.urls[3], in, out)
	return out, err
}

func (c *rBACProtobufClient) UpdateCompany(ctx context.Context, in *UpdateCompanyRequest) (*Company, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.devrel.rbac")
	ctx = ctxsetters.WithServiceName(ctx, "RBAC")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateCompany")
	out := new(Company)
	err := doProtobufRequest(ctx, c.client, c.urls[4], in, out)
	return out, err
}

func (c *rBACProtobufClient) CreateCompanyApplication(ctx context.Context, in *CreateCompanyApplicationRequest) (*CompanyApplication, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.devrel.rbac")
	ctx = ctxsetters.WithServiceName(ctx, "RBAC")
	ctx = ctxsetters.WithMethodName(ctx, "CreateCompanyApplication")
	out := new(CompanyApplication)
	err := doProtobufRequest(ctx, c.client, c.urls[5], in, out)
	return out, err
}

func (c *rBACProtobufClient) GetMembership(ctx context.Context, in *GetMembershipRequest) (*Membership, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.devrel.rbac")
	ctx = ctxsetters.WithServiceName(ctx, "RBAC")
	ctx = ctxsetters.WithMethodName(ctx, "GetMembership")
	out := new(Membership)
	err := doProtobufRequest(ctx, c.client, c.urls[6], in, out)
	return out, err
}

func (c *rBACProtobufClient) GetUsersByCompanyId(ctx context.Context, in *GetUsersByCompanyIdRequest) (*GetUsersByCompanyIdResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.devrel.rbac")
	ctx = ctxsetters.WithServiceName(ctx, "RBAC")
	ctx = ctxsetters.WithMethodName(ctx, "GetUsersByCompanyId")
	out := new(GetUsersByCompanyIdResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[7], in, out)
	return out, err
}

func (c *rBACProtobufClient) AddUserToCompany(ctx context.Context, in *AddUserToCompanyRequest) (*Empty, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.devrel.rbac")
	ctx = ctxsetters.WithServiceName(ctx, "RBAC")
	ctx = ctxsetters.WithMethodName(ctx, "AddUserToCompany")
	out := new(Empty)
	err := doProtobufRequest(ctx, c.client, c.urls[8], in, out)
	return out, err
}

func (c *rBACProtobufClient) RemoveCompanyMembership(ctx context.Context, in *RemoveCompanyMembershipRequest) (*Empty, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.devrel.rbac")
	ctx = ctxsetters.WithServiceName(ctx, "RBAC")
	ctx = ctxsetters.WithMethodName(ctx, "RemoveCompanyMembership")
	out := new(Empty)
	err := doProtobufRequest(ctx, c.client, c.urls[9], in, out)
	return out, err
}

func (c *rBACProtobufClient) UpdateUser(ctx context.Context, in *UpdateUserRequest) (*Empty, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.devrel.rbac")
	ctx = ctxsetters.WithServiceName(ctx, "RBAC")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateUser")
	out := new(Empty)
	err := doProtobufRequest(ctx, c.client, c.urls[10], in, out)
	return out, err
}

func (c *rBACProtobufClient) UpdateUserRole(ctx context.Context, in *UpdateUserRoleRequest) (*Membership, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.devrel.rbac")
	ctx = ctxsetters.WithServiceName(ctx, "RBAC")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateUserRole")
	out := new(Membership)
	err := doProtobufRequest(ctx, c.client, c.urls[11], in, out)
	return out, err
}

func (c *rBACProtobufClient) ListAllRoles(ctx context.Context, in *Empty) (*ListAllRolesResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.devrel.rbac")
	ctx = ctxsetters.WithServiceName(ctx, "RBAC")
	ctx = ctxsetters.WithMethodName(ctx, "ListAllRoles")
	out := new(ListAllRolesResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[12], in, out)
	return out, err
}

func (c *rBACProtobufClient) ValidateByTwitchID(ctx context.Context, in *ValidateQuery) (*ValidateResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.devrel.rbac")
	ctx = ctxsetters.WithServiceName(ctx, "RBAC")
	ctx = ctxsetters.WithMethodName(ctx, "ValidateByTwitchID")
	out := new(ValidateResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[13], in, out)
	return out, err
}

func (c *rBACProtobufClient) CreateResource(ctx context.Context, in *CreateResourceRequest) (*CreateResourceResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.devrel.rbac")
	ctx = ctxsetters.WithServiceName(ctx, "RBAC")
	ctx = ctxsetters.WithMethodName(ctx, "CreateResource")
	out := new(CreateResourceResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[14], in, out)
	return out, err
}

func (c *rBACProtobufClient) ListResources(ctx context.Context, in *ListResourcesRequest) (*ListResourcesResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.devrel.rbac")
	ctx = ctxsetters.WithServiceName(ctx, "RBAC")
	ctx = ctxsetters.WithMethodName(ctx, "ListResources")
	out := new(ListResourcesResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[15], in, out)
	return out, err
}

func (c *rBACProtobufClient) SetExtensionBillingManager(ctx context.Context, in *SetExtensionBillingManagerRequest) (*SetExtensionBillingManagerResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.devrel.rbac")
	ctx = ctxsetters.WithServiceName(ctx, "RBAC")
	ctx = ctxsetters.WithMethodName(ctx, "SetExtensionBillingManager")
	out := new(SetExtensionBillingManagerResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[16], in, out)
	return out, err
}

func (c *rBACProtobufClient) GetExtensionBillingManager(ctx context.Context, in *GetExtensionBillingManagerRequest) (*GetExtensionBillingManagerResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.devrel.rbac")
	ctx = ctxsetters.WithServiceName(ctx, "RBAC")
	ctx = ctxsetters.WithMethodName(ctx, "GetExtensionBillingManager")
	out := new(GetExtensionBillingManagerResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[17], in, out)
	return out, err
}

func (c *rBACProtobufClient) TransferExtensionToCompany(ctx context.Context, in *TransferExtensionRequest) (*Empty, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.devrel.rbac")
	ctx = ctxsetters.WithServiceName(ctx, "RBAC")
	ctx = ctxsetters.WithMethodName(ctx, "TransferExtensionToCompany")
	out := new(Empty)
	err := doProtobufRequest(ctx, c.client, c.urls[18], in, out)
	return out, err
}

func (c *rBACProtobufClient) DetachExtensionFromCompany(ctx context.Context, in *DetachExtensionRequest) (*Empty, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.devrel.rbac")
	ctx = ctxsetters.WithServiceName(ctx, "RBAC")
	ctx = ctxsetters.WithMethodName(ctx, "DetachExtensionFromCompany")
	out := new(Empty)
	err := doProtobufRequest(ctx, c.client, c.urls[19], in, out)
	return out, err
}

func (c *rBACProtobufClient) ListCompanyApplications(ctx context.Context, in *ListCompanyApplicationsRequest) (*ListCompanyApplicationsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.devrel.rbac")
	ctx = ctxsetters.WithServiceName(ctx, "RBAC")
	ctx = ctxsetters.WithMethodName(ctx, "ListCompanyApplications")
	out := new(ListCompanyApplicationsResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[20], in, out)
	return out, err
}

func (c *rBACProtobufClient) SearchCompanyApplications(ctx context.Context, in *SearchCompanyApplicationsRequest) (*SearchCompanyApplicationsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.devrel.rbac")
	ctx = ctxsetters.WithServiceName(ctx, "RBAC")
	ctx = ctxsetters.WithMethodName(ctx, "SearchCompanyApplications")
	out := new(SearchCompanyApplicationsResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[21], in, out)
	return out, err
}

func (c *rBACProtobufClient) GetCompanyApplication(ctx context.Context, in *Id) (*CompanyApplication, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.devrel.rbac")
	ctx = ctxsetters.WithServiceName(ctx, "RBAC")
	ctx = ctxsetters.WithMethodName(ctx, "GetCompanyApplication")
	out := new(CompanyApplication)
	err := doProtobufRequest(ctx, c.client, c.urls[22], in, out)
	return out, err
}

func (c *rBACProtobufClient) UpdateCompanyApplication(ctx context.Context, in *UpdateCompanyApplicationRequest) (*CompanyApplication, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.devrel.rbac")
	ctx = ctxsetters.WithServiceName(ctx, "RBAC")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateCompanyApplication")
	out := new(CompanyApplication)
	err := doProtobufRequest(ctx, c.client, c.urls[23], in, out)
	return out, err
}

func (c *rBACProtobufClient) DeleteCompanyApplication(ctx context.Context, in *DeleteCompanyApplicationRequest) (*Empty, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.devrel.rbac")
	ctx = ctxsetters.WithServiceName(ctx, "RBAC")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteCompanyApplication")
	out := new(Empty)
	err := doProtobufRequest(ctx, c.client, c.urls[24], in, out)
	return out, err
}

func (c *rBACProtobufClient) OnboardCompany(ctx context.Context, in *OnboardCompanyRequest) (*OnboardCompanyResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.devrel.rbac")
	ctx = ctxsetters.WithServiceName(ctx, "RBAC")
	ctx = ctxsetters.WithMethodName(ctx, "OnboardCompany")
	out := new(OnboardCompanyResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[25], in, out)
	return out, err
}

func (c *rBACProtobufClient) ListGameApplications(ctx context.Context, in *ListGameApplicationsRequest) (*ListGameApplicationsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.devrel.rbac")
	ctx = ctxsetters.WithServiceName(ctx, "RBAC")
	ctx = ctxsetters.WithMethodName(ctx, "ListGameApplications")
	out := new(ListGameApplicationsResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[26], in, out)
	return out, err
}

func (c *rBACProtobufClient) GetGameApplicationsByCompany(ctx context.Context, in *Id) (*GetGameApplicationsByCompanyResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.devrel.rbac")
	ctx = ctxsetters.WithServiceName(ctx, "RBAC")
	ctx = ctxsetters.WithMethodName(ctx, "GetGameApplicationsByCompany")
	out := new(GetGameApplicationsByCompanyResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[27], in, out)
	return out, err
}

func (c *rBACProtobufClient) CreateGameApplication(ctx context.Context, in *CreateGameApplicationRequest) (*GameApplication, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.devrel.rbac")
	ctx = ctxsetters.WithServiceName(ctx, "RBAC")
	ctx = ctxsetters.WithMethodName(ctx, "CreateGameApplication")
	out := new(GameApplication)
	err := doProtobufRequest(ctx, c.client, c.urls[28], in, out)
	return out, err
}

func (c *rBACProtobufClient) DeleteGameApplication(ctx context.Context, in *DeleteGameApplicationRequest) (*Empty, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.devrel.rbac")
	ctx = ctxsetters.WithServiceName(ctx, "RBAC")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteGameApplication")
	out := new(Empty)
	err := doProtobufRequest(ctx, c.client, c.urls[29], in, out)
	return out, err
}

func (c *rBACProtobufClient) OnboardGame(ctx context.Context, in *OnboardGameRequest) (*OnboardGameResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.devrel.rbac")
	ctx = ctxsetters.WithServiceName(ctx, "RBAC")
	ctx = ctxsetters.WithMethodName(ctx, "OnboardGame")
	out := new(OnboardGameResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[30], in, out)
	return out, err
}

func (c *rBACProtobufClient) GetDeveloperApplications(ctx context.Context, in *GetDeveloperApplicationsRequest) (*GetDeveloperApplicationsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.devrel.rbac")
	ctx = ctxsetters.WithServiceName(ctx, "RBAC")
	ctx = ctxsetters.WithMethodName(ctx, "GetDeveloperApplications")
	out := new(GetDeveloperApplicationsResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[31], in, out)
	return out, err
}

func (c *rBACProtobufClient) DeleteDeveloperApplication(ctx context.Context, in *DeleteDeveloperApplicationRequest) (*Empty, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.devrel.rbac")
	ctx = ctxsetters.WithServiceName(ctx, "RBAC")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteDeveloperApplication")
	out := new(Empty)
	err := doProtobufRequest(ctx, c.client, c.urls[32], in, out)
	return out, err
}

func (c *rBACProtobufClient) OnboardDeveloper(ctx context.Context, in *OnboardDeveloperRequest) (*OnboardDeveloperResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.devrel.rbac")
	ctx = ctxsetters.WithServiceName(ctx, "RBAC")
	ctx = ctxsetters.WithMethodName(ctx, "OnboardDeveloper")
	out := new(OnboardDeveloperResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[33], in, out)
	return out, err
}

func (c *rBACProtobufClient) GetGamesByCompany(ctx context.Context, in *Id) (*GetGamesByCompanyResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.devrel.rbac")
	ctx = ctxsetters.WithServiceName(ctx, "RBAC")
	ctx = ctxsetters.WithMethodName(ctx, "GetGamesByCompany")
	out := new(GetGamesByCompanyResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[34], in, out)
	return out, err
}

func (c *rBACProtobufClient) GetGamesByTwitchID(ctx context.Context, in *Id) (*GetGamesByTwitchIDResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.devrel.rbac")
	ctx = ctxsetters.WithServiceName(ctx, "RBAC")
	ctx = ctxsetters.WithMethodName(ctx, "GetGamesByTwitchID")
	out := new(GetGamesByTwitchIDResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[35], in, out)
	return out, err
}

func (c *rBACProtobufClient) GetCompanyByTwitchID(ctx context.Context, in *Id) (*Company, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.devrel.rbac")
	ctx = ctxsetters.WithServiceName(ctx, "RBAC")
	ctx = ctxsetters.WithMethodName(ctx, "GetCompanyByTwitchID")
	out := new(Company)
	err := doProtobufRequest(ctx, c.client, c.urls[36], in, out)
	return out, err
}

func (c *rBACProtobufClient) CreateJWT(ctx context.Context, in *JWTRequest) (*JWT, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.devrel.rbac")
	ctx = ctxsetters.WithServiceName(ctx, "RBAC")
	ctx = ctxsetters.WithMethodName(ctx, "CreateJWT")
	out := new(JWT)
	err := doProtobufRequest(ctx, c.client, c.urls[37], in, out)
	return out, err
}

func (c *rBACProtobufClient) GetAllGamesWithCompanies(ctx context.Context, in *GetAllGamesWithCompaniesRequest) (*GetAllGamesWithCompaniesResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.devrel.rbac")
	ctx = ctxsetters.WithServiceName(ctx, "RBAC")
	ctx = ctxsetters.WithMethodName(ctx, "GetAllGamesWithCompanies")
	out := new(GetAllGamesWithCompaniesResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[38], in, out)
	return out, err
}

func (c *rBACProtobufClient) IsFeatureEnabled(ctx context.Context, in *IsFeatureEnabledRequest) (*FeatureEnabledResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.devrel.rbac")
	ctx = ctxsetters.WithServiceName(ctx, "RBAC")
	ctx = ctxsetters.WithMethodName(ctx, "IsFeatureEnabled")
	out := new(FeatureEnabledResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[39], in, out)
	return out, err
}

func (c *rBACProtobufClient) IsValueEnabled(ctx context.Context, in *IsValueEnabledRequest) (*FeatureEnabledResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.devrel.rbac")
	ctx = ctxsetters.WithServiceName(ctx, "RBAC")
	ctx = ctxsetters.WithMethodName(ctx, "IsValueEnabled")
	out := new(FeatureEnabledResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[40], in, out)
	return out, err
}

// ================
// RBAC JSON Client
// ================

type rBACJSONClient struct {
	client HTTPClient
	urls   [41]string
}

// NewRBACJSONClient creates a JSON client that implements the RBAC interface.
// It communicates using JSON and can be configured with a custom HTTPClient.
func NewRBACJSONClient(addr string, client HTTPClient) RBAC {
	prefix := urlBase(addr) + RBACPathPrefix
	urls := [41]string{
		prefix + "ListCompanies",
		prefix + "ListCompanyMemberships",
		prefix + "SearchCompanies",
		prefix + "GetCompany",
		prefix + "UpdateCompany",
		prefix + "CreateCompanyApplication",
		prefix + "GetMembership",
		prefix + "GetUsersByCompanyId",
		prefix + "AddUserToCompany",
		prefix + "RemoveCompanyMembership",
		prefix + "UpdateUser",
		prefix + "UpdateUserRole",
		prefix + "ListAllRoles",
		prefix + "ValidateByTwitchID",
		prefix + "CreateResource",
		prefix + "ListResources",
		prefix + "SetExtensionBillingManager",
		prefix + "GetExtensionBillingManager",
		prefix + "TransferExtensionToCompany",
		prefix + "DetachExtensionFromCompany",
		prefix + "ListCompanyApplications",
		prefix + "SearchCompanyApplications",
		prefix + "GetCompanyApplication",
		prefix + "UpdateCompanyApplication",
		prefix + "DeleteCompanyApplication",
		prefix + "OnboardCompany",
		prefix + "ListGameApplications",
		prefix + "GetGameApplicationsByCompany",
		prefix + "CreateGameApplication",
		prefix + "DeleteGameApplication",
		prefix + "OnboardGame",
		prefix + "GetDeveloperApplications",
		prefix + "DeleteDeveloperApplication",
		prefix + "OnboardDeveloper",
		prefix + "GetGamesByCompany",
		prefix + "GetGamesByTwitchID",
		prefix + "GetCompanyByTwitchID",
		prefix + "CreateJWT",
		prefix + "GetAllGamesWithCompanies",
		prefix + "IsFeatureEnabled",
		prefix + "IsValueEnabled",
	}
	if httpClient, ok := client.(*http.Client); ok {
		return &rBACJSONClient{
			client: withoutRedirects(httpClient),
			urls:   urls,
		}
	}
	return &rBACJSONClient{
		client: client,
		urls:   urls,
	}
}

func (c *rBACJSONClient) ListCompanies(ctx context.Context, in *ListCompaniesRequest) (*ListCompaniesResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.devrel.rbac")
	ctx = ctxsetters.WithServiceName(ctx, "RBAC")
	ctx = ctxsetters.WithMethodName(ctx, "ListCompanies")
	out := new(ListCompaniesResponse)
	err := doJSONRequest(ctx, c.client, c.urls[0], in, out)
	return out, err
}

func (c *rBACJSONClient) ListCompanyMemberships(ctx context.Context, in *ListCompanyMembershipsRequest) (*ListCompanyMembershipsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.devrel.rbac")
	ctx = ctxsetters.WithServiceName(ctx, "RBAC")
	ctx = ctxsetters.WithMethodName(ctx, "ListCompanyMemberships")
	out := new(ListCompanyMembershipsResponse)
	err := doJSONRequest(ctx, c.client, c.urls[1], in, out)
	return out, err
}

func (c *rBACJSONClient) SearchCompanies(ctx context.Context, in *SearchCompaniesRequest) (*SearchCompaniesResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.devrel.rbac")
	ctx = ctxsetters.WithServiceName(ctx, "RBAC")
	ctx = ctxsetters.WithMethodName(ctx, "SearchCompanies")
	out := new(SearchCompaniesResponse)
	err := doJSONRequest(ctx, c.client, c.urls[2], in, out)
	return out, err
}

func (c *rBACJSONClient) GetCompany(ctx context.Context, in *Id) (*Company, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.devrel.rbac")
	ctx = ctxsetters.WithServiceName(ctx, "RBAC")
	ctx = ctxsetters.WithMethodName(ctx, "GetCompany")
	out := new(Company)
	err := doJSONRequest(ctx, c.client, c.urls[3], in, out)
	return out, err
}

func (c *rBACJSONClient) UpdateCompany(ctx context.Context, in *UpdateCompanyRequest) (*Company, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.devrel.rbac")
	ctx = ctxsetters.WithServiceName(ctx, "RBAC")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateCompany")
	out := new(Company)
	err := doJSONRequest(ctx, c.client, c.urls[4], in, out)
	return out, err
}

func (c *rBACJSONClient) CreateCompanyApplication(ctx context.Context, in *CreateCompanyApplicationRequest) (*CompanyApplication, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.devrel.rbac")
	ctx = ctxsetters.WithServiceName(ctx, "RBAC")
	ctx = ctxsetters.WithMethodName(ctx, "CreateCompanyApplication")
	out := new(CompanyApplication)
	err := doJSONRequest(ctx, c.client, c.urls[5], in, out)
	return out, err
}

func (c *rBACJSONClient) GetMembership(ctx context.Context, in *GetMembershipRequest) (*Membership, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.devrel.rbac")
	ctx = ctxsetters.WithServiceName(ctx, "RBAC")
	ctx = ctxsetters.WithMethodName(ctx, "GetMembership")
	out := new(Membership)
	err := doJSONRequest(ctx, c.client, c.urls[6], in, out)
	return out, err
}

func (c *rBACJSONClient) GetUsersByCompanyId(ctx context.Context, in *GetUsersByCompanyIdRequest) (*GetUsersByCompanyIdResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.devrel.rbac")
	ctx = ctxsetters.WithServiceName(ctx, "RBAC")
	ctx = ctxsetters.WithMethodName(ctx, "GetUsersByCompanyId")
	out := new(GetUsersByCompanyIdResponse)
	err := doJSONRequest(ctx, c.client, c.urls[7], in, out)
	return out, err
}

func (c *rBACJSONClient) AddUserToCompany(ctx context.Context, in *AddUserToCompanyRequest) (*Empty, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.devrel.rbac")
	ctx = ctxsetters.WithServiceName(ctx, "RBAC")
	ctx = ctxsetters.WithMethodName(ctx, "AddUserToCompany")
	out := new(Empty)
	err := doJSONRequest(ctx, c.client, c.urls[8], in, out)
	return out, err
}

func (c *rBACJSONClient) RemoveCompanyMembership(ctx context.Context, in *RemoveCompanyMembershipRequest) (*Empty, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.devrel.rbac")
	ctx = ctxsetters.WithServiceName(ctx, "RBAC")
	ctx = ctxsetters.WithMethodName(ctx, "RemoveCompanyMembership")
	out := new(Empty)
	err := doJSONRequest(ctx, c.client, c.urls[9], in, out)
	return out, err
}

func (c *rBACJSONClient) UpdateUser(ctx context.Context, in *UpdateUserRequest) (*Empty, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.devrel.rbac")
	ctx = ctxsetters.WithServiceName(ctx, "RBAC")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateUser")
	out := new(Empty)
	err := doJSONRequest(ctx, c.client, c.urls[10], in, out)
	return out, err
}

func (c *rBACJSONClient) UpdateUserRole(ctx context.Context, in *UpdateUserRoleRequest) (*Membership, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.devrel.rbac")
	ctx = ctxsetters.WithServiceName(ctx, "RBAC")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateUserRole")
	out := new(Membership)
	err := doJSONRequest(ctx, c.client, c.urls[11], in, out)
	return out, err
}

func (c *rBACJSONClient) ListAllRoles(ctx context.Context, in *Empty) (*ListAllRolesResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.devrel.rbac")
	ctx = ctxsetters.WithServiceName(ctx, "RBAC")
	ctx = ctxsetters.WithMethodName(ctx, "ListAllRoles")
	out := new(ListAllRolesResponse)
	err := doJSONRequest(ctx, c.client, c.urls[12], in, out)
	return out, err
}

func (c *rBACJSONClient) ValidateByTwitchID(ctx context.Context, in *ValidateQuery) (*ValidateResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.devrel.rbac")
	ctx = ctxsetters.WithServiceName(ctx, "RBAC")
	ctx = ctxsetters.WithMethodName(ctx, "ValidateByTwitchID")
	out := new(ValidateResponse)
	err := doJSONRequest(ctx, c.client, c.urls[13], in, out)
	return out, err
}

func (c *rBACJSONClient) CreateResource(ctx context.Context, in *CreateResourceRequest) (*CreateResourceResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.devrel.rbac")
	ctx = ctxsetters.WithServiceName(ctx, "RBAC")
	ctx = ctxsetters.WithMethodName(ctx, "CreateResource")
	out := new(CreateResourceResponse)
	err := doJSONRequest(ctx, c.client, c.urls[14], in, out)
	return out, err
}

func (c *rBACJSONClient) ListResources(ctx context.Context, in *ListResourcesRequest) (*ListResourcesResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.devrel.rbac")
	ctx = ctxsetters.WithServiceName(ctx, "RBAC")
	ctx = ctxsetters.WithMethodName(ctx, "ListResources")
	out := new(ListResourcesResponse)
	err := doJSONRequest(ctx, c.client, c.urls[15], in, out)
	return out, err
}

func (c *rBACJSONClient) SetExtensionBillingManager(ctx context.Context, in *SetExtensionBillingManagerRequest) (*SetExtensionBillingManagerResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.devrel.rbac")
	ctx = ctxsetters.WithServiceName(ctx, "RBAC")
	ctx = ctxsetters.WithMethodName(ctx, "SetExtensionBillingManager")
	out := new(SetExtensionBillingManagerResponse)
	err := doJSONRequest(ctx, c.client, c.urls[16], in, out)
	return out, err
}

func (c *rBACJSONClient) GetExtensionBillingManager(ctx context.Context, in *GetExtensionBillingManagerRequest) (*GetExtensionBillingManagerResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.devrel.rbac")
	ctx = ctxsetters.WithServiceName(ctx, "RBAC")
	ctx = ctxsetters.WithMethodName(ctx, "GetExtensionBillingManager")
	out := new(GetExtensionBillingManagerResponse)
	err := doJSONRequest(ctx, c.client, c.urls[17], in, out)
	return out, err
}

func (c *rBACJSONClient) TransferExtensionToCompany(ctx context.Context, in *TransferExtensionRequest) (*Empty, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.devrel.rbac")
	ctx = ctxsetters.WithServiceName(ctx, "RBAC")
	ctx = ctxsetters.WithMethodName(ctx, "TransferExtensionToCompany")
	out := new(Empty)
	err := doJSONRequest(ctx, c.client, c.urls[18], in, out)
	return out, err
}

func (c *rBACJSONClient) DetachExtensionFromCompany(ctx context.Context, in *DetachExtensionRequest) (*Empty, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.devrel.rbac")
	ctx = ctxsetters.WithServiceName(ctx, "RBAC")
	ctx = ctxsetters.WithMethodName(ctx, "DetachExtensionFromCompany")
	out := new(Empty)
	err := doJSONRequest(ctx, c.client, c.urls[19], in, out)
	return out, err
}

func (c *rBACJSONClient) ListCompanyApplications(ctx context.Context, in *ListCompanyApplicationsRequest) (*ListCompanyApplicationsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.devrel.rbac")
	ctx = ctxsetters.WithServiceName(ctx, "RBAC")
	ctx = ctxsetters.WithMethodName(ctx, "ListCompanyApplications")
	out := new(ListCompanyApplicationsResponse)
	err := doJSONRequest(ctx, c.client, c.urls[20], in, out)
	return out, err
}

func (c *rBACJSONClient) SearchCompanyApplications(ctx context.Context, in *SearchCompanyApplicationsRequest) (*SearchCompanyApplicationsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.devrel.rbac")
	ctx = ctxsetters.WithServiceName(ctx, "RBAC")
	ctx = ctxsetters.WithMethodName(ctx, "SearchCompanyApplications")
	out := new(SearchCompanyApplicationsResponse)
	err := doJSONRequest(ctx, c.client, c.urls[21], in, out)
	return out, err
}

func (c *rBACJSONClient) GetCompanyApplication(ctx context.Context, in *Id) (*CompanyApplication, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.devrel.rbac")
	ctx = ctxsetters.WithServiceName(ctx, "RBAC")
	ctx = ctxsetters.WithMethodName(ctx, "GetCompanyApplication")
	out := new(CompanyApplication)
	err := doJSONRequest(ctx, c.client, c.urls[22], in, out)
	return out, err
}

func (c *rBACJSONClient) UpdateCompanyApplication(ctx context.Context, in *UpdateCompanyApplicationRequest) (*CompanyApplication, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.devrel.rbac")
	ctx = ctxsetters.WithServiceName(ctx, "RBAC")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateCompanyApplication")
	out := new(CompanyApplication)
	err := doJSONRequest(ctx, c.client, c.urls[23], in, out)
	return out, err
}

func (c *rBACJSONClient) DeleteCompanyApplication(ctx context.Context, in *DeleteCompanyApplicationRequest) (*Empty, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.devrel.rbac")
	ctx = ctxsetters.WithServiceName(ctx, "RBAC")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteCompanyApplication")
	out := new(Empty)
	err := doJSONRequest(ctx, c.client, c.urls[24], in, out)
	return out, err
}

func (c *rBACJSONClient) OnboardCompany(ctx context.Context, in *OnboardCompanyRequest) (*OnboardCompanyResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.devrel.rbac")
	ctx = ctxsetters.WithServiceName(ctx, "RBAC")
	ctx = ctxsetters.WithMethodName(ctx, "OnboardCompany")
	out := new(OnboardCompanyResponse)
	err := doJSONRequest(ctx, c.client, c.urls[25], in, out)
	return out, err
}

func (c *rBACJSONClient) ListGameApplications(ctx context.Context, in *ListGameApplicationsRequest) (*ListGameApplicationsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.devrel.rbac")
	ctx = ctxsetters.WithServiceName(ctx, "RBAC")
	ctx = ctxsetters.WithMethodName(ctx, "ListGameApplications")
	out := new(ListGameApplicationsResponse)
	err := doJSONRequest(ctx, c.client, c.urls[26], in, out)
	return out, err
}

func (c *rBACJSONClient) GetGameApplicationsByCompany(ctx context.Context, in *Id) (*GetGameApplicationsByCompanyResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.devrel.rbac")
	ctx = ctxsetters.WithServiceName(ctx, "RBAC")
	ctx = ctxsetters.WithMethodName(ctx, "GetGameApplicationsByCompany")
	out := new(GetGameApplicationsByCompanyResponse)
	err := doJSONRequest(ctx, c.client, c.urls[27], in, out)
	return out, err
}

func (c *rBACJSONClient) CreateGameApplication(ctx context.Context, in *CreateGameApplicationRequest) (*GameApplication, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.devrel.rbac")
	ctx = ctxsetters.WithServiceName(ctx, "RBAC")
	ctx = ctxsetters.WithMethodName(ctx, "CreateGameApplication")
	out := new(GameApplication)
	err := doJSONRequest(ctx, c.client, c.urls[28], in, out)
	return out, err
}

func (c *rBACJSONClient) DeleteGameApplication(ctx context.Context, in *DeleteGameApplicationRequest) (*Empty, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.devrel.rbac")
	ctx = ctxsetters.WithServiceName(ctx, "RBAC")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteGameApplication")
	out := new(Empty)
	err := doJSONRequest(ctx, c.client, c.urls[29], in, out)
	return out, err
}

func (c *rBACJSONClient) OnboardGame(ctx context.Context, in *OnboardGameRequest) (*OnboardGameResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.devrel.rbac")
	ctx = ctxsetters.WithServiceName(ctx, "RBAC")
	ctx = ctxsetters.WithMethodName(ctx, "OnboardGame")
	out := new(OnboardGameResponse)
	err := doJSONRequest(ctx, c.client, c.urls[30], in, out)
	return out, err
}

func (c *rBACJSONClient) GetDeveloperApplications(ctx context.Context, in *GetDeveloperApplicationsRequest) (*GetDeveloperApplicationsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.devrel.rbac")
	ctx = ctxsetters.WithServiceName(ctx, "RBAC")
	ctx = ctxsetters.WithMethodName(ctx, "GetDeveloperApplications")
	out := new(GetDeveloperApplicationsResponse)
	err := doJSONRequest(ctx, c.client, c.urls[31], in, out)
	return out, err
}

func (c *rBACJSONClient) DeleteDeveloperApplication(ctx context.Context, in *DeleteDeveloperApplicationRequest) (*Empty, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.devrel.rbac")
	ctx = ctxsetters.WithServiceName(ctx, "RBAC")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteDeveloperApplication")
	out := new(Empty)
	err := doJSONRequest(ctx, c.client, c.urls[32], in, out)
	return out, err
}

func (c *rBACJSONClient) OnboardDeveloper(ctx context.Context, in *OnboardDeveloperRequest) (*OnboardDeveloperResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.devrel.rbac")
	ctx = ctxsetters.WithServiceName(ctx, "RBAC")
	ctx = ctxsetters.WithMethodName(ctx, "OnboardDeveloper")
	out := new(OnboardDeveloperResponse)
	err := doJSONRequest(ctx, c.client, c.urls[33], in, out)
	return out, err
}

func (c *rBACJSONClient) GetGamesByCompany(ctx context.Context, in *Id) (*GetGamesByCompanyResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.devrel.rbac")
	ctx = ctxsetters.WithServiceName(ctx, "RBAC")
	ctx = ctxsetters.WithMethodName(ctx, "GetGamesByCompany")
	out := new(GetGamesByCompanyResponse)
	err := doJSONRequest(ctx, c.client, c.urls[34], in, out)
	return out, err
}

func (c *rBACJSONClient) GetGamesByTwitchID(ctx context.Context, in *Id) (*GetGamesByTwitchIDResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.devrel.rbac")
	ctx = ctxsetters.WithServiceName(ctx, "RBAC")
	ctx = ctxsetters.WithMethodName(ctx, "GetGamesByTwitchID")
	out := new(GetGamesByTwitchIDResponse)
	err := doJSONRequest(ctx, c.client, c.urls[35], in, out)
	return out, err
}

func (c *rBACJSONClient) GetCompanyByTwitchID(ctx context.Context, in *Id) (*Company, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.devrel.rbac")
	ctx = ctxsetters.WithServiceName(ctx, "RBAC")
	ctx = ctxsetters.WithMethodName(ctx, "GetCompanyByTwitchID")
	out := new(Company)
	err := doJSONRequest(ctx, c.client, c.urls[36], in, out)
	return out, err
}

func (c *rBACJSONClient) CreateJWT(ctx context.Context, in *JWTRequest) (*JWT, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.devrel.rbac")
	ctx = ctxsetters.WithServiceName(ctx, "RBAC")
	ctx = ctxsetters.WithMethodName(ctx, "CreateJWT")
	out := new(JWT)
	err := doJSONRequest(ctx, c.client, c.urls[37], in, out)
	return out, err
}

func (c *rBACJSONClient) GetAllGamesWithCompanies(ctx context.Context, in *GetAllGamesWithCompaniesRequest) (*GetAllGamesWithCompaniesResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.devrel.rbac")
	ctx = ctxsetters.WithServiceName(ctx, "RBAC")
	ctx = ctxsetters.WithMethodName(ctx, "GetAllGamesWithCompanies")
	out := new(GetAllGamesWithCompaniesResponse)
	err := doJSONRequest(ctx, c.client, c.urls[38], in, out)
	return out, err
}

func (c *rBACJSONClient) IsFeatureEnabled(ctx context.Context, in *IsFeatureEnabledRequest) (*FeatureEnabledResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.devrel.rbac")
	ctx = ctxsetters.WithServiceName(ctx, "RBAC")
	ctx = ctxsetters.WithMethodName(ctx, "IsFeatureEnabled")
	out := new(FeatureEnabledResponse)
	err := doJSONRequest(ctx, c.client, c.urls[39], in, out)
	return out, err
}

func (c *rBACJSONClient) IsValueEnabled(ctx context.Context, in *IsValueEnabledRequest) (*FeatureEnabledResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.devrel.rbac")
	ctx = ctxsetters.WithServiceName(ctx, "RBAC")
	ctx = ctxsetters.WithMethodName(ctx, "IsValueEnabled")
	out := new(FeatureEnabledResponse)
	err := doJSONRequest(ctx, c.client, c.urls[40], in, out)
	return out, err
}

// ===================
// RBAC Server Handler
// ===================

type rBACServer struct {
	RBAC
	hooks *twirp.ServerHooks
}

func NewRBACServer(svc RBAC, hooks *twirp.ServerHooks) TwirpServer {
	return &rBACServer{
		RBAC:  svc,
		hooks: hooks,
	}
}

// writeError writes an HTTP response with a valid Twirp error format, and triggers hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func (s *rBACServer) writeError(ctx context.Context, resp http.ResponseWriter, err error) {
	writeError(ctx, resp, err, s.hooks)
}

// RBACPathPrefix is used for all URL paths on a twirp RBAC server.
// Requests are always: POST RBACPathPrefix/method
// It can be used in an HTTP mux to route twirp requests along with non-twirp requests on other routes.
const RBACPathPrefix = "/twirp/code.justin.tv.devrel.rbac.RBAC/"

func (s *rBACServer) ServeHTTP(resp http.ResponseWriter, req *http.Request) {
	ctx := req.Context()
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.devrel.rbac")
	ctx = ctxsetters.WithServiceName(ctx, "RBAC")
	ctx = ctxsetters.WithResponseWriter(ctx, resp)

	var err error
	ctx, err = callRequestReceived(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	if req.Method != "POST" {
		msg := fmt.Sprintf("unsupported method %q (only POST is allowed)", req.Method)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}

	switch req.URL.Path {
	case "/twirp/code.justin.tv.devrel.rbac.RBAC/ListCompanies":
		s.serveListCompanies(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.devrel.rbac.RBAC/ListCompanyMemberships":
		s.serveListCompanyMemberships(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.devrel.rbac.RBAC/SearchCompanies":
		s.serveSearchCompanies(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.devrel.rbac.RBAC/GetCompany":
		s.serveGetCompany(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.devrel.rbac.RBAC/UpdateCompany":
		s.serveUpdateCompany(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.devrel.rbac.RBAC/CreateCompanyApplication":
		s.serveCreateCompanyApplication(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.devrel.rbac.RBAC/GetMembership":
		s.serveGetMembership(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.devrel.rbac.RBAC/GetUsersByCompanyId":
		s.serveGetUsersByCompanyId(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.devrel.rbac.RBAC/AddUserToCompany":
		s.serveAddUserToCompany(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.devrel.rbac.RBAC/RemoveCompanyMembership":
		s.serveRemoveCompanyMembership(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.devrel.rbac.RBAC/UpdateUser":
		s.serveUpdateUser(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.devrel.rbac.RBAC/UpdateUserRole":
		s.serveUpdateUserRole(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.devrel.rbac.RBAC/ListAllRoles":
		s.serveListAllRoles(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.devrel.rbac.RBAC/ValidateByTwitchID":
		s.serveValidateByTwitchID(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.devrel.rbac.RBAC/CreateResource":
		s.serveCreateResource(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.devrel.rbac.RBAC/ListResources":
		s.serveListResources(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.devrel.rbac.RBAC/SetExtensionBillingManager":
		s.serveSetExtensionBillingManager(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.devrel.rbac.RBAC/GetExtensionBillingManager":
		s.serveGetExtensionBillingManager(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.devrel.rbac.RBAC/TransferExtensionToCompany":
		s.serveTransferExtensionToCompany(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.devrel.rbac.RBAC/DetachExtensionFromCompany":
		s.serveDetachExtensionFromCompany(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.devrel.rbac.RBAC/ListCompanyApplications":
		s.serveListCompanyApplications(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.devrel.rbac.RBAC/SearchCompanyApplications":
		s.serveSearchCompanyApplications(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.devrel.rbac.RBAC/GetCompanyApplication":
		s.serveGetCompanyApplication(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.devrel.rbac.RBAC/UpdateCompanyApplication":
		s.serveUpdateCompanyApplication(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.devrel.rbac.RBAC/DeleteCompanyApplication":
		s.serveDeleteCompanyApplication(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.devrel.rbac.RBAC/OnboardCompany":
		s.serveOnboardCompany(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.devrel.rbac.RBAC/ListGameApplications":
		s.serveListGameApplications(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.devrel.rbac.RBAC/GetGameApplicationsByCompany":
		s.serveGetGameApplicationsByCompany(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.devrel.rbac.RBAC/CreateGameApplication":
		s.serveCreateGameApplication(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.devrel.rbac.RBAC/DeleteGameApplication":
		s.serveDeleteGameApplication(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.devrel.rbac.RBAC/OnboardGame":
		s.serveOnboardGame(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.devrel.rbac.RBAC/GetDeveloperApplications":
		s.serveGetDeveloperApplications(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.devrel.rbac.RBAC/DeleteDeveloperApplication":
		s.serveDeleteDeveloperApplication(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.devrel.rbac.RBAC/OnboardDeveloper":
		s.serveOnboardDeveloper(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.devrel.rbac.RBAC/GetGamesByCompany":
		s.serveGetGamesByCompany(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.devrel.rbac.RBAC/GetGamesByTwitchID":
		s.serveGetGamesByTwitchID(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.devrel.rbac.RBAC/GetCompanyByTwitchID":
		s.serveGetCompanyByTwitchID(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.devrel.rbac.RBAC/CreateJWT":
		s.serveCreateJWT(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.devrel.rbac.RBAC/GetAllGamesWithCompanies":
		s.serveGetAllGamesWithCompanies(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.devrel.rbac.RBAC/IsFeatureEnabled":
		s.serveIsFeatureEnabled(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.devrel.rbac.RBAC/IsValueEnabled":
		s.serveIsValueEnabled(ctx, resp, req)
		return
	default:
		msg := fmt.Sprintf("no handler for path %q", req.URL.Path)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}
}

func (s *rBACServer) serveListCompanies(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveListCompaniesJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveListCompaniesProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *rBACServer) serveListCompaniesJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListCompanies")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ListCompaniesRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ListCompaniesResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.ListCompanies(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListCompaniesResponse and nil error while calling ListCompanies. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *rBACServer) serveListCompaniesProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListCompanies")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(ListCompaniesRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ListCompaniesResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.ListCompanies(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListCompaniesResponse and nil error while calling ListCompanies. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *rBACServer) serveListCompanyMemberships(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveListCompanyMembershipsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveListCompanyMembershipsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *rBACServer) serveListCompanyMembershipsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListCompanyMemberships")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ListCompanyMembershipsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ListCompanyMembershipsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.ListCompanyMemberships(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListCompanyMembershipsResponse and nil error while calling ListCompanyMemberships. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *rBACServer) serveListCompanyMembershipsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListCompanyMemberships")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(ListCompanyMembershipsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ListCompanyMembershipsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.ListCompanyMemberships(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListCompanyMembershipsResponse and nil error while calling ListCompanyMemberships. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *rBACServer) serveSearchCompanies(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveSearchCompaniesJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveSearchCompaniesProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *rBACServer) serveSearchCompaniesJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "SearchCompanies")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(SearchCompaniesRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *SearchCompaniesResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.SearchCompanies(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SearchCompaniesResponse and nil error while calling SearchCompanies. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *rBACServer) serveSearchCompaniesProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "SearchCompanies")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(SearchCompaniesRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *SearchCompaniesResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.SearchCompanies(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SearchCompaniesResponse and nil error while calling SearchCompanies. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *rBACServer) serveGetCompany(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetCompanyJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetCompanyProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *rBACServer) serveGetCompanyJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetCompany")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(Id)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *Company
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetCompany(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Company and nil error while calling GetCompany. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *rBACServer) serveGetCompanyProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetCompany")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(Id)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *Company
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetCompany(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Company and nil error while calling GetCompany. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *rBACServer) serveUpdateCompany(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveUpdateCompanyJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveUpdateCompanyProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *rBACServer) serveUpdateCompanyJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateCompany")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(UpdateCompanyRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *Company
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.UpdateCompany(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Company and nil error while calling UpdateCompany. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *rBACServer) serveUpdateCompanyProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateCompany")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(UpdateCompanyRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *Company
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.UpdateCompany(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Company and nil error while calling UpdateCompany. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *rBACServer) serveCreateCompanyApplication(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveCreateCompanyApplicationJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCreateCompanyApplicationProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *rBACServer) serveCreateCompanyApplicationJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateCompanyApplication")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(CreateCompanyApplicationRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CompanyApplication
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CreateCompanyApplication(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CompanyApplication and nil error while calling CreateCompanyApplication. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *rBACServer) serveCreateCompanyApplicationProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateCompanyApplication")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(CreateCompanyApplicationRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CompanyApplication
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CreateCompanyApplication(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CompanyApplication and nil error while calling CreateCompanyApplication. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *rBACServer) serveGetMembership(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetMembershipJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetMembershipProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *rBACServer) serveGetMembershipJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetMembership")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetMembershipRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *Membership
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetMembership(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Membership and nil error while calling GetMembership. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *rBACServer) serveGetMembershipProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetMembership")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetMembershipRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *Membership
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetMembership(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Membership and nil error while calling GetMembership. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *rBACServer) serveGetUsersByCompanyId(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetUsersByCompanyIdJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetUsersByCompanyIdProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *rBACServer) serveGetUsersByCompanyIdJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetUsersByCompanyId")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetUsersByCompanyIdRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetUsersByCompanyIdResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetUsersByCompanyId(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetUsersByCompanyIdResponse and nil error while calling GetUsersByCompanyId. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *rBACServer) serveGetUsersByCompanyIdProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetUsersByCompanyId")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetUsersByCompanyIdRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetUsersByCompanyIdResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetUsersByCompanyId(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetUsersByCompanyIdResponse and nil error while calling GetUsersByCompanyId. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *rBACServer) serveAddUserToCompany(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveAddUserToCompanyJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveAddUserToCompanyProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *rBACServer) serveAddUserToCompanyJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "AddUserToCompany")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(AddUserToCompanyRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *Empty
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.AddUserToCompany(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Empty and nil error while calling AddUserToCompany. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *rBACServer) serveAddUserToCompanyProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "AddUserToCompany")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(AddUserToCompanyRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *Empty
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.AddUserToCompany(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Empty and nil error while calling AddUserToCompany. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *rBACServer) serveRemoveCompanyMembership(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveRemoveCompanyMembershipJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveRemoveCompanyMembershipProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *rBACServer) serveRemoveCompanyMembershipJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "RemoveCompanyMembership")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(RemoveCompanyMembershipRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *Empty
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.RemoveCompanyMembership(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Empty and nil error while calling RemoveCompanyMembership. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *rBACServer) serveRemoveCompanyMembershipProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "RemoveCompanyMembership")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(RemoveCompanyMembershipRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *Empty
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.RemoveCompanyMembership(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Empty and nil error while calling RemoveCompanyMembership. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *rBACServer) serveUpdateUser(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveUpdateUserJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveUpdateUserProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *rBACServer) serveUpdateUserJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateUser")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(UpdateUserRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *Empty
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.UpdateUser(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Empty and nil error while calling UpdateUser. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *rBACServer) serveUpdateUserProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateUser")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(UpdateUserRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *Empty
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.UpdateUser(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Empty and nil error while calling UpdateUser. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *rBACServer) serveUpdateUserRole(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveUpdateUserRoleJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveUpdateUserRoleProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *rBACServer) serveUpdateUserRoleJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateUserRole")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(UpdateUserRoleRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *Membership
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.UpdateUserRole(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Membership and nil error while calling UpdateUserRole. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *rBACServer) serveUpdateUserRoleProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateUserRole")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(UpdateUserRoleRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *Membership
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.UpdateUserRole(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Membership and nil error while calling UpdateUserRole. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *rBACServer) serveListAllRoles(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveListAllRolesJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveListAllRolesProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *rBACServer) serveListAllRolesJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListAllRoles")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(Empty)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ListAllRolesResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.ListAllRoles(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListAllRolesResponse and nil error while calling ListAllRoles. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *rBACServer) serveListAllRolesProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListAllRoles")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(Empty)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ListAllRolesResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.ListAllRoles(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListAllRolesResponse and nil error while calling ListAllRoles. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *rBACServer) serveValidateByTwitchID(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveValidateByTwitchIDJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveValidateByTwitchIDProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *rBACServer) serveValidateByTwitchIDJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ValidateByTwitchID")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ValidateQuery)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ValidateResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.ValidateByTwitchID(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ValidateResponse and nil error while calling ValidateByTwitchID. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *rBACServer) serveValidateByTwitchIDProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ValidateByTwitchID")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(ValidateQuery)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ValidateResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.ValidateByTwitchID(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ValidateResponse and nil error while calling ValidateByTwitchID. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *rBACServer) serveCreateResource(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveCreateResourceJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCreateResourceProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *rBACServer) serveCreateResourceJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateResource")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(CreateResourceRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CreateResourceResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CreateResource(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateResourceResponse and nil error while calling CreateResource. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *rBACServer) serveCreateResourceProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateResource")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(CreateResourceRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CreateResourceResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CreateResource(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateResourceResponse and nil error while calling CreateResource. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *rBACServer) serveListResources(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveListResourcesJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveListResourcesProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *rBACServer) serveListResourcesJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListResources")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ListResourcesRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ListResourcesResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.ListResources(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListResourcesResponse and nil error while calling ListResources. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *rBACServer) serveListResourcesProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListResources")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(ListResourcesRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ListResourcesResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.ListResources(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListResourcesResponse and nil error while calling ListResources. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *rBACServer) serveSetExtensionBillingManager(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveSetExtensionBillingManagerJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveSetExtensionBillingManagerProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *rBACServer) serveSetExtensionBillingManagerJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "SetExtensionBillingManager")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(SetExtensionBillingManagerRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *SetExtensionBillingManagerResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.SetExtensionBillingManager(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SetExtensionBillingManagerResponse and nil error while calling SetExtensionBillingManager. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *rBACServer) serveSetExtensionBillingManagerProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "SetExtensionBillingManager")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(SetExtensionBillingManagerRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *SetExtensionBillingManagerResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.SetExtensionBillingManager(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SetExtensionBillingManagerResponse and nil error while calling SetExtensionBillingManager. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *rBACServer) serveGetExtensionBillingManager(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetExtensionBillingManagerJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetExtensionBillingManagerProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *rBACServer) serveGetExtensionBillingManagerJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetExtensionBillingManager")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetExtensionBillingManagerRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetExtensionBillingManagerResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetExtensionBillingManager(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetExtensionBillingManagerResponse and nil error while calling GetExtensionBillingManager. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *rBACServer) serveGetExtensionBillingManagerProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetExtensionBillingManager")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetExtensionBillingManagerRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetExtensionBillingManagerResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetExtensionBillingManager(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetExtensionBillingManagerResponse and nil error while calling GetExtensionBillingManager. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *rBACServer) serveTransferExtensionToCompany(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveTransferExtensionToCompanyJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveTransferExtensionToCompanyProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *rBACServer) serveTransferExtensionToCompanyJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "TransferExtensionToCompany")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(TransferExtensionRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *Empty
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.TransferExtensionToCompany(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Empty and nil error while calling TransferExtensionToCompany. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *rBACServer) serveTransferExtensionToCompanyProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "TransferExtensionToCompany")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(TransferExtensionRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *Empty
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.TransferExtensionToCompany(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Empty and nil error while calling TransferExtensionToCompany. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *rBACServer) serveDetachExtensionFromCompany(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveDetachExtensionFromCompanyJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveDetachExtensionFromCompanyProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *rBACServer) serveDetachExtensionFromCompanyJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DetachExtensionFromCompany")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(DetachExtensionRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *Empty
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.DetachExtensionFromCompany(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Empty and nil error while calling DetachExtensionFromCompany. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *rBACServer) serveDetachExtensionFromCompanyProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DetachExtensionFromCompany")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(DetachExtensionRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *Empty
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.DetachExtensionFromCompany(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Empty and nil error while calling DetachExtensionFromCompany. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *rBACServer) serveListCompanyApplications(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveListCompanyApplicationsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveListCompanyApplicationsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *rBACServer) serveListCompanyApplicationsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListCompanyApplications")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ListCompanyApplicationsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ListCompanyApplicationsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.ListCompanyApplications(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListCompanyApplicationsResponse and nil error while calling ListCompanyApplications. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *rBACServer) serveListCompanyApplicationsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListCompanyApplications")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(ListCompanyApplicationsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ListCompanyApplicationsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.ListCompanyApplications(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListCompanyApplicationsResponse and nil error while calling ListCompanyApplications. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *rBACServer) serveSearchCompanyApplications(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveSearchCompanyApplicationsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveSearchCompanyApplicationsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *rBACServer) serveSearchCompanyApplicationsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "SearchCompanyApplications")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(SearchCompanyApplicationsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *SearchCompanyApplicationsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.SearchCompanyApplications(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SearchCompanyApplicationsResponse and nil error while calling SearchCompanyApplications. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *rBACServer) serveSearchCompanyApplicationsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "SearchCompanyApplications")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(SearchCompanyApplicationsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *SearchCompanyApplicationsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.SearchCompanyApplications(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SearchCompanyApplicationsResponse and nil error while calling SearchCompanyApplications. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *rBACServer) serveGetCompanyApplication(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetCompanyApplicationJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetCompanyApplicationProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *rBACServer) serveGetCompanyApplicationJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetCompanyApplication")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(Id)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CompanyApplication
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetCompanyApplication(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CompanyApplication and nil error while calling GetCompanyApplication. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *rBACServer) serveGetCompanyApplicationProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetCompanyApplication")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(Id)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CompanyApplication
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetCompanyApplication(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CompanyApplication and nil error while calling GetCompanyApplication. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *rBACServer) serveUpdateCompanyApplication(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveUpdateCompanyApplicationJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveUpdateCompanyApplicationProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *rBACServer) serveUpdateCompanyApplicationJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateCompanyApplication")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(UpdateCompanyApplicationRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CompanyApplication
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.UpdateCompanyApplication(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CompanyApplication and nil error while calling UpdateCompanyApplication. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *rBACServer) serveUpdateCompanyApplicationProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateCompanyApplication")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(UpdateCompanyApplicationRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CompanyApplication
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.UpdateCompanyApplication(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CompanyApplication and nil error while calling UpdateCompanyApplication. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *rBACServer) serveDeleteCompanyApplication(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveDeleteCompanyApplicationJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveDeleteCompanyApplicationProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *rBACServer) serveDeleteCompanyApplicationJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteCompanyApplication")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(DeleteCompanyApplicationRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *Empty
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.DeleteCompanyApplication(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Empty and nil error while calling DeleteCompanyApplication. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *rBACServer) serveDeleteCompanyApplicationProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteCompanyApplication")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(DeleteCompanyApplicationRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *Empty
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.DeleteCompanyApplication(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Empty and nil error while calling DeleteCompanyApplication. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *rBACServer) serveOnboardCompany(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveOnboardCompanyJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveOnboardCompanyProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *rBACServer) serveOnboardCompanyJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "OnboardCompany")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(OnboardCompanyRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *OnboardCompanyResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.OnboardCompany(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *OnboardCompanyResponse and nil error while calling OnboardCompany. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *rBACServer) serveOnboardCompanyProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "OnboardCompany")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(OnboardCompanyRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *OnboardCompanyResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.OnboardCompany(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *OnboardCompanyResponse and nil error while calling OnboardCompany. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *rBACServer) serveListGameApplications(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveListGameApplicationsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveListGameApplicationsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *rBACServer) serveListGameApplicationsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListGameApplications")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ListGameApplicationsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ListGameApplicationsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.ListGameApplications(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListGameApplicationsResponse and nil error while calling ListGameApplications. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *rBACServer) serveListGameApplicationsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListGameApplications")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(ListGameApplicationsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ListGameApplicationsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.ListGameApplications(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListGameApplicationsResponse and nil error while calling ListGameApplications. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *rBACServer) serveGetGameApplicationsByCompany(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetGameApplicationsByCompanyJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetGameApplicationsByCompanyProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *rBACServer) serveGetGameApplicationsByCompanyJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetGameApplicationsByCompany")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(Id)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetGameApplicationsByCompanyResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetGameApplicationsByCompany(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetGameApplicationsByCompanyResponse and nil error while calling GetGameApplicationsByCompany. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *rBACServer) serveGetGameApplicationsByCompanyProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetGameApplicationsByCompany")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(Id)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetGameApplicationsByCompanyResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetGameApplicationsByCompany(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetGameApplicationsByCompanyResponse and nil error while calling GetGameApplicationsByCompany. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *rBACServer) serveCreateGameApplication(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveCreateGameApplicationJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCreateGameApplicationProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *rBACServer) serveCreateGameApplicationJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateGameApplication")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(CreateGameApplicationRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GameApplication
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CreateGameApplication(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GameApplication and nil error while calling CreateGameApplication. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *rBACServer) serveCreateGameApplicationProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateGameApplication")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(CreateGameApplicationRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GameApplication
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CreateGameApplication(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GameApplication and nil error while calling CreateGameApplication. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *rBACServer) serveDeleteGameApplication(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveDeleteGameApplicationJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveDeleteGameApplicationProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *rBACServer) serveDeleteGameApplicationJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteGameApplication")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(DeleteGameApplicationRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *Empty
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.DeleteGameApplication(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Empty and nil error while calling DeleteGameApplication. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *rBACServer) serveDeleteGameApplicationProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteGameApplication")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(DeleteGameApplicationRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *Empty
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.DeleteGameApplication(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Empty and nil error while calling DeleteGameApplication. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *rBACServer) serveOnboardGame(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveOnboardGameJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveOnboardGameProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *rBACServer) serveOnboardGameJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "OnboardGame")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(OnboardGameRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *OnboardGameResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.OnboardGame(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *OnboardGameResponse and nil error while calling OnboardGame. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *rBACServer) serveOnboardGameProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "OnboardGame")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(OnboardGameRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *OnboardGameResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.OnboardGame(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *OnboardGameResponse and nil error while calling OnboardGame. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *rBACServer) serveGetDeveloperApplications(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetDeveloperApplicationsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetDeveloperApplicationsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *rBACServer) serveGetDeveloperApplicationsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetDeveloperApplications")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetDeveloperApplicationsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetDeveloperApplicationsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetDeveloperApplications(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetDeveloperApplicationsResponse and nil error while calling GetDeveloperApplications. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *rBACServer) serveGetDeveloperApplicationsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetDeveloperApplications")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetDeveloperApplicationsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetDeveloperApplicationsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetDeveloperApplications(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetDeveloperApplicationsResponse and nil error while calling GetDeveloperApplications. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *rBACServer) serveDeleteDeveloperApplication(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveDeleteDeveloperApplicationJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveDeleteDeveloperApplicationProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *rBACServer) serveDeleteDeveloperApplicationJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteDeveloperApplication")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(DeleteDeveloperApplicationRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *Empty
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.DeleteDeveloperApplication(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Empty and nil error while calling DeleteDeveloperApplication. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *rBACServer) serveDeleteDeveloperApplicationProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteDeveloperApplication")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(DeleteDeveloperApplicationRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *Empty
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.DeleteDeveloperApplication(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Empty and nil error while calling DeleteDeveloperApplication. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *rBACServer) serveOnboardDeveloper(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveOnboardDeveloperJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveOnboardDeveloperProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *rBACServer) serveOnboardDeveloperJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "OnboardDeveloper")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(OnboardDeveloperRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *OnboardDeveloperResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.OnboardDeveloper(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *OnboardDeveloperResponse and nil error while calling OnboardDeveloper. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *rBACServer) serveOnboardDeveloperProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "OnboardDeveloper")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(OnboardDeveloperRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *OnboardDeveloperResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.OnboardDeveloper(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *OnboardDeveloperResponse and nil error while calling OnboardDeveloper. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *rBACServer) serveGetGamesByCompany(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetGamesByCompanyJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetGamesByCompanyProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *rBACServer) serveGetGamesByCompanyJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetGamesByCompany")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(Id)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetGamesByCompanyResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetGamesByCompany(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetGamesByCompanyResponse and nil error while calling GetGamesByCompany. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *rBACServer) serveGetGamesByCompanyProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetGamesByCompany")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(Id)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetGamesByCompanyResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetGamesByCompany(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetGamesByCompanyResponse and nil error while calling GetGamesByCompany. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *rBACServer) serveGetGamesByTwitchID(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetGamesByTwitchIDJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetGamesByTwitchIDProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *rBACServer) serveGetGamesByTwitchIDJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetGamesByTwitchID")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(Id)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetGamesByTwitchIDResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetGamesByTwitchID(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetGamesByTwitchIDResponse and nil error while calling GetGamesByTwitchID. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *rBACServer) serveGetGamesByTwitchIDProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetGamesByTwitchID")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(Id)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetGamesByTwitchIDResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetGamesByTwitchID(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetGamesByTwitchIDResponse and nil error while calling GetGamesByTwitchID. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *rBACServer) serveGetCompanyByTwitchID(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetCompanyByTwitchIDJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetCompanyByTwitchIDProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *rBACServer) serveGetCompanyByTwitchIDJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetCompanyByTwitchID")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(Id)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *Company
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetCompanyByTwitchID(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Company and nil error while calling GetCompanyByTwitchID. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *rBACServer) serveGetCompanyByTwitchIDProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetCompanyByTwitchID")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(Id)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *Company
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetCompanyByTwitchID(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Company and nil error while calling GetCompanyByTwitchID. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *rBACServer) serveCreateJWT(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveCreateJWTJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCreateJWTProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *rBACServer) serveCreateJWTJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateJWT")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(JWTRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *JWT
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CreateJWT(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *JWT and nil error while calling CreateJWT. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *rBACServer) serveCreateJWTProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateJWT")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(JWTRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *JWT
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CreateJWT(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *JWT and nil error while calling CreateJWT. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *rBACServer) serveGetAllGamesWithCompanies(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetAllGamesWithCompaniesJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetAllGamesWithCompaniesProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *rBACServer) serveGetAllGamesWithCompaniesJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetAllGamesWithCompanies")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetAllGamesWithCompaniesRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetAllGamesWithCompaniesResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetAllGamesWithCompanies(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetAllGamesWithCompaniesResponse and nil error while calling GetAllGamesWithCompanies. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *rBACServer) serveGetAllGamesWithCompaniesProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetAllGamesWithCompanies")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetAllGamesWithCompaniesRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetAllGamesWithCompaniesResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetAllGamesWithCompanies(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetAllGamesWithCompaniesResponse and nil error while calling GetAllGamesWithCompanies. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *rBACServer) serveIsFeatureEnabled(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveIsFeatureEnabledJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveIsFeatureEnabledProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *rBACServer) serveIsFeatureEnabledJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "IsFeatureEnabled")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(IsFeatureEnabledRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *FeatureEnabledResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.IsFeatureEnabled(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *FeatureEnabledResponse and nil error while calling IsFeatureEnabled. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *rBACServer) serveIsFeatureEnabledProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "IsFeatureEnabled")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(IsFeatureEnabledRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *FeatureEnabledResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.IsFeatureEnabled(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *FeatureEnabledResponse and nil error while calling IsFeatureEnabled. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *rBACServer) serveIsValueEnabled(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveIsValueEnabledJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveIsValueEnabledProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *rBACServer) serveIsValueEnabledJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "IsValueEnabled")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(IsValueEnabledRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *FeatureEnabledResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.IsValueEnabled(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *FeatureEnabledResponse and nil error while calling IsValueEnabled. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *rBACServer) serveIsValueEnabledProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "IsValueEnabled")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(IsValueEnabledRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *FeatureEnabledResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.IsValueEnabled(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *FeatureEnabledResponse and nil error while calling IsValueEnabled. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *rBACServer) ServiceDescriptor() ([]byte, int) {
	return twirpFileDescriptor0, 0
}

func (s *rBACServer) ProtocGenTwirpVersion() string {
	return "v5.3.0"
}

// ===================
// RBACAdmin Interface
// ===================

// RBACAdmin has methods for service data maintenance, for RBAC developers only.
// Should be merged into ViennaBackend
type RBACAdmin interface {
	// APIs for Company Management
	DeleteCompany(context.Context, *DeleteCompanyRequest) (*Empty, error)

	OffboardResource(context.Context, *OffboardResourceRequest) (*Empty, error)

	TransferCompanyOwnership(context.Context, *TransferCompanyOwnershipRequest) (*Empty, error)

	// APIs for internal user whitelist management
	WhitelistUser(context.Context, *WhitelistUserRequest) (*Empty, error)

	RemoveUserFromWhitelist(context.Context, *RemoveUserFromWhitelistRequest) (*Empty, error)

	UpdateUserRoleInWhitelist(context.Context, *WhitelistUserRequest) (*Empty, error)

	ListUserWhitelistByRole(context.Context, *ListUserWhitelistByRoleRequest) (*ListUserWhitelistByRoleResponse, error)

	// APIs for feature gating
	// Get/Set bool value
	// example: get/set feature gating on some thing can be controlled by bool value, like gating an API for all users
	GetFeatureGatingValueInBool(context.Context, *GetFeatureGatingValueRequest) (*GetFeatureGatingValueResponse, error)

	SetFeatureGatingBoolValue(context.Context, *SetFeatureGatingBoolValueRequest) (*Empty, error)

	// Get/Update value(s)
	// example: get/update feature gating on some thing needs a whitelist, like gating an API by whitelisted users
	GetFeatureGatingValueInStrings(context.Context, *GetFeatureGatingValueRequest) (*GetFeatureGatingValueResponse, error)

	UpdateFeatureGatingValue(context.Context, *UpdateFeatureGatingValueRequest) (*GetFeatureGatingValueResponse, error)
}

// =========================
// RBACAdmin Protobuf Client
// =========================

type rBACAdminProtobufClient struct {
	client HTTPClient
	urls   [11]string
}

// NewRBACAdminProtobufClient creates a Protobuf client that implements the RBACAdmin interface.
// It communicates using Protobuf and can be configured with a custom HTTPClient.
func NewRBACAdminProtobufClient(addr string, client HTTPClient) RBACAdmin {
	prefix := urlBase(addr) + RBACAdminPathPrefix
	urls := [11]string{
		prefix + "DeleteCompany",
		prefix + "OffboardResource",
		prefix + "TransferCompanyOwnership",
		prefix + "WhitelistUser",
		prefix + "RemoveUserFromWhitelist",
		prefix + "UpdateUserRoleInWhitelist",
		prefix + "ListUserWhitelistByRole",
		prefix + "GetFeatureGatingValueInBool",
		prefix + "SetFeatureGatingBoolValue",
		prefix + "GetFeatureGatingValueInStrings",
		prefix + "UpdateFeatureGatingValue",
	}
	if httpClient, ok := client.(*http.Client); ok {
		return &rBACAdminProtobufClient{
			client: withoutRedirects(httpClient),
			urls:   urls,
		}
	}
	return &rBACAdminProtobufClient{
		client: client,
		urls:   urls,
	}
}

func (c *rBACAdminProtobufClient) DeleteCompany(ctx context.Context, in *DeleteCompanyRequest) (*Empty, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.devrel.rbac")
	ctx = ctxsetters.WithServiceName(ctx, "RBACAdmin")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteCompany")
	out := new(Empty)
	err := doProtobufRequest(ctx, c.client, c.urls[0], in, out)
	return out, err
}

func (c *rBACAdminProtobufClient) OffboardResource(ctx context.Context, in *OffboardResourceRequest) (*Empty, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.devrel.rbac")
	ctx = ctxsetters.WithServiceName(ctx, "RBACAdmin")
	ctx = ctxsetters.WithMethodName(ctx, "OffboardResource")
	out := new(Empty)
	err := doProtobufRequest(ctx, c.client, c.urls[1], in, out)
	return out, err
}

func (c *rBACAdminProtobufClient) TransferCompanyOwnership(ctx context.Context, in *TransferCompanyOwnershipRequest) (*Empty, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.devrel.rbac")
	ctx = ctxsetters.WithServiceName(ctx, "RBACAdmin")
	ctx = ctxsetters.WithMethodName(ctx, "TransferCompanyOwnership")
	out := new(Empty)
	err := doProtobufRequest(ctx, c.client, c.urls[2], in, out)
	return out, err
}

func (c *rBACAdminProtobufClient) WhitelistUser(ctx context.Context, in *WhitelistUserRequest) (*Empty, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.devrel.rbac")
	ctx = ctxsetters.WithServiceName(ctx, "RBACAdmin")
	ctx = ctxsetters.WithMethodName(ctx, "WhitelistUser")
	out := new(Empty)
	err := doProtobufRequest(ctx, c.client, c.urls[3], in, out)
	return out, err
}

func (c *rBACAdminProtobufClient) RemoveUserFromWhitelist(ctx context.Context, in *RemoveUserFromWhitelistRequest) (*Empty, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.devrel.rbac")
	ctx = ctxsetters.WithServiceName(ctx, "RBACAdmin")
	ctx = ctxsetters.WithMethodName(ctx, "RemoveUserFromWhitelist")
	out := new(Empty)
	err := doProtobufRequest(ctx, c.client, c.urls[4], in, out)
	return out, err
}

func (c *rBACAdminProtobufClient) UpdateUserRoleInWhitelist(ctx context.Context, in *WhitelistUserRequest) (*Empty, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.devrel.rbac")
	ctx = ctxsetters.WithServiceName(ctx, "RBACAdmin")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateUserRoleInWhitelist")
	out := new(Empty)
	err := doProtobufRequest(ctx, c.client, c.urls[5], in, out)
	return out, err
}

func (c *rBACAdminProtobufClient) ListUserWhitelistByRole(ctx context.Context, in *ListUserWhitelistByRoleRequest) (*ListUserWhitelistByRoleResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.devrel.rbac")
	ctx = ctxsetters.WithServiceName(ctx, "RBACAdmin")
	ctx = ctxsetters.WithMethodName(ctx, "ListUserWhitelistByRole")
	out := new(ListUserWhitelistByRoleResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[6], in, out)
	return out, err
}

func (c *rBACAdminProtobufClient) GetFeatureGatingValueInBool(ctx context.Context, in *GetFeatureGatingValueRequest) (*GetFeatureGatingValueResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.devrel.rbac")
	ctx = ctxsetters.WithServiceName(ctx, "RBACAdmin")
	ctx = ctxsetters.WithMethodName(ctx, "GetFeatureGatingValueInBool")
	out := new(GetFeatureGatingValueResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[7], in, out)
	return out, err
}

func (c *rBACAdminProtobufClient) SetFeatureGatingBoolValue(ctx context.Context, in *SetFeatureGatingBoolValueRequest) (*Empty, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.devrel.rbac")
	ctx = ctxsetters.WithServiceName(ctx, "RBACAdmin")
	ctx = ctxsetters.WithMethodName(ctx, "SetFeatureGatingBoolValue")
	out := new(Empty)
	err := doProtobufRequest(ctx, c.client, c.urls[8], in, out)
	return out, err
}

func (c *rBACAdminProtobufClient) GetFeatureGatingValueInStrings(ctx context.Context, in *GetFeatureGatingValueRequest) (*GetFeatureGatingValueResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.devrel.rbac")
	ctx = ctxsetters.WithServiceName(ctx, "RBACAdmin")
	ctx = ctxsetters.WithMethodName(ctx, "GetFeatureGatingValueInStrings")
	out := new(GetFeatureGatingValueResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[9], in, out)
	return out, err
}

func (c *rBACAdminProtobufClient) UpdateFeatureGatingValue(ctx context.Context, in *UpdateFeatureGatingValueRequest) (*GetFeatureGatingValueResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.devrel.rbac")
	ctx = ctxsetters.WithServiceName(ctx, "RBACAdmin")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateFeatureGatingValue")
	out := new(GetFeatureGatingValueResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[10], in, out)
	return out, err
}

// =====================
// RBACAdmin JSON Client
// =====================

type rBACAdminJSONClient struct {
	client HTTPClient
	urls   [11]string
}

// NewRBACAdminJSONClient creates a JSON client that implements the RBACAdmin interface.
// It communicates using JSON and can be configured with a custom HTTPClient.
func NewRBACAdminJSONClient(addr string, client HTTPClient) RBACAdmin {
	prefix := urlBase(addr) + RBACAdminPathPrefix
	urls := [11]string{
		prefix + "DeleteCompany",
		prefix + "OffboardResource",
		prefix + "TransferCompanyOwnership",
		prefix + "WhitelistUser",
		prefix + "RemoveUserFromWhitelist",
		prefix + "UpdateUserRoleInWhitelist",
		prefix + "ListUserWhitelistByRole",
		prefix + "GetFeatureGatingValueInBool",
		prefix + "SetFeatureGatingBoolValue",
		prefix + "GetFeatureGatingValueInStrings",
		prefix + "UpdateFeatureGatingValue",
	}
	if httpClient, ok := client.(*http.Client); ok {
		return &rBACAdminJSONClient{
			client: withoutRedirects(httpClient),
			urls:   urls,
		}
	}
	return &rBACAdminJSONClient{
		client: client,
		urls:   urls,
	}
}

func (c *rBACAdminJSONClient) DeleteCompany(ctx context.Context, in *DeleteCompanyRequest) (*Empty, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.devrel.rbac")
	ctx = ctxsetters.WithServiceName(ctx, "RBACAdmin")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteCompany")
	out := new(Empty)
	err := doJSONRequest(ctx, c.client, c.urls[0], in, out)
	return out, err
}

func (c *rBACAdminJSONClient) OffboardResource(ctx context.Context, in *OffboardResourceRequest) (*Empty, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.devrel.rbac")
	ctx = ctxsetters.WithServiceName(ctx, "RBACAdmin")
	ctx = ctxsetters.WithMethodName(ctx, "OffboardResource")
	out := new(Empty)
	err := doJSONRequest(ctx, c.client, c.urls[1], in, out)
	return out, err
}

func (c *rBACAdminJSONClient) TransferCompanyOwnership(ctx context.Context, in *TransferCompanyOwnershipRequest) (*Empty, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.devrel.rbac")
	ctx = ctxsetters.WithServiceName(ctx, "RBACAdmin")
	ctx = ctxsetters.WithMethodName(ctx, "TransferCompanyOwnership")
	out := new(Empty)
	err := doJSONRequest(ctx, c.client, c.urls[2], in, out)
	return out, err
}

func (c *rBACAdminJSONClient) WhitelistUser(ctx context.Context, in *WhitelistUserRequest) (*Empty, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.devrel.rbac")
	ctx = ctxsetters.WithServiceName(ctx, "RBACAdmin")
	ctx = ctxsetters.WithMethodName(ctx, "WhitelistUser")
	out := new(Empty)
	err := doJSONRequest(ctx, c.client, c.urls[3], in, out)
	return out, err
}

func (c *rBACAdminJSONClient) RemoveUserFromWhitelist(ctx context.Context, in *RemoveUserFromWhitelistRequest) (*Empty, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.devrel.rbac")
	ctx = ctxsetters.WithServiceName(ctx, "RBACAdmin")
	ctx = ctxsetters.WithMethodName(ctx, "RemoveUserFromWhitelist")
	out := new(Empty)
	err := doJSONRequest(ctx, c.client, c.urls[4], in, out)
	return out, err
}

func (c *rBACAdminJSONClient) UpdateUserRoleInWhitelist(ctx context.Context, in *WhitelistUserRequest) (*Empty, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.devrel.rbac")
	ctx = ctxsetters.WithServiceName(ctx, "RBACAdmin")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateUserRoleInWhitelist")
	out := new(Empty)
	err := doJSONRequest(ctx, c.client, c.urls[5], in, out)
	return out, err
}

func (c *rBACAdminJSONClient) ListUserWhitelistByRole(ctx context.Context, in *ListUserWhitelistByRoleRequest) (*ListUserWhitelistByRoleResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.devrel.rbac")
	ctx = ctxsetters.WithServiceName(ctx, "RBACAdmin")
	ctx = ctxsetters.WithMethodName(ctx, "ListUserWhitelistByRole")
	out := new(ListUserWhitelistByRoleResponse)
	err := doJSONRequest(ctx, c.client, c.urls[6], in, out)
	return out, err
}

func (c *rBACAdminJSONClient) GetFeatureGatingValueInBool(ctx context.Context, in *GetFeatureGatingValueRequest) (*GetFeatureGatingValueResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.devrel.rbac")
	ctx = ctxsetters.WithServiceName(ctx, "RBACAdmin")
	ctx = ctxsetters.WithMethodName(ctx, "GetFeatureGatingValueInBool")
	out := new(GetFeatureGatingValueResponse)
	err := doJSONRequest(ctx, c.client, c.urls[7], in, out)
	return out, err
}

func (c *rBACAdminJSONClient) SetFeatureGatingBoolValue(ctx context.Context, in *SetFeatureGatingBoolValueRequest) (*Empty, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.devrel.rbac")
	ctx = ctxsetters.WithServiceName(ctx, "RBACAdmin")
	ctx = ctxsetters.WithMethodName(ctx, "SetFeatureGatingBoolValue")
	out := new(Empty)
	err := doJSONRequest(ctx, c.client, c.urls[8], in, out)
	return out, err
}

func (c *rBACAdminJSONClient) GetFeatureGatingValueInStrings(ctx context.Context, in *GetFeatureGatingValueRequest) (*GetFeatureGatingValueResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.devrel.rbac")
	ctx = ctxsetters.WithServiceName(ctx, "RBACAdmin")
	ctx = ctxsetters.WithMethodName(ctx, "GetFeatureGatingValueInStrings")
	out := new(GetFeatureGatingValueResponse)
	err := doJSONRequest(ctx, c.client, c.urls[9], in, out)
	return out, err
}

func (c *rBACAdminJSONClient) UpdateFeatureGatingValue(ctx context.Context, in *UpdateFeatureGatingValueRequest) (*GetFeatureGatingValueResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.devrel.rbac")
	ctx = ctxsetters.WithServiceName(ctx, "RBACAdmin")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateFeatureGatingValue")
	out := new(GetFeatureGatingValueResponse)
	err := doJSONRequest(ctx, c.client, c.urls[10], in, out)
	return out, err
}

// ========================
// RBACAdmin Server Handler
// ========================

type rBACAdminServer struct {
	RBACAdmin
	hooks *twirp.ServerHooks
}

func NewRBACAdminServer(svc RBACAdmin, hooks *twirp.ServerHooks) TwirpServer {
	return &rBACAdminServer{
		RBACAdmin: svc,
		hooks:     hooks,
	}
}

// writeError writes an HTTP response with a valid Twirp error format, and triggers hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func (s *rBACAdminServer) writeError(ctx context.Context, resp http.ResponseWriter, err error) {
	writeError(ctx, resp, err, s.hooks)
}

// RBACAdminPathPrefix is used for all URL paths on a twirp RBACAdmin server.
// Requests are always: POST RBACAdminPathPrefix/method
// It can be used in an HTTP mux to route twirp requests along with non-twirp requests on other routes.
const RBACAdminPathPrefix = "/twirp/code.justin.tv.devrel.rbac.RBACAdmin/"

func (s *rBACAdminServer) ServeHTTP(resp http.ResponseWriter, req *http.Request) {
	ctx := req.Context()
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.devrel.rbac")
	ctx = ctxsetters.WithServiceName(ctx, "RBACAdmin")
	ctx = ctxsetters.WithResponseWriter(ctx, resp)

	var err error
	ctx, err = callRequestReceived(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	if req.Method != "POST" {
		msg := fmt.Sprintf("unsupported method %q (only POST is allowed)", req.Method)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}

	switch req.URL.Path {
	case "/twirp/code.justin.tv.devrel.rbac.RBACAdmin/DeleteCompany":
		s.serveDeleteCompany(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.devrel.rbac.RBACAdmin/OffboardResource":
		s.serveOffboardResource(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.devrel.rbac.RBACAdmin/TransferCompanyOwnership":
		s.serveTransferCompanyOwnership(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.devrel.rbac.RBACAdmin/WhitelistUser":
		s.serveWhitelistUser(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.devrel.rbac.RBACAdmin/RemoveUserFromWhitelist":
		s.serveRemoveUserFromWhitelist(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.devrel.rbac.RBACAdmin/UpdateUserRoleInWhitelist":
		s.serveUpdateUserRoleInWhitelist(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.devrel.rbac.RBACAdmin/ListUserWhitelistByRole":
		s.serveListUserWhitelistByRole(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.devrel.rbac.RBACAdmin/GetFeatureGatingValueInBool":
		s.serveGetFeatureGatingValueInBool(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.devrel.rbac.RBACAdmin/SetFeatureGatingBoolValue":
		s.serveSetFeatureGatingBoolValue(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.devrel.rbac.RBACAdmin/GetFeatureGatingValueInStrings":
		s.serveGetFeatureGatingValueInStrings(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.devrel.rbac.RBACAdmin/UpdateFeatureGatingValue":
		s.serveUpdateFeatureGatingValue(ctx, resp, req)
		return
	default:
		msg := fmt.Sprintf("no handler for path %q", req.URL.Path)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}
}

func (s *rBACAdminServer) serveDeleteCompany(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveDeleteCompanyJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveDeleteCompanyProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *rBACAdminServer) serveDeleteCompanyJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteCompany")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(DeleteCompanyRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *Empty
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.DeleteCompany(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Empty and nil error while calling DeleteCompany. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *rBACAdminServer) serveDeleteCompanyProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteCompany")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(DeleteCompanyRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *Empty
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.DeleteCompany(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Empty and nil error while calling DeleteCompany. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *rBACAdminServer) serveOffboardResource(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveOffboardResourceJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveOffboardResourceProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *rBACAdminServer) serveOffboardResourceJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "OffboardResource")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(OffboardResourceRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *Empty
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.OffboardResource(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Empty and nil error while calling OffboardResource. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *rBACAdminServer) serveOffboardResourceProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "OffboardResource")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(OffboardResourceRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *Empty
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.OffboardResource(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Empty and nil error while calling OffboardResource. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *rBACAdminServer) serveTransferCompanyOwnership(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveTransferCompanyOwnershipJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveTransferCompanyOwnershipProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *rBACAdminServer) serveTransferCompanyOwnershipJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "TransferCompanyOwnership")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(TransferCompanyOwnershipRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *Empty
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.TransferCompanyOwnership(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Empty and nil error while calling TransferCompanyOwnership. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *rBACAdminServer) serveTransferCompanyOwnershipProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "TransferCompanyOwnership")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(TransferCompanyOwnershipRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *Empty
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.TransferCompanyOwnership(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Empty and nil error while calling TransferCompanyOwnership. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *rBACAdminServer) serveWhitelistUser(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveWhitelistUserJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveWhitelistUserProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *rBACAdminServer) serveWhitelistUserJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "WhitelistUser")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(WhitelistUserRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *Empty
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.WhitelistUser(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Empty and nil error while calling WhitelistUser. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *rBACAdminServer) serveWhitelistUserProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "WhitelistUser")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(WhitelistUserRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *Empty
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.WhitelistUser(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Empty and nil error while calling WhitelistUser. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *rBACAdminServer) serveRemoveUserFromWhitelist(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveRemoveUserFromWhitelistJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveRemoveUserFromWhitelistProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *rBACAdminServer) serveRemoveUserFromWhitelistJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "RemoveUserFromWhitelist")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(RemoveUserFromWhitelistRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *Empty
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.RemoveUserFromWhitelist(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Empty and nil error while calling RemoveUserFromWhitelist. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *rBACAdminServer) serveRemoveUserFromWhitelistProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "RemoveUserFromWhitelist")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(RemoveUserFromWhitelistRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *Empty
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.RemoveUserFromWhitelist(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Empty and nil error while calling RemoveUserFromWhitelist. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *rBACAdminServer) serveUpdateUserRoleInWhitelist(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveUpdateUserRoleInWhitelistJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveUpdateUserRoleInWhitelistProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *rBACAdminServer) serveUpdateUserRoleInWhitelistJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateUserRoleInWhitelist")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(WhitelistUserRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *Empty
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.UpdateUserRoleInWhitelist(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Empty and nil error while calling UpdateUserRoleInWhitelist. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *rBACAdminServer) serveUpdateUserRoleInWhitelistProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateUserRoleInWhitelist")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(WhitelistUserRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *Empty
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.UpdateUserRoleInWhitelist(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Empty and nil error while calling UpdateUserRoleInWhitelist. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *rBACAdminServer) serveListUserWhitelistByRole(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveListUserWhitelistByRoleJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveListUserWhitelistByRoleProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *rBACAdminServer) serveListUserWhitelistByRoleJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListUserWhitelistByRole")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ListUserWhitelistByRoleRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ListUserWhitelistByRoleResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.ListUserWhitelistByRole(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListUserWhitelistByRoleResponse and nil error while calling ListUserWhitelistByRole. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *rBACAdminServer) serveListUserWhitelistByRoleProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListUserWhitelistByRole")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(ListUserWhitelistByRoleRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ListUserWhitelistByRoleResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.ListUserWhitelistByRole(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListUserWhitelistByRoleResponse and nil error while calling ListUserWhitelistByRole. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *rBACAdminServer) serveGetFeatureGatingValueInBool(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetFeatureGatingValueInBoolJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetFeatureGatingValueInBoolProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *rBACAdminServer) serveGetFeatureGatingValueInBoolJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetFeatureGatingValueInBool")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetFeatureGatingValueRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetFeatureGatingValueResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetFeatureGatingValueInBool(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetFeatureGatingValueResponse and nil error while calling GetFeatureGatingValueInBool. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *rBACAdminServer) serveGetFeatureGatingValueInBoolProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetFeatureGatingValueInBool")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetFeatureGatingValueRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetFeatureGatingValueResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetFeatureGatingValueInBool(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetFeatureGatingValueResponse and nil error while calling GetFeatureGatingValueInBool. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *rBACAdminServer) serveSetFeatureGatingBoolValue(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveSetFeatureGatingBoolValueJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveSetFeatureGatingBoolValueProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *rBACAdminServer) serveSetFeatureGatingBoolValueJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "SetFeatureGatingBoolValue")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(SetFeatureGatingBoolValueRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *Empty
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.SetFeatureGatingBoolValue(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Empty and nil error while calling SetFeatureGatingBoolValue. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *rBACAdminServer) serveSetFeatureGatingBoolValueProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "SetFeatureGatingBoolValue")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(SetFeatureGatingBoolValueRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *Empty
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.SetFeatureGatingBoolValue(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Empty and nil error while calling SetFeatureGatingBoolValue. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *rBACAdminServer) serveGetFeatureGatingValueInStrings(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetFeatureGatingValueInStringsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetFeatureGatingValueInStringsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *rBACAdminServer) serveGetFeatureGatingValueInStringsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetFeatureGatingValueInStrings")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetFeatureGatingValueRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetFeatureGatingValueResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetFeatureGatingValueInStrings(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetFeatureGatingValueResponse and nil error while calling GetFeatureGatingValueInStrings. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *rBACAdminServer) serveGetFeatureGatingValueInStringsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetFeatureGatingValueInStrings")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetFeatureGatingValueRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetFeatureGatingValueResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetFeatureGatingValueInStrings(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetFeatureGatingValueResponse and nil error while calling GetFeatureGatingValueInStrings. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *rBACAdminServer) serveUpdateFeatureGatingValue(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveUpdateFeatureGatingValueJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveUpdateFeatureGatingValueProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *rBACAdminServer) serveUpdateFeatureGatingValueJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateFeatureGatingValue")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(UpdateFeatureGatingValueRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetFeatureGatingValueResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.UpdateFeatureGatingValue(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetFeatureGatingValueResponse and nil error while calling UpdateFeatureGatingValue. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *rBACAdminServer) serveUpdateFeatureGatingValueProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateFeatureGatingValue")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(UpdateFeatureGatingValueRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetFeatureGatingValueResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.UpdateFeatureGatingValue(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetFeatureGatingValueResponse and nil error while calling UpdateFeatureGatingValue. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *rBACAdminServer) ServiceDescriptor() ([]byte, int) {
	return twirpFileDescriptor0, 1
}

func (s *rBACAdminServer) ProtocGenTwirpVersion() string {
	return "v5.3.0"
}

// ===========================
// RBACActionHistory Interface
// ===========================

// RBACActionHistory has extracted form RBAC. It just has one method to load action history.
// Should be merged into ViennaBackend
type RBACActionHistory interface {
	// Called from Vienna. List admin actions on a resource.
	ListEntityActionHistories(context.Context, *ListEntityActionHistoriesRequest) (*ListActionHistoriesResponse, error)
}

// =================================
// RBACActionHistory Protobuf Client
// =================================

type rBACActionHistoryProtobufClient struct {
	client HTTPClient
	urls   [1]string
}

// NewRBACActionHistoryProtobufClient creates a Protobuf client that implements the RBACActionHistory interface.
// It communicates using Protobuf and can be configured with a custom HTTPClient.
func NewRBACActionHistoryProtobufClient(addr string, client HTTPClient) RBACActionHistory {
	prefix := urlBase(addr) + RBACActionHistoryPathPrefix
	urls := [1]string{
		prefix + "ListEntityActionHistories",
	}
	if httpClient, ok := client.(*http.Client); ok {
		return &rBACActionHistoryProtobufClient{
			client: withoutRedirects(httpClient),
			urls:   urls,
		}
	}
	return &rBACActionHistoryProtobufClient{
		client: client,
		urls:   urls,
	}
}

func (c *rBACActionHistoryProtobufClient) ListEntityActionHistories(ctx context.Context, in *ListEntityActionHistoriesRequest) (*ListActionHistoriesResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.devrel.rbac")
	ctx = ctxsetters.WithServiceName(ctx, "RBACActionHistory")
	ctx = ctxsetters.WithMethodName(ctx, "ListEntityActionHistories")
	out := new(ListActionHistoriesResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[0], in, out)
	return out, err
}

// =============================
// RBACActionHistory JSON Client
// =============================

type rBACActionHistoryJSONClient struct {
	client HTTPClient
	urls   [1]string
}

// NewRBACActionHistoryJSONClient creates a JSON client that implements the RBACActionHistory interface.
// It communicates using JSON and can be configured with a custom HTTPClient.
func NewRBACActionHistoryJSONClient(addr string, client HTTPClient) RBACActionHistory {
	prefix := urlBase(addr) + RBACActionHistoryPathPrefix
	urls := [1]string{
		prefix + "ListEntityActionHistories",
	}
	if httpClient, ok := client.(*http.Client); ok {
		return &rBACActionHistoryJSONClient{
			client: withoutRedirects(httpClient),
			urls:   urls,
		}
	}
	return &rBACActionHistoryJSONClient{
		client: client,
		urls:   urls,
	}
}

func (c *rBACActionHistoryJSONClient) ListEntityActionHistories(ctx context.Context, in *ListEntityActionHistoriesRequest) (*ListActionHistoriesResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.devrel.rbac")
	ctx = ctxsetters.WithServiceName(ctx, "RBACActionHistory")
	ctx = ctxsetters.WithMethodName(ctx, "ListEntityActionHistories")
	out := new(ListActionHistoriesResponse)
	err := doJSONRequest(ctx, c.client, c.urls[0], in, out)
	return out, err
}

// ================================
// RBACActionHistory Server Handler
// ================================

type rBACActionHistoryServer struct {
	RBACActionHistory
	hooks *twirp.ServerHooks
}

func NewRBACActionHistoryServer(svc RBACActionHistory, hooks *twirp.ServerHooks) TwirpServer {
	return &rBACActionHistoryServer{
		RBACActionHistory: svc,
		hooks:             hooks,
	}
}

// writeError writes an HTTP response with a valid Twirp error format, and triggers hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func (s *rBACActionHistoryServer) writeError(ctx context.Context, resp http.ResponseWriter, err error) {
	writeError(ctx, resp, err, s.hooks)
}

// RBACActionHistoryPathPrefix is used for all URL paths on a twirp RBACActionHistory server.
// Requests are always: POST RBACActionHistoryPathPrefix/method
// It can be used in an HTTP mux to route twirp requests along with non-twirp requests on other routes.
const RBACActionHistoryPathPrefix = "/twirp/code.justin.tv.devrel.rbac.RBACActionHistory/"

func (s *rBACActionHistoryServer) ServeHTTP(resp http.ResponseWriter, req *http.Request) {
	ctx := req.Context()
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.devrel.rbac")
	ctx = ctxsetters.WithServiceName(ctx, "RBACActionHistory")
	ctx = ctxsetters.WithResponseWriter(ctx, resp)

	var err error
	ctx, err = callRequestReceived(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	if req.Method != "POST" {
		msg := fmt.Sprintf("unsupported method %q (only POST is allowed)", req.Method)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}

	switch req.URL.Path {
	case "/twirp/code.justin.tv.devrel.rbac.RBACActionHistory/ListEntityActionHistories":
		s.serveListEntityActionHistories(ctx, resp, req)
		return
	default:
		msg := fmt.Sprintf("no handler for path %q", req.URL.Path)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}
}

func (s *rBACActionHistoryServer) serveListEntityActionHistories(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveListEntityActionHistoriesJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveListEntityActionHistoriesProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *rBACActionHistoryServer) serveListEntityActionHistoriesJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListEntityActionHistories")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ListEntityActionHistoriesRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ListActionHistoriesResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.ListEntityActionHistories(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListActionHistoriesResponse and nil error while calling ListEntityActionHistories. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *rBACActionHistoryServer) serveListEntityActionHistoriesProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListEntityActionHistories")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(ListEntityActionHistoriesRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ListActionHistoriesResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.ListEntityActionHistories(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListActionHistoriesResponse and nil error while calling ListEntityActionHistories. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *rBACActionHistoryServer) ServiceDescriptor() ([]byte, int) {
	return twirpFileDescriptor0, 2
}

func (s *rBACActionHistoryServer) ProtocGenTwirpVersion() string {
	return "v5.3.0"
}

// ==========================
// ExtensionReviews Interface
// ==========================

// ExtensionReviews service has endpoints for both GraphQL and Vienna to manage extension version states
// lifecycle: => "review" => {"approved" | "pending_action"}.
// Methods called from the edge (GraphQL) need a valid Cartman Twitch-Authorization header,
// the user_twitch_id parameter must be owner of the Cartman token (current user).
// Methods called from Vienna (internal tool) need a valid OAuth token Authorization header,
// that is used to retrieve the Twitch-Authorization token from Cartman.
type ExtensionReviews interface {
	// Called from the edge (GraphQL). Author sets the version state to be in review.
	// Creates an Extension Case in Salesforce, then transitions the version in EMS to "review".
	SetStateInReview(context.Context, *SetStateInReviewRequest) (*Empty, error)

	// Called from the edge (GraphQL). Load latest author review notes and test-channel from review logs.
	GetLatestAuthorNotes(context.Context, *GetLatestAuthorNotesRequest) (*GetLatestAuthorNotesResponse, error)

	// Called from Vienna. Load the extension details for review and the review logs.
	GetExtension(context.Context, *ExtensionVersionID) (*Extension, error)

	// Called from Vienna. Moderator sets the state to "review".
	SetStateApproved(context.Context, *SetStateReviewerRequest) (*Empty, error)

	// Called from Vienna. Moderator sets the state to "pending_action".
	SetStatePendingAction(context.Context, *SetStateReviewerRequest) (*Empty, error)
}

// ================================
// ExtensionReviews Protobuf Client
// ================================

type extensionReviewsProtobufClient struct {
	client HTTPClient
	urls   [5]string
}

// NewExtensionReviewsProtobufClient creates a Protobuf client that implements the ExtensionReviews interface.
// It communicates using Protobuf and can be configured with a custom HTTPClient.
func NewExtensionReviewsProtobufClient(addr string, client HTTPClient) ExtensionReviews {
	prefix := urlBase(addr) + ExtensionReviewsPathPrefix
	urls := [5]string{
		prefix + "SetStateInReview",
		prefix + "GetLatestAuthorNotes",
		prefix + "GetExtension",
		prefix + "SetStateApproved",
		prefix + "SetStatePendingAction",
	}
	if httpClient, ok := client.(*http.Client); ok {
		return &extensionReviewsProtobufClient{
			client: withoutRedirects(httpClient),
			urls:   urls,
		}
	}
	return &extensionReviewsProtobufClient{
		client: client,
		urls:   urls,
	}
}

func (c *extensionReviewsProtobufClient) SetStateInReview(ctx context.Context, in *SetStateInReviewRequest) (*Empty, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.devrel.rbac")
	ctx = ctxsetters.WithServiceName(ctx, "ExtensionReviews")
	ctx = ctxsetters.WithMethodName(ctx, "SetStateInReview")
	out := new(Empty)
	err := doProtobufRequest(ctx, c.client, c.urls[0], in, out)
	return out, err
}

func (c *extensionReviewsProtobufClient) GetLatestAuthorNotes(ctx context.Context, in *GetLatestAuthorNotesRequest) (*GetLatestAuthorNotesResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.devrel.rbac")
	ctx = ctxsetters.WithServiceName(ctx, "ExtensionReviews")
	ctx = ctxsetters.WithMethodName(ctx, "GetLatestAuthorNotes")
	out := new(GetLatestAuthorNotesResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[1], in, out)
	return out, err
}

func (c *extensionReviewsProtobufClient) GetExtension(ctx context.Context, in *ExtensionVersionID) (*Extension, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.devrel.rbac")
	ctx = ctxsetters.WithServiceName(ctx, "ExtensionReviews")
	ctx = ctxsetters.WithMethodName(ctx, "GetExtension")
	out := new(Extension)
	err := doProtobufRequest(ctx, c.client, c.urls[2], in, out)
	return out, err
}

func (c *extensionReviewsProtobufClient) SetStateApproved(ctx context.Context, in *SetStateReviewerRequest) (*Empty, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.devrel.rbac")
	ctx = ctxsetters.WithServiceName(ctx, "ExtensionReviews")
	ctx = ctxsetters.WithMethodName(ctx, "SetStateApproved")
	out := new(Empty)
	err := doProtobufRequest(ctx, c.client, c.urls[3], in, out)
	return out, err
}

func (c *extensionReviewsProtobufClient) SetStatePendingAction(ctx context.Context, in *SetStateReviewerRequest) (*Empty, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.devrel.rbac")
	ctx = ctxsetters.WithServiceName(ctx, "ExtensionReviews")
	ctx = ctxsetters.WithMethodName(ctx, "SetStatePendingAction")
	out := new(Empty)
	err := doProtobufRequest(ctx, c.client, c.urls[4], in, out)
	return out, err
}

// ============================
// ExtensionReviews JSON Client
// ============================

type extensionReviewsJSONClient struct {
	client HTTPClient
	urls   [5]string
}

// NewExtensionReviewsJSONClient creates a JSON client that implements the ExtensionReviews interface.
// It communicates using JSON and can be configured with a custom HTTPClient.
func NewExtensionReviewsJSONClient(addr string, client HTTPClient) ExtensionReviews {
	prefix := urlBase(addr) + ExtensionReviewsPathPrefix
	urls := [5]string{
		prefix + "SetStateInReview",
		prefix + "GetLatestAuthorNotes",
		prefix + "GetExtension",
		prefix + "SetStateApproved",
		prefix + "SetStatePendingAction",
	}
	if httpClient, ok := client.(*http.Client); ok {
		return &extensionReviewsJSONClient{
			client: withoutRedirects(httpClient),
			urls:   urls,
		}
	}
	return &extensionReviewsJSONClient{
		client: client,
		urls:   urls,
	}
}

func (c *extensionReviewsJSONClient) SetStateInReview(ctx context.Context, in *SetStateInReviewRequest) (*Empty, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.devrel.rbac")
	ctx = ctxsetters.WithServiceName(ctx, "ExtensionReviews")
	ctx = ctxsetters.WithMethodName(ctx, "SetStateInReview")
	out := new(Empty)
	err := doJSONRequest(ctx, c.client, c.urls[0], in, out)
	return out, err
}

func (c *extensionReviewsJSONClient) GetLatestAuthorNotes(ctx context.Context, in *GetLatestAuthorNotesRequest) (*GetLatestAuthorNotesResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.devrel.rbac")
	ctx = ctxsetters.WithServiceName(ctx, "ExtensionReviews")
	ctx = ctxsetters.WithMethodName(ctx, "GetLatestAuthorNotes")
	out := new(GetLatestAuthorNotesResponse)
	err := doJSONRequest(ctx, c.client, c.urls[1], in, out)
	return out, err
}

func (c *extensionReviewsJSONClient) GetExtension(ctx context.Context, in *ExtensionVersionID) (*Extension, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.devrel.rbac")
	ctx = ctxsetters.WithServiceName(ctx, "ExtensionReviews")
	ctx = ctxsetters.WithMethodName(ctx, "GetExtension")
	out := new(Extension)
	err := doJSONRequest(ctx, c.client, c.urls[2], in, out)
	return out, err
}

func (c *extensionReviewsJSONClient) SetStateApproved(ctx context.Context, in *SetStateReviewerRequest) (*Empty, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.devrel.rbac")
	ctx = ctxsetters.WithServiceName(ctx, "ExtensionReviews")
	ctx = ctxsetters.WithMethodName(ctx, "SetStateApproved")
	out := new(Empty)
	err := doJSONRequest(ctx, c.client, c.urls[3], in, out)
	return out, err
}

func (c *extensionReviewsJSONClient) SetStatePendingAction(ctx context.Context, in *SetStateReviewerRequest) (*Empty, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.devrel.rbac")
	ctx = ctxsetters.WithServiceName(ctx, "ExtensionReviews")
	ctx = ctxsetters.WithMethodName(ctx, "SetStatePendingAction")
	out := new(Empty)
	err := doJSONRequest(ctx, c.client, c.urls[4], in, out)
	return out, err
}

// ===============================
// ExtensionReviews Server Handler
// ===============================

type extensionReviewsServer struct {
	ExtensionReviews
	hooks *twirp.ServerHooks
}

func NewExtensionReviewsServer(svc ExtensionReviews, hooks *twirp.ServerHooks) TwirpServer {
	return &extensionReviewsServer{
		ExtensionReviews: svc,
		hooks:            hooks,
	}
}

// writeError writes an HTTP response with a valid Twirp error format, and triggers hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func (s *extensionReviewsServer) writeError(ctx context.Context, resp http.ResponseWriter, err error) {
	writeError(ctx, resp, err, s.hooks)
}

// ExtensionReviewsPathPrefix is used for all URL paths on a twirp ExtensionReviews server.
// Requests are always: POST ExtensionReviewsPathPrefix/method
// It can be used in an HTTP mux to route twirp requests along with non-twirp requests on other routes.
const ExtensionReviewsPathPrefix = "/twirp/code.justin.tv.devrel.rbac.ExtensionReviews/"

func (s *extensionReviewsServer) ServeHTTP(resp http.ResponseWriter, req *http.Request) {
	ctx := req.Context()
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.devrel.rbac")
	ctx = ctxsetters.WithServiceName(ctx, "ExtensionReviews")
	ctx = ctxsetters.WithResponseWriter(ctx, resp)

	var err error
	ctx, err = callRequestReceived(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	if req.Method != "POST" {
		msg := fmt.Sprintf("unsupported method %q (only POST is allowed)", req.Method)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}

	switch req.URL.Path {
	case "/twirp/code.justin.tv.devrel.rbac.ExtensionReviews/SetStateInReview":
		s.serveSetStateInReview(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.devrel.rbac.ExtensionReviews/GetLatestAuthorNotes":
		s.serveGetLatestAuthorNotes(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.devrel.rbac.ExtensionReviews/GetExtension":
		s.serveGetExtension(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.devrel.rbac.ExtensionReviews/SetStateApproved":
		s.serveSetStateApproved(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.devrel.rbac.ExtensionReviews/SetStatePendingAction":
		s.serveSetStatePendingAction(ctx, resp, req)
		return
	default:
		msg := fmt.Sprintf("no handler for path %q", req.URL.Path)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}
}

func (s *extensionReviewsServer) serveSetStateInReview(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveSetStateInReviewJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveSetStateInReviewProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *extensionReviewsServer) serveSetStateInReviewJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "SetStateInReview")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(SetStateInReviewRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *Empty
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.SetStateInReview(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Empty and nil error while calling SetStateInReview. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *extensionReviewsServer) serveSetStateInReviewProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "SetStateInReview")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(SetStateInReviewRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *Empty
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.SetStateInReview(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Empty and nil error while calling SetStateInReview. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *extensionReviewsServer) serveGetLatestAuthorNotes(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetLatestAuthorNotesJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetLatestAuthorNotesProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *extensionReviewsServer) serveGetLatestAuthorNotesJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetLatestAuthorNotes")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetLatestAuthorNotesRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetLatestAuthorNotesResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetLatestAuthorNotes(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetLatestAuthorNotesResponse and nil error while calling GetLatestAuthorNotes. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *extensionReviewsServer) serveGetLatestAuthorNotesProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetLatestAuthorNotes")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetLatestAuthorNotesRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetLatestAuthorNotesResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetLatestAuthorNotes(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetLatestAuthorNotesResponse and nil error while calling GetLatestAuthorNotes. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *extensionReviewsServer) serveGetExtension(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetExtensionJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetExtensionProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *extensionReviewsServer) serveGetExtensionJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetExtension")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ExtensionVersionID)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *Extension
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetExtension(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Extension and nil error while calling GetExtension. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *extensionReviewsServer) serveGetExtensionProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetExtension")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(ExtensionVersionID)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *Extension
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetExtension(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Extension and nil error while calling GetExtension. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *extensionReviewsServer) serveSetStateApproved(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveSetStateApprovedJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveSetStateApprovedProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *extensionReviewsServer) serveSetStateApprovedJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "SetStateApproved")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(SetStateReviewerRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *Empty
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.SetStateApproved(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Empty and nil error while calling SetStateApproved. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *extensionReviewsServer) serveSetStateApprovedProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "SetStateApproved")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(SetStateReviewerRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *Empty
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.SetStateApproved(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Empty and nil error while calling SetStateApproved. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *extensionReviewsServer) serveSetStatePendingAction(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveSetStatePendingActionJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveSetStatePendingActionProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *extensionReviewsServer) serveSetStatePendingActionJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "SetStatePendingAction")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(SetStateReviewerRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *Empty
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.SetStatePendingAction(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Empty and nil error while calling SetStatePendingAction. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *extensionReviewsServer) serveSetStatePendingActionProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "SetStatePendingAction")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(SetStateReviewerRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *Empty
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.SetStatePendingAction(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Empty and nil error while calling SetStatePendingAction. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *extensionReviewsServer) ServiceDescriptor() ([]byte, int) {
	return twirpFileDescriptor0, 3
}

func (s *extensionReviewsServer) ProtocGenTwirpVersion() string {
	return "v5.3.0"
}

// =====
// Utils
// =====

// HTTPClient is the interface used by generated clients to send HTTP requests.
// It is fulfilled by *(net/http).Client, which is sufficient for most users.
// Users can provide their own implementation for special retry policies.
//
// HTTPClient implementations should not follow redirects. Redirects are
// automatically disabled if *(net/http).Client is passed to client
// constructors. See the withoutRedirects function in this file for more
// details.
type HTTPClient interface {
	Do(req *http.Request) (*http.Response, error)
}

// TwirpServer is the interface generated server structs will support: they're
// HTTP handlers with additional methods for accessing metadata about the
// service. Those accessors are a low-level API for building reflection tools.
// Most people can think of TwirpServers as just http.Handlers.
type TwirpServer interface {
	http.Handler
	// ServiceDescriptor returns gzipped bytes describing the .proto file that
	// this service was generated from. Once unzipped, the bytes can be
	// unmarshalled as a
	// github.com/golang/protobuf/protoc-gen-go/descriptor.FileDescriptorProto.
	//
	// The returned integer is the index of this particular service within that
	// FileDescriptorProto's 'Service' slice of ServiceDescriptorProtos. This is a
	// low-level field, expected to be used for reflection.
	ServiceDescriptor() ([]byte, int)
	// ProtocGenTwirpVersion is the semantic version string of the version of
	// twirp used to generate this file.
	ProtocGenTwirpVersion() string
}

// WriteError writes an HTTP response with a valid Twirp error format.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func WriteError(resp http.ResponseWriter, err error) {
	writeError(context.Background(), resp, err, nil)
}

// writeError writes Twirp errors in the response and triggers hooks.
func writeError(ctx context.Context, resp http.ResponseWriter, err error, hooks *twirp.ServerHooks) {
	// Non-twirp errors are wrapped as Internal (default)
	twerr, ok := err.(twirp.Error)
	if !ok {
		twerr = twirp.InternalErrorWith(err)
	}

	statusCode := twirp.ServerHTTPStatusFromErrorCode(twerr.Code())
	ctx = ctxsetters.WithStatusCode(ctx, statusCode)
	ctx = callError(ctx, hooks, twerr)

	resp.Header().Set("Content-Type", "application/json") // Error responses are always JSON (instead of protobuf)
	resp.WriteHeader(statusCode)                          // HTTP response status code

	respBody := marshalErrorToJSON(twerr)
	_, writeErr := resp.Write(respBody)
	if writeErr != nil {
		// We have three options here. We could log the error, call the Error
		// hook, or just silently ignore the error.
		//
		// Logging is unacceptable because we don't have a user-controlled
		// logger; writing out to stderr without permission is too rude.
		//
		// Calling the Error hook would confuse users: it would mean the Error
		// hook got called twice for one request, which is likely to lead to
		// duplicated log messages and metrics, no matter how well we document
		// the behavior.
		//
		// Silently ignoring the error is our least-bad option. It's highly
		// likely that the connection is broken and the original 'err' says
		// so anyway.
		_ = writeErr
	}

	callResponseSent(ctx, hooks)
}

// urlBase helps ensure that addr specifies a scheme. If it is unparsable
// as a URL, it returns addr unchanged.
func urlBase(addr string) string {
	// If the addr specifies a scheme, use it. If not, default to
	// http. If url.Parse fails on it, return it unchanged.
	url, err := url.Parse(addr)
	if err != nil {
		return addr
	}
	if url.Scheme == "" {
		url.Scheme = "http"
	}
	return url.String()
}

// getCustomHTTPReqHeaders retrieves a copy of any headers that are set in
// a context through the twirp.WithHTTPRequestHeaders function.
// If there are no headers set, or if they have the wrong type, nil is returned.
func getCustomHTTPReqHeaders(ctx context.Context) http.Header {
	header, ok := twirp.HTTPRequestHeaders(ctx)
	if !ok || header == nil {
		return nil
	}
	copied := make(http.Header)
	for k, vv := range header {
		if vv == nil {
			copied[k] = nil
			continue
		}
		copied[k] = make([]string, len(vv))
		copy(copied[k], vv)
	}
	return copied
}

// newRequest makes an http.Request from a client, adding common headers.
func newRequest(ctx context.Context, url string, reqBody io.Reader, contentType string) (*http.Request, error) {
	req, err := http.NewRequest("POST", url, reqBody)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if customHeader := getCustomHTTPReqHeaders(ctx); customHeader != nil {
		req.Header = customHeader
	}
	req.Header.Set("Accept", contentType)
	req.Header.Set("Content-Type", contentType)
	req.Header.Set("Twirp-Version", "v5.3.0")
	return req, nil
}

// JSON serialization for errors
type twerrJSON struct {
	Code string            `json:"code"`
	Msg  string            `json:"msg"`
	Meta map[string]string `json:"meta,omitempty"`
}

// marshalErrorToJSON returns JSON from a twirp.Error, that can be used as HTTP error response body.
// If serialization fails, it will use a descriptive Internal error instead.
func marshalErrorToJSON(twerr twirp.Error) []byte {
	// make sure that msg is not too large
	msg := twerr.Msg()
	if len(msg) > 1e6 {
		msg = msg[:1e6]
	}

	tj := twerrJSON{
		Code: string(twerr.Code()),
		Msg:  msg,
		Meta: twerr.MetaMap(),
	}

	buf, err := json.Marshal(&tj)
	if err != nil {
		buf = []byte("{\"type\": \"" + twirp.Internal + "\", \"msg\": \"There was an error but it could not be serialized into JSON\"}") // fallback
	}

	return buf
}

// errorFromResponse builds a twirp.Error from a non-200 HTTP response.
// If the response has a valid serialized Twirp error, then it's returned.
// If not, the response status code is used to generate a similar twirp
// error. See twirpErrorFromIntermediary for more info on intermediary errors.
func errorFromResponse(resp *http.Response) twirp.Error {
	statusCode := resp.StatusCode
	statusText := http.StatusText(statusCode)

	if isHTTPRedirect(statusCode) {
		// Unexpected redirect: it must be an error from an intermediary.
		// Twirp clients don't follow redirects automatically, Twirp only handles
		// POST requests, redirects should only happen on GET and HEAD requests.
		location := resp.Header.Get("Location")
		msg := fmt.Sprintf("unexpected HTTP status code %d %q received, Location=%q", statusCode, statusText, location)
		return twirpErrorFromIntermediary(statusCode, msg, location)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return clientError("failed to read server error response body", err)
	}
	var tj twerrJSON
	if err := json.Unmarshal(respBodyBytes, &tj); err != nil {
		// Invalid JSON response; it must be an error from an intermediary.
		msg := fmt.Sprintf("Error from intermediary with HTTP status code %d %q", statusCode, statusText)
		return twirpErrorFromIntermediary(statusCode, msg, string(respBodyBytes))
	}

	errorCode := twirp.ErrorCode(tj.Code)
	if !twirp.IsValidErrorCode(errorCode) {
		msg := "invalid type returned from server error response: " + tj.Code
		return twirp.InternalError(msg)
	}

	twerr := twirp.NewError(errorCode, tj.Msg)
	for k, v := range tj.Meta {
		twerr = twerr.WithMeta(k, v)
	}
	return twerr
}

// twirpErrorFromIntermediary maps HTTP errors from non-twirp sources to twirp errors.
// The mapping is similar to gRPC: https://github.com/grpc/grpc/blob/master/doc/http-grpc-status-mapping.md.
// Returned twirp Errors have some additional metadata for inspection.
func twirpErrorFromIntermediary(status int, msg string, bodyOrLocation string) twirp.Error {
	var code twirp.ErrorCode
	if isHTTPRedirect(status) { // 3xx
		code = twirp.Internal
	} else {
		switch status {
		case 400: // Bad Request
			code = twirp.Internal
		case 401: // Unauthorized
			code = twirp.Unauthenticated
		case 403: // Forbidden
			code = twirp.PermissionDenied
		case 404: // Not Found
			code = twirp.BadRoute
		case 429, 502, 503, 504: // Too Many Requests, Bad Gateway, Service Unavailable, Gateway Timeout
			code = twirp.Unavailable
		default: // All other codes
			code = twirp.Unknown
		}
	}

	twerr := twirp.NewError(code, msg)
	twerr = twerr.WithMeta("http_error_from_intermediary", "true") // to easily know if this error was from intermediary
	twerr = twerr.WithMeta("status_code", strconv.Itoa(status))
	if isHTTPRedirect(status) {
		twerr = twerr.WithMeta("location", bodyOrLocation)
	} else {
		twerr = twerr.WithMeta("body", bodyOrLocation)
	}
	return twerr
}
func isHTTPRedirect(status int) bool {
	return status >= 300 && status <= 399
}

// wrappedError implements the github.com/pkg/errors.Causer interface, allowing errors to be
// examined for their root cause.
type wrappedError struct {
	msg   string
	cause error
}

func wrapErr(err error, msg string) error { return &wrappedError{msg: msg, cause: err} }
func (e *wrappedError) Cause() error      { return e.cause }
func (e *wrappedError) Error() string     { return e.msg + ": " + e.cause.Error() }

// clientError adds consistency to errors generated in the client
func clientError(desc string, err error) twirp.Error {
	return twirp.InternalErrorWith(wrapErr(err, desc))
}

// badRouteError is used when the twirp server cannot route a request
func badRouteError(msg string, method, url string) twirp.Error {
	err := twirp.NewError(twirp.BadRoute, msg)
	err = err.WithMeta("twirp_invalid_route", method+" "+url)
	return err
}

// The standard library will, by default, redirect requests (including POSTs) if it gets a 302 or
// 303 response, and also 301s in go1.8. It redirects by making a second request, changing the
// method to GET and removing the body. This produces very confusing error messages, so instead we
// set a redirect policy that always errors. This stops Go from executing the redirect.
//
// We have to be a little careful in case the user-provided http.Client has its own CheckRedirect
// policy - if so, we'll run through that policy first.
//
// Because this requires modifying the http.Client, we make a new copy of the client and return it.
func withoutRedirects(in *http.Client) *http.Client {
	copy := *in
	copy.CheckRedirect = func(req *http.Request, via []*http.Request) error {
		if in.CheckRedirect != nil {
			// Run the input's redirect if it exists, in case it has side effects, but ignore any error it
			// returns, since we want to use ErrUseLastResponse.
			err := in.CheckRedirect(req, via)
			_ = err // Silly, but this makes sure generated code passes errcheck -blank, which some people use.
		}
		return http.ErrUseLastResponse
	}
	return &copy
}

// doProtobufRequest is common code to make a request to the remote twirp service.
func doProtobufRequest(ctx context.Context, client HTTPClient, url string, in, out proto.Message) (err error) {
	reqBodyBytes, err := proto.Marshal(in)
	if err != nil {
		return clientError("failed to marshal proto request", err)
	}
	reqBody := bytes.NewBuffer(reqBodyBytes)
	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}

	req, err := newRequest(ctx, url, reqBody, "application/protobuf")
	if err != nil {
		return clientError("could not build request", err)
	}
	resp, err := client.Do(req)
	if err != nil {
		return clientError("failed to do request", err)
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = clientError("failed to close response body", cerr)
		}
	}()

	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}

	if resp.StatusCode != 200 {
		return errorFromResponse(resp)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return clientError("failed to read response body", err)
	}
	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}

	if err = proto.Unmarshal(respBodyBytes, out); err != nil {
		return clientError("failed to unmarshal proto response", err)
	}
	return nil
}

// doJSONRequest is common code to make a request to the remote twirp service.
func doJSONRequest(ctx context.Context, client HTTPClient, url string, in, out proto.Message) (err error) {
	reqBody := bytes.NewBuffer(nil)
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(reqBody, in); err != nil {
		return clientError("failed to marshal json request", err)
	}
	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}

	req, err := newRequest(ctx, url, reqBody, "application/json")
	if err != nil {
		return clientError("could not build request", err)
	}
	resp, err := client.Do(req)
	if err != nil {
		return clientError("failed to do request", err)
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = clientError("failed to close response body", cerr)
		}
	}()

	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}

	if resp.StatusCode != 200 {
		return errorFromResponse(resp)
	}

	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(resp.Body, out); err != nil {
		return clientError("failed to unmarshal json response", err)
	}
	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}
	return nil
}

// Call twirp.ServerHooks.RequestReceived if the hook is available
func callRequestReceived(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestReceived == nil {
		return ctx, nil
	}
	return h.RequestReceived(ctx)
}

// Call twirp.ServerHooks.RequestRouted if the hook is available
func callRequestRouted(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestRouted == nil {
		return ctx, nil
	}
	return h.RequestRouted(ctx)
}

// Call twirp.ServerHooks.ResponsePrepared if the hook is available
func callResponsePrepared(ctx context.Context, h *twirp.ServerHooks) context.Context {
	if h == nil || h.ResponsePrepared == nil {
		return ctx
	}
	return h.ResponsePrepared(ctx)
}

// Call twirp.ServerHooks.ResponseSent if the hook is available
func callResponseSent(ctx context.Context, h *twirp.ServerHooks) {
	if h == nil || h.ResponseSent == nil {
		return
	}
	h.ResponseSent(ctx)
}

// Call twirp.ServerHooks.Error if the hook is available
func callError(ctx context.Context, h *twirp.ServerHooks, err twirp.Error) context.Context {
	if h == nil || h.Error == nil {
		return ctx
	}
	return h.Error(ctx, err)
}

var twirpFileDescriptor0 = []byte{
	// 4558 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xec, 0x5c, 0xeb, 0x6f, 0x1c, 0xd7,
	0x75, 0xf7, 0xec, 0x7b, 0x0f, 0x5f, 0xcb, 0x2b, 0x3e, 0x96, 0xa3, 0x07, 0xa9, 0xf1, 0x4b, 0x51,
	0x24, 0xda, 0xa6, 0x1c, 0x47, 0x56, 0xac, 0xc4, 0xcb, 0x87, 0x99, 0x75, 0x24, 0xcb, 0x59, 0xd2,
	0x62, 0xd1, 0x02, 0xdd, 0x0c, 0x77, 0x2e, 0xc9, 0x91, 0x76, 0x67, 0xd6, 0x33, 0xb3, 0xa4, 0x56,
	0x4d, 0x53, 0x03, 0x7d, 0xa6, 0x40, 0x53, 0x54, 0xa8, 0x8b, 0xa4, 0xed, 0x87, 0xa2, 0x40, 0x80,
	0x16, 0x28, 0xd0, 0x6f, 0x05, 0x8a, 0x02, 0x41, 0x5a, 0xa0, 0x40, 0xfa, 0xa5, 0x7f, 0x42, 0x81,
	0xfe, 0x27, 0xc5, 0x7d, 0xcd, 0xfb, 0xb5, 0xb4, 0x15, 0xb5, 0x68, 0x3e, 0x91, 0xf7, 0x7d, 0xee,
	0xb9, 0xbf, 0x73, 0xee, 0x39, 0xe7, 0x9e, 0x1d, 0x58, 0xb1, 0x86, 0xbd, 0x37, 0xac, 0x43, 0xb5,
	0xe7, 0xfb, 0xbb, 0x3e, 0xb4, 0x4c, 0xc7, 0x44, 0x72, 0xcf, 0xd4, 0xf0, 0xfa, 0xa3, 0x91, 0xed,
	0xe8, 0xc6, 0xba, 0x73, 0xba, 0xae, 0xe1, 0x53, 0x0b, 0xf7, 0xd7, 0x49, 0x27, 0xa5, 0x0a, 0xe5,
	0x9d, 0xc1, 0xd0, 0x19, 0x2b, 0x0b, 0x50, 0x68, 0x6b, 0x68, 0x16, 0x0a, 0xba, 0xd6, 0x94, 0xd6,
	0xa4, 0x6b, 0xf5, 0x4e, 0x41, 0xd7, 0x94, 0x3f, 0x96, 0xa0, 0xb9, 0x6f, 0xa9, 0x86, 0x7d, 0x84,
	0xad, 0x9d, 0x27, 0x0e, 0x36, 0x6c, 0xdd, 0x34, 0x3a, 0xf8, 0xd3, 0x11, 0xb6, 0x1d, 0x74, 0x19,
	0xa0, 0x67, 0x0e, 0x86, 0xaa, 0x31, 0xee, 0xba, 0x83, 0xea, 0xbc, 0xa6, 0xad, 0xa1, 0xab, 0x30,
	0x8d, 0xc5, 0x10, 0xd2, 0xa1, 0x40, 0x3b, 0x4c, 0xb9, 0x75, 0x6d, 0x0d, 0xdd, 0x00, 0x74, 0xa8,
	0xf7, 0xfb, 0xba, 0x71, 0xdc, 0x1d, 0xa8, 0x86, 0x7a, 0x8c, 0x2d, 0xd2, 0xb1, 0x48, 0x3b, 0x36,
	0x78, 0xcb, 0x7d, 0xd6, 0xd0, 0xd6, 0x94, 0x11, 0x2c, 0x6d, 0x63, 0x47, 0xed, 0x9d, 0x3c, 0x07,
	0x4a, 0x56, 0xa0, 0x66, 0x9e, 0x19, 0xfe, 0xf5, 0xab, 0xb4, 0xdc, 0xd6, 0x94, 0x5f, 0x48, 0xb0,
	0xbc, 0x87, 0x9d, 0x3d, 0x47, 0x75, 0x70, 0xdb, 0xe8, 0xe0, 0x53, 0x1d, 0x9f, 0x89, 0x85, 0x5f,
	0x81, 0xd9, 0x91, 0x8d, 0xad, 0xae, 0x73, 0xa6, 0x3b, 0xbd, 0x13, 0x6f, 0xf1, 0x69, 0x52, 0xbb,
	0x4f, 0x2b, 0xf3, 0xad, 0xff, 0x55, 0x98, 0xf7, 0xba, 0x9c, 0x62, 0x8b, 0xfc, 0x15, 0x8c, 0x70,
	0x1b, 0x1e, 0xb2, 0x7a, 0x32, 0x9f, 0x83, 0x6d, 0xa7, 0xdb, 0x3b, 0x51, 0x0d, 0x03, 0xf7, 0x9b,
	0x25, 0x36, 0x1f, 0xa9, 0xdb, 0x62, 0x55, 0x68, 0x01, 0xca, 0x86, 0xe9, 0x60, 0xbb, 0x59, 0xa6,
	0x6d, 0xac, 0xa0, 0x3c, 0x82, 0x8b, 0xbb, 0xd8, 0xb9, 0xa7, 0x92, 0x9e, 0xad, 0x91, 0x73, 0x62,
	0x5a, 0x1f, 0x91, 0x7a, 0xb1, 0x9b, 0x6b, 0xd0, 0x50, 0x69, 0x6d, 0x64, 0x3f, 0xb3, 0xac, 0x7e,
	0x82, 0x1d, 0x29, 0x9f, 0x17, 0xe0, 0x52, 0xfc, 0x62, 0xf6, 0xd0, 0x34, 0x6c, 0xfc, 0xa5, 0xae,
	0x36, 0x19, 0xff, 0xde, 0x82, 0x45, 0x8b, 0x1e, 0x63, 0xb7, 0x6f, 0x1e, 0x77, 0x7b, 0x16, 0x56,
	0x1d, 0xac, 0x75, 0x55, 0x87, 0x33, 0x12, 0xb1, 0xc6, 0x7b, 0xe6, 0xf1, 0x16, 0x6b, 0x6a, 0x39,
	0x84, 0x04, 0x4e, 0xac, 0x9f, 0xad, 0x53, 0xaa, 0xb7, 0x2f, 0xf4, 0x2a, 0x70, 0xba, 0xdd, 0x73,
	0xa9, 0xd0, 0x4e, 0x33, 0xac, 0x96, 0x9f, 0x8c, 0xf2, 0x33, 0x1f, 0x9c, 0x18, 0x98, 0xb0, 0x25,
	0x0e, 0x20, 0xbc, 0x51, 0x29, 0xe7, 0x46, 0x0b, 0x09, 0x1b, 0x5d, 0x87, 0x0b, 0x7c, 0xa3, 0x16,
	0x56, 0x6d, 0xd3, 0xe8, 0x12, 0x4d, 0x60, 0x37, 0x8b, 0x6b, 0xc5, 0x6b, 0xf5, 0xce, 0xbc, 0xc5,
	0xa1, 0x4c, 0x5a, 0xb6, 0x48, 0x03, 0x7a, 0x19, 0x66, 0x02, 0xfd, 0x39, 0x43, 0xa6, 0xfd, 0x3d,
	0x95, 0x6f, 0x02, 0xda, 0x09, 0x2d, 0xd4, 0xde, 0x0e, 0x6b, 0x0e, 0xd4, 0x84, 0x6a, 0x90, 0x3a,
	0x51, 0x24, 0xc0, 0xa8, 0xbb, 0x13, 0xe4, 0x1f, 0x87, 0x10, 0x94, 0x0c, 0x75, 0x80, 0xf9, 0xa9,
	0xd2, 0xff, 0xd1, 0x1a, 0x4c, 0x69, 0xd8, 0xee, 0x59, 0xfa, 0xd0, 0xd1, 0x5d, 0x72, 0xfd, 0x55,
	0x64, 0x3e, 0x7b, 0x34, 0x18, 0xa8, 0xd6, 0x98, 0x9f, 0x99, 0x28, 0x12, 0x11, 0xb1, 0xc9, 0x21,
	0xf0, 0x63, 0x62, 0x05, 0xb4, 0x0a, 0x53, 0xe2, 0xa0, 0xc9, 0x62, 0x55, 0xda, 0x06, 0xfc, 0x9c,
	0xc9, 0x92, 0x07, 0x30, 0xe7, 0x10, 0x8d, 0xa8, 0x93, 0xe9, 0x09, 0x80, 0xec, 0x66, 0x6d, 0xad,
	0x78, 0x6d, 0x6a, 0x63, 0x7d, 0x3d, 0x59, 0xcf, 0xae, 0xfb, 0x54, 0x16, 0xc7, 0x56, 0x67, 0xd6,
	0x9b, 0xe6, 0x9e, 0x79, 0x6c, 0x2b, 0x3f, 0x2b, 0xfa, 0x18, 0xeb, 0x76, 0xa3, 0xba, 0xcd, 0x43,
	0xa8, 0xd0, 0x6d, 0x2e, 0x30, 0xdd, 0x5d, 0x14, 0xfc, 0xbb, 0x88, 0x93, 0xad, 0x62, 0x92, 0x6c,
	0x05, 0x80, 0x5d, 0xca, 0x03, 0xec, 0x72, 0x0c, 0xb0, 0x23, 0xe0, 0xad, 0xe4, 0x04, 0x6f, 0x35,
	0x01, 0xbc, 0x37, 0x80, 0x0b, 0x62, 0x40, 0xbf, 0xd6, 0x58, 0x6f, 0xd1, 0xe2, 0xee, 0x23, 0x01,
	0xea, 0xf5, 0xdc, 0x50, 0x87, 0x28, 0xd4, 0x09, 0x09, 0xb6, 0xda, 0xc7, 0xf6, 0x91, 0x69, 0xf5,
	0x70, 0xb7, 0xa7, 0xda, 0x98, 0x90, 0x30, 0xc5, 0x48, 0xf0, 0x5a, 0xb6, 0x54, 0x1b, 0xb7, 0x35,
	0xe5, 0x7b, 0xb0, 0x76, 0x4f, 0xb7, 0x9d, 0x1d, 0xc3, 0xd1, 0x9d, 0x71, 0xab, 0x47, 0x0e, 0xf6,
	0xdb, 0xba, 0xed, 0x98, 0x96, 0xee, 0xa9, 0xd8, 0x8b, 0x50, 0xc7, 0xb4, 0xdd, 0x13, 0xef, 0x1a,
	0xab, 0x68, 0x6b, 0x04, 0x7b, 0xbc, 0xd1, 0x19, 0x0f, 0xc5, 0x89, 0x02, 0xab, 0xda, 0x1f, 0x0f,
	0xb1, 0x62, 0xc1, 0x45, 0xb2, 0x42, 0x64, 0x6e, 0xae, 0x51, 0xf7, 0x60, 0x4e, 0x0d, 0x36, 0x35,
	0x25, 0x0a, 0xcd, 0xaf, 0xa4, 0x41, 0xd3, 0x3f, 0xdb, 0xb8, 0x13, 0x9e, 0x41, 0xf9, 0x67, 0x09,
	0x66, 0x02, 0x5d, 0x22, 0x22, 0xbb, 0x04, 0x15, 0x36, 0x88, 0x53, 0xcc, 0x4b, 0x31, 0x97, 0x63,
	0x35, 0xe6, 0x72, 0xbc, 0x04, 0x1e, 0x9a, 0x39, 0xfa, 0x7c, 0xf0, 0x0e, 0xf0, 0xab, 0x9c, 0xce,
	0xaf, 0x4a, 0x84, 0x5f, 0xff, 0x52, 0x80, 0xea, 0x16, 0x33, 0x03, 0x22, 0x54, 0xaf, 0xc1, 0x14,
	0xb7, 0x10, 0x88, 0x58, 0x8b, 0x3b, 0xc5, 0x57, 0x85, 0x1a, 0x50, 0x1c, 0x59, 0x7d, 0x2e, 0x37,
	0xe4, 0x5f, 0xa2, 0x82, 0xe8, 0x4a, 0x84, 0xcc, 0x72, 0x87, 0xfe, 0x8f, 0x6e, 0x02, 0x3a, 0x3d,
	0xb1, 0xbb, 0x3d, 0xd3, 0x70, 0x2c, 0xb5, 0xe7, 0xec, 0xe9, 0xc7, 0x06, 0x66, 0xa4, 0xd6, 0x3a,
	0xf3, 0xa7, 0x27, 0xf6, 0x56, 0xa0, 0x01, 0x5d, 0x87, 0x46, 0x4f, 0x1d, 0x0c, 0x55, 0xfd, 0xd8,
	0xb0, 0x77, 0x0c, 0xf5, 0xb0, 0x8f, 0x99, 0xa4, 0xd4, 0x3a, 0x91, 0x7a, 0x74, 0x05, 0x40, 0xd7,
	0xc8, 0x76, 0x8e, 0x74, 0x6c, 0x09, 0x55, 0xe4, 0xd5, 0xa0, 0xd7, 0x61, 0xae, 0x37, 0xb2, 0x6c,
	0xbc, 0xe5, 0xd9, 0x3e, 0x35, 0x4a, 0xd9, 0xac, 0xbf, 0x3a, 0xcc, 0xe3, 0x7a, 0x98, 0xc7, 0x4b,
	0x50, 0xe9, 0xe3, 0x63, 0xb5, 0x37, 0xa6, 0x32, 0x50, 0xeb, 0xf0, 0x92, 0xf2, 0x1a, 0x2c, 0x6c,
	0xe3, 0x3e, 0x76, 0xc4, 0x44, 0x02, 0xc3, 0x61, 0x23, 0xf1, 0x17, 0x12, 0x2c, 0x10, 0x58, 0xb2,
	0x6e, 0x3e, 0xb0, 0x2f, 0x40, 0xb9, 0xaf, 0x0f, 0x74, 0xa6, 0xb5, 0x4a, 0x1d, 0x56, 0x20, 0xcb,
	0x99, 0x47, 0x47, 0x36, 0x76, 0x28, 0xcf, 0x4b, 0x1d, 0x5e, 0x42, 0xd7, 0x61, 0xfe, 0x44, 0xb5,
	0xbb, 0xc7, 0xea, 0x00, 0xdb, 0xdd, 0x21, 0x36, 0x34, 0xdd, 0x38, 0xa6, 0xcc, 0xaf, 0x75, 0xe6,
	0x4e, 0x54, 0x7b, 0x97, 0xd4, 0x7f, 0xcc, 0xaa, 0xd1, 0x1a, 0x4c, 0x9b, 0x67, 0x06, 0xeb, 0x4c,
	0xb6, 0xcd, 0x0e, 0x04, 0x48, 0x1d, 0xe9, 0xd7, 0xd6, 0xd0, 0xdb, 0xb0, 0x44, 0x66, 0xd3, 0xf0,
	0x29, 0xee, 0x9b, 0x43, 0x6c, 0x79, 0x53, 0xb2, 0xa3, 0x59, 0x38, 0x51, 0xed, 0x6d, 0xb7, 0x91,
	0xcf, 0xab, 0x7c, 0x0a, 0x8b, 0xa1, 0x9d, 0x70, 0xd1, 0x6a, 0x01, 0xb7, 0x27, 0x3d, 0xa1, 0x7a,
	0x39, 0x4d, 0xa8, 0x04, 0xcb, 0xbc, 0x51, 0x68, 0x11, 0x2a, 0x5d, 0xc7, 0x74, 0xd4, 0x3e, 0xdd,
	0x77, 0xb9, 0x53, 0xde, 0x27, 0x05, 0xe5, 0x59, 0x01, 0x16, 0x3e, 0x19, 0x6a, 0x6a, 0x16, 0x9b,
	0xff, 0x3f, 0x01, 0x56, 0xf9, 0x87, 0x0a, 0x20, 0x5e, 0x6a, 0x0d, 0x87, 0x7d, 0xbd, 0xa7, 0x3a,
	0x71, 0xc6, 0xc2, 0x55, 0x98, 0x16, 0x76, 0xbf, 0x91, 0xc0, 0x13, 0xb2, 0x24, 0xef, 0x72, 0x86,
	0x0f, 0x6d, 0xdd, 0x11, 0x06, 0xc4, 0x2c, 0xaf, 0x3e, 0x60, 0xb5, 0xfe, 0xb9, 0x7c, 0x2c, 0x13,
	0x73, 0x11, 0x75, 0x82, 0xda, 0x50, 0xa6, 0xe8, 0x6c, 0x96, 0x29, 0x00, 0x6e, 0xe5, 0x00, 0x80,
	0x8f, 0xfa, 0x75, 0x82, 0xcc, 0x0e, 0x9b, 0x01, 0xc9, 0x50, 0xd3, 0x0d, 0x6d, 0x64, 0x3b, 0xd6,
	0x98, 0xeb, 0x2d, 0xb7, 0xec, 0xa7, 0xc4, 0xd6, 0x9f, 0x0a, 0x1b, 0x44, 0x50, 0xb2, 0xa7, 0x3f,
	0xc5, 0xe4, 0x5c, 0x7b, 0xba, 0x33, 0xe6, 0xb7, 0x21, 0xfd, 0xdf, 0xb3, 0x04, 0xea, 0x7e, 0x4b,
	0xa0, 0x09, 0xd5, 0x9e, 0x39, 0x32, 0xc8, 0x3a, 0xec, 0x86, 0x13, 0x45, 0x72, 0xb9, 0x11, 0x0c,
	0xa8, 0x3d, 0xa7, 0x7b, 0xa4, 0x5b, 0xb6, 0xc3, 0x58, 0xc8, 0x2f, 0x37, 0xde, 0xf2, 0x01, 0x69,
	0xa0, 0x7c, 0xbc, 0x0e, 0xf3, 0xa2, 0x77, 0x5f, 0x15, 0x9d, 0xa7, 0x69, 0xe7, 0x39, 0xde, 0x70,
	0x4f, 0xe5, 0x7d, 0x5f, 0x86, 0x19, 0xd1, 0xd7, 0xd1, 0x9d, 0x3e, 0x6e, 0xce, 0x30, 0xbd, 0xcf,
	0x2b, 0xf7, 0x49, 0x9d, 0xbf, 0x13, 0x1e, 0xa8, 0x7a, 0xbf, 0x39, 0x1b, 0xe8, 0xb4, 0x43, 0xea,
	0xd0, 0x57, 0xa0, 0x31, 0xb4, 0x4c, 0x6d, 0xd4, 0x73, 0xba, 0xba, 0xe1, 0x60, 0x0b, 0xdb, 0x4e,
	0x73, 0x8e, 0x2d, 0xca, 0xeb, 0xdb, 0xbc, 0x9a, 0x5c, 0x06, 0x8f, 0x4c, 0xdd, 0x10, 0xd7, 0x79,
	0x83, 0x81, 0x8f, 0x54, 0xf1, 0xcb, 0xfc, 0x22, 0xd4, 0xbd, 0x9b, 0x68, 0x9e, 0xf1, 0xdc, 0x11,
	0xb7, 0xd0, 0x12, 0x54, 0x08, 0xbf, 0x46, 0x76, 0x13, 0xd1, 0x73, 0xe7, 0xa5, 0x90, 0xf5, 0x75,
	0x21, 0xac, 0x3a, 0x2f, 0x03, 0x8c, 0xa8, 0xec, 0xd2, 0xe6, 0x45, 0xd6, 0xcc, 0x6b, 0x5a, 0x0e,
	0xba, 0x03, 0x2b, 0x74, 0x6f, 0xc4, 0xd6, 0xd1, 0x8f, 0x38, 0x0e, 0xba, 0x7c, 0xa1, 0x25, 0xda,
	0x7b, 0x99, 0x76, 0x78, 0xe8, 0x6b, 0xdf, 0xa3, 0xcd, 0xf2, 0x75, 0x28, 0x11, 0xc0, 0x44, 0x30,
	0x2f, 0xcc, 0xe0, 0x82, 0x67, 0x06, 0x2b, 0xff, 0x54, 0x82, 0x55, 0xe6, 0xab, 0x44, 0x61, 0xe7,
	0xf3, 0x2d, 0x02, 0xb2, 0x22, 0xe5, 0x92, 0x95, 0x42, 0x2e, 0x59, 0x29, 0x46, 0x65, 0x65, 0x41,
	0xc8, 0x4a, 0x89, 0x5a, 0x60, 0x31, 0xb0, 0x2f, 0x67, 0xc0, 0xbe, 0x92, 0x0c, 0xfb, 0x6a, 0x1c,
	0xec, 0x6b, 0x09, 0xb0, 0xaf, 0xe7, 0x81, 0x3d, 0x4c, 0x02, 0xfb, 0xa9, 0x9c, 0xb0, 0x9f, 0xce,
	0x03, 0xfb, 0x99, 0x9c, 0xb0, 0x9f, 0xcd, 0x05, 0xfb, 0xb9, 0x74, 0xd8, 0x37, 0x82, 0xb0, 0x57,
	0x3e, 0x86, 0xd5, 0xc0, 0x15, 0x1f, 0x83, 0x9b, 0x30, 0xfe, 0x2e, 0x03, 0xd8, 0x8f, 0xf5, 0x21,
	0xa7, 0xbe, 0x40, 0x6f, 0x82, 0x3a, 0xa9, 0xa1, 0xa4, 0x2b, 0xbf, 0x2b, 0xc1, 0x15, 0xef, 0x0a,
	0xf5, 0x4f, 0x78, 0x4e, 0xb3, 0xc0, 0x93, 0xcc, 0x62, 0x40, 0x32, 0x03, 0xfb, 0x2a, 0x85, 0xf6,
	0xf5, 0x97, 0x12, 0xac, 0x26, 0x52, 0xc1, 0xaf, 0xf4, 0xef, 0xc1, 0x85, 0x5e, 0xb4, 0x99, 0x5f,
	0xee, 0xeb, 0x93, 0xe9, 0xf6, 0x4e, 0xdc, 0x54, 0x49, 0x37, 0xfe, 0x7f, 0x95, 0x60, 0x35, 0x70,
	0xe3, 0xe7, 0xe0, 0xfa, 0x2f, 0xf9, 0xa6, 0x5b, 0xf0, 0xdf, 0x74, 0xf5, 0x5f, 0x5d, 0x5a, 0xff,
	0xa7, 0x2e, 0x2d, 0xe5, 0x75, 0x58, 0x7c, 0x60, 0x1c, 0x9a, 0xaa, 0xa5, 0x65, 0x58, 0xee, 0xc7,
	0xb0, 0x14, 0xee, 0xc8, 0x85, 0x23, 0x8c, 0xbf, 0xbb, 0xe4, 0x44, 0x68, 0x17, 0x0a, 0xbd, 0x9c,
	0xd6, 0xaf, 0x18, 0xa3, 0xdc, 0x8f, 0x5c, 0x66, 0x65, 0x01, 0xeb, 0x63, 0x5d, 0x35, 0x9c, 0x43,
	0x73, 0x70, 0x28, 0x22, 0x7b, 0xe5, 0xce, 0x94, 0x5b, 0xd7, 0xd6, 0xe2, 0xc2, 0x3e, 0xca, 0xcf,
	0x25, 0x98, 0x23, 0xf3, 0x1d, 0xe8, 0xce, 0x49, 0xd4, 0xbf, 0xcb, 0x3d, 0x75, 0x30, 0x6c, 0x5c,
	0x0c, 0x87, 0x8d, 0x63, 0xac, 0xd5, 0x52, 0xac, 0x7b, 0x25, 0x43, 0x8d, 0x08, 0x08, 0x25, 0x93,
	0xdf, 0x6a, 0xa2, 0xec, 0x73, 0xae, 0x2a, 0x01, 0xe7, 0xea, 0x01, 0xac, 0xee, 0x62, 0xa7, 0xd5,
	0xef, 0x53, 0xbf, 0xc6, 0xdb, 0xc8, 0x79, 0xdd, 0x27, 0xe5, 0xfb, 0xb0, 0x96, 0x3c, 0x21, 0x3f,
	0x55, 0x4f, 0x21, 0x49, 0x3e, 0x85, 0x84, 0x5a, 0x42, 0xda, 0x0b, 0x54, 0xf7, 0x7d, 0x35, 0xed,
	0x68, 0x43, 0x6c, 0xe7, 0xaa, 0x41, 0xf9, 0x7b, 0x09, 0x56, 0x76, 0xb1, 0x43, 0xd7, 0xde, 0x1c,
	0x87, 0xd1, 0x94, 0xb0, 0xee, 0x17, 0x03, 0x15, 0x7a, 0x47, 0x90, 0x5d, 0xa4, 0x64, 0xaf, 0x65,
	0x91, 0x2d, 0x68, 0x7d, 0x0c, 0xb2, 0x47, 0x2a, 0x8f, 0x43, 0x6c, 0x67, 0xd1, 0xfa, 0x4e, 0x90,
	0x47, 0xb9, 0x17, 0xfb, 0x73, 0x0e, 0xd5, 0x34, 0x37, 0x66, 0x19, 0xaa, 0xc2, 0x91, 0x65, 0x28,
	0xad, 0x1c, 0x33, 0x27, 0x36, 0x03, 0xa0, 0x99, 0xa1, 0x13, 0x3a, 0x6b, 0x18, 0x96, 0x44, 0xdb,
	0x29, 0x0f, 0xe1, 0x12, 0x33, 0x18, 0x43, 0xb4, 0x09, 0xec, 0xf9, 0x48, 0x92, 0x52, 0x48, 0x2a,
	0x84, 0x48, 0x52, 0xee, 0xc3, 0x25, 0x66, 0x50, 0x24, 0xcc, 0x3b, 0xa1, 0x35, 0xd1, 0x81, 0xab,
	0x6c, 0x3a, 0xd7, 0x55, 0xff, 0xe2, 0x73, 0xfe, 0x85, 0x04, 0xaf, 0xf0, 0xf3, 0xf7, 0xdf, 0xd6,
	0x51, 0xd4, 0x1e, 0x40, 0xe3, 0x38, 0xd4, 0x89, 0x5b, 0x07, 0x99, 0x12, 0xe2, 0xa7, 0x32, 0x32,
	0x49, 0x92, 0x5d, 0x60, 0x50, 0x95, 0x10, 0xb7, 0x53, 0x3b, 0xe7, 0x43, 0x97, 0xab, 0x31, 0x0a,
	0xf1, 0x1a, 0xa3, 0x18, 0xd0, 0x18, 0x7f, 0x2b, 0x51, 0x95, 0x91, 0xb0, 0x20, 0x67, 0xc2, 0x31,
	0x2c, 0xb9, 0x31, 0x94, 0xae, 0x1a, 0x65, 0xc5, 0x9b, 0x69, 0xac, 0x88, 0x3d, 0xb5, 0x45, 0x2d,
	0x6e, 0xc1, 0x24, 0xa6, 0xfc, 0xb4, 0x00, 0x0b, 0x71, 0xd3, 0xc4, 0x9d, 0x7a, 0x9a, 0xac, 0xa4,
	0x99, 0x8b, 0x64, 0xac, 0xcf, 0x9a, 0x60, 0xb2, 0x52, 0x3f, 0x72, 0xcd, 0x88, 0x8b, 0x50, 0xf7,
	0xcc, 0x07, 0x6e, 0xf8, 0xf4, 0x85, 0xdd, 0xb0, 0x00, 0x65, 0x66, 0x2f, 0x30, 0x8b, 0x87, 0x15,
	0x48, 0x2d, 0x83, 0x1f, 0xf7, 0x4a, 0x68, 0x21, 0xe4, 0x4d, 0x46, 0x02, 0x71, 0xa9, 0xee, 0x22,
	0xa4, 0xba, 0x8b, 0xc4, 0xee, 0xa6, 0xb1, 0xe1, 0x30, 0xac, 0xcf, 0x67, 0x74, 0xfb, 0xc4, 0xbf,
	0x98, 0x22, 0xfe, 0xa5, 0xb0, 0xf8, 0xff, 0x48, 0x82, 0x4b, 0xf1, 0x54, 0xbc, 0x20, 0x99, 0x92,
	0xa1, 0x44, 0x4f, 0x49, 0x58, 0x11, 0x92, 0xcf, 0x8a, 0xf8, 0x77, 0x09, 0xe6, 0x99, 0x1d, 0xfe,
	0x89, 0xed, 0xbd, 0xc1, 0x05, 0x80, 0x52, 0x88, 0x02, 0xc5, 0xb7, 0xfd, 0x6a, 0x18, 0x64, 0x41,
	0x1c, 0x15, 0x53, 0x71, 0x54, 0x0a, 0xe1, 0xe8, 0x22, 0xd4, 0x35, 0x7c, 0xca, 0x6d, 0x4f, 0xae,
	0xae, 0x35, 0x7c, 0xca, 0xec, 0x4e, 0xde, 0xc8, 0x20, 0x55, 0x71, 0x1b, 0x99, 0x42, 0xfb, 0x3d,
	0x09, 0x16, 0x76, 0xb1, 0x73, 0x1f, 0x0f, 0x0e, 0xb1, 0x65, 0x9f, 0xe8, 0xc3, 0x9c, 0xda, 0x22,
	0x75, 0xa7, 0x6f, 0xc2, 0x82, 0xc5, 0xa6, 0xd1, 0x8d, 0xe3, 0xc8, 0x2b, 0x12, 0xf2, 0xda, 0x44,
	0x20, 0x5f, 0x79, 0x56, 0x00, 0xf0, 0x68, 0x98, 0x84, 0x8f, 0x10, 0xa6, 0x0c, 0x41, 0xc9, 0x32,
	0xfb, 0xc2, 0x29, 0xa0, 0xff, 0xbf, 0x18, 0xde, 0x86, 0x24, 0xb6, 0x1a, 0x96, 0xd8, 0x55, 0x98,
	0x1a, 0x98, 0x9a, 0x7e, 0xa4, 0xb3, 0x76, 0x26, 0xec, 0x20, 0xaa, 0x5a, 0x8e, 0x62, 0xc2, 0x0c,
	0x01, 0xd7, 0xc1, 0x89, 0xee, 0xe0, 0xbe, 0x1e, 0x86, 0x97, 0x14, 0x62, 0x4b, 0x8b, 0xef, 0x9b,
	0xb0, 0x6b, 0x76, 0xe3, 0x66, 0x9a, 0x44, 0xb8, 0x33, 0x52, 0xec, 0x9a, 0x7d, 0xcc, 0xd8, 0xa4,
	0xfc, 0x87, 0x44, 0xad, 0x1b, 0x52, 0xeb, 0x5d, 0x69, 0x6d, 0x2d, 0xe9, 0xae, 0x4c, 0x52, 0x00,
	0xae, 0xba, 0x28, 0xfa, 0xd5, 0xc5, 0x32, 0x54, 0x6d, 0xd3, 0x72, 0xba, 0x87, 0x63, 0xce, 0xe2,
	0x0a, 0x29, 0x6e, 0x8e, 0xd1, 0xfb, 0x50, 0x33, 0x2d, 0x0d, 0x5b, 0xa4, 0xa5, 0x4c, 0x89, 0x7f,
	0x35, 0x8d, 0xf8, 0x3d, 0xd3, 0x72, 0x1e, 0x90, 0xfe, 0x9d, 0x2a, 0x1d, 0xb6, 0x39, 0x76, 0x8f,
	0xbc, 0xe2, 0x1d, 0xb9, 0xf2, 0x53, 0x89, 0xe6, 0x2b, 0x44, 0xf7, 0x92, 0xe0, 0xa4, 0x7c, 0x1b,
	0xa6, 0x06, 0x2e, 0x00, 0x85, 0xa5, 0xf6, 0x5a, 0x1a, 0x21, 0x3e, 0x99, 0xf1, 0x0f, 0xa5, 0x4a,
	0x9d, 0x2a, 0x13, 0xbe, 0x7d, 0x5a, 0xf0, 0x31, 0xab, 0x14, 0xb8, 0x48, 0x7f, 0x22, 0xc1, 0xa2,
	0x4f, 0x91, 0x90, 0xc3, 0x88, 0x95, 0xc0, 0x62, 0x12, 0xce, 0x4b, 0x3e, 0x9c, 0x07, 0x00, 0x52,
	0xce, 0x29, 0x95, 0x95, 0x44, 0xa9, 0xbc, 0xc1, 0xde, 0x66, 0x5a, 0xfd, 0x3e, 0xa1, 0xcb, 0x53,
	0xc4, 0x0b, 0x50, 0x26, 0xcb, 0x31, 0xed, 0x5b, 0xef, 0xb0, 0x82, 0xb2, 0x0d, 0x4b, 0x7b, 0x58,
	0xb5, 0x7a, 0xb1, 0xce, 0xc8, 0xa7, 0x23, 0x6c, 0x8d, 0x39, 0xbb, 0x59, 0x21, 0xde, 0xe0, 0x50,
	0x6c, 0x58, 0x8e, 0xcc, 0xf2, 0xdc, 0xdf, 0x51, 0x3e, 0x82, 0x35, 0xff, 0xa2, 0x49, 0x91, 0xa7,
	0xdc, 0x9b, 0xf8, 0x6b, 0x09, 0xae, 0xa6, 0x4c, 0xf8, 0xa2, 0x83, 0x48, 0x3f, 0x92, 0x60, 0xe6,
	0xa1, 0xda, 0xd7, 0x09, 0xea, 0xbe, 0x4b, 0xb7, 0xb1, 0x0c, 0x55, 0xfa, 0xdc, 0xea, 0x8a, 0x44,
	0x85, 0x14, 0xdb, 0xf4, 0x55, 0x66, 0x88, 0xad, 0x81, 0x6e, 0xd3, 0xe7, 0x76, 0x06, 0x29, 0x5f,
	0x0d, 0x51, 0x62, 0x16, 0xb6, 0xcd, 0x91, 0xd5, 0xc3, 0x1e, 0x96, 0x40, 0x54, 0xb5, 0x35, 0xf6,
	0x56, 0xce, 0x3b, 0xd0, 0x88, 0x51, 0x55, 0xbc, 0x95, 0xb3, 0x4a, 0xfa, 0xd6, 0x7a, 0x0d, 0x1a,
	0x82, 0x1e, 0x3f, 0xc8, 0x4e, 0x49, 0x1d, 0x25, 0xa8, 0xd6, 0x61, 0x05, 0xe5, 0x0e, 0x14, 0x3f,
	0x3c, 0xd8, 0x67, 0x32, 0xf6, 0x18, 0x1b, 0xe2, 0x30, 0x68, 0x81, 0x48, 0x8c, 0xda, 0xa3, 0xd1,
	0x1e, 0x9f, 0x7f, 0xc1, 0x6b, 0xda, 0x9a, 0x72, 0x08, 0xf0, 0xe1, 0xc1, 0xbe, 0x38, 0xcf, 0x4b,
	0x50, 0x27, 0x66, 0x21, 0xe5, 0x94, 0xb8, 0xdf, 0xdc, 0x8a, 0x0c, 0x57, 0xc5, 0xcf, 0xaf, 0xa2,
	0x9f, 0x5f, 0xca, 0xbf, 0x4a, 0xb0, 0xdc, 0xd2, 0x34, 0x22, 0xcb, 0xfb, 0x66, 0x28, 0x82, 0xd2,
	0x82, 0x12, 0xe9, 0x45, 0x17, 0x9b, 0x4a, 0xd7, 0xd0, 0xcc, 0xbf, 0xf2, 0x99, 0x16, 0x1d, 0x3a,
	0x34, 0x8b, 0xac, 0x38, 0x9d, 0x90, 0x24, 0xf6, 0xe5, 0x44, 0xb1, 0xff, 0xb1, 0x04, 0xf3, 0x11,
	0x02, 0xd2, 0x2f, 0x9f, 0xe0, 0x05, 0x5b, 0x48, 0xbd, 0x60, 0x8b, 0x49, 0x46, 0x70, 0x29, 0xd6,
	0x08, 0x2e, 0xfb, 0x8c, 0x60, 0x65, 0x1b, 0x10, 0x0f, 0x3a, 0x51, 0x3f, 0x99, 0x93, 0xb6, 0x0e,
	0x17, 0xa8, 0xc5, 0xe9, 0x73, 0x31, 0x3c, 0x22, 0xe7, 0x43, 0xe6, 0x5e, 0x5b, 0x53, 0xbe, 0x03,
	0x17, 0x02, 0xb3, 0x70, 0xc4, 0x25, 0xfa, 0xad, 0x01, 0x6f, 0xb8, 0x10, 0xf2, 0x86, 0x7f, 0x00,
	0xcb, 0x0f, 0x8e, 0x8e, 0xe8, 0x6c, 0x1d, 0x8e, 0xe9, 0x9c, 0x36, 0x54, 0x48, 0x76, 0x0a, 0xd9,
	0xb2, 0x53, 0x8c, 0x91, 0x9d, 0xcf, 0x24, 0x58, 0xe6, 0xbb, 0x71, 0x7d, 0x1d, 0x41, 0xc0, 0x6d,
	0x68, 0xc6, 0x3a, 0x60, 0x1e, 0x39, 0x4b, 0x71, 0x0e, 0x15, 0x03, 0x38, 0x41, 0x8f, 0x47, 0x57,
	0x85, 0x14, 0x7d, 0x10, 0x2b, 0xfa, 0xee, 0x5a, 0x19, 0x9a, 0x51, 0x0a, 0x18, 0x53, 0x95, 0x6f,
	0x41, 0x4d, 0xb0, 0x85, 0xe6, 0x5c, 0x3c, 0x71, 0xb0, 0x65, 0xa8, 0x7d, 0x8f, 0x02, 0x10, 0x55,
	0x6c, 0x72, 0x5f, 0xf6, 0x0a, 0xfd, 0x5f, 0x79, 0x02, 0x8b, 0x0c, 0x8c, 0x13, 0x72, 0xf7, 0x7d,
	0xa8, 0x09, 0x3e, 0xf1, 0x08, 0xd1, 0x2b, 0x69, 0x12, 0xe7, 0xce, 0xee, 0x8e, 0x52, 0x9a, 0xb0,
	0x14, 0x5e, 0x99, 0x6f, 0xea, 0x8f, 0x78, 0xd6, 0x82, 0x68, 0xc8, 0xeb, 0x63, 0x47, 0x0e, 0xb4,
	0x10, 0x3d, 0xd0, 0x04, 0xf3, 0x29, 0xc9, 0x7e, 0xb0, 0x58, 0xd6, 0x81, 0x8f, 0x12, 0x8e, 0xe6,
	0x4d, 0xa8, 0x8b, 0x69, 0xc5, 0x9d, 0x92, 0x8f, 0x01, 0xde, 0xb0, 0xd0, 0xfd, 0x51, 0x12, 0xf7,
	0xc7, 0x29, 0x2c, 0x04, 0x4d, 0xc8, 0x3c, 0x2a, 0xe2, 0x4b, 0xb0, 0x4f, 0xef, 0xc2, 0x95, 0x0e,
	0x1e, 0x98, 0xa7, 0x54, 0x2f, 0x7d, 0x60, 0x99, 0x03, 0xb7, 0x63, 0x1e, 0x0a, 0x94, 0x3f, 0xe3,
	0xcf, 0x4b, 0x01, 0xa3, 0x7a, 0x73, 0xec, 0xb7, 0xb9, 0x04, 0x91, 0xd2, 0xb9, 0x89, 0x0c, 0x59,
	0xc5, 0xe5, 0x78, 0xab, 0xb8, 0x2c, 0x2c, 0x85, 0x27, 0xec, 0xad, 0x29, 0x96, 0x24, 0x7e, 0x90,
	0xdf, 0x82, 0x32, 0xd1, 0xfd, 0xb9, 0xf2, 0xb1, 0x02, 0xf3, 0x74, 0xd8, 0x38, 0xcf, 0x20, 0xe5,
	0x46, 0x00, 0x2d, 0x28, 0xef, 0xc1, 0x65, 0xdf, 0x2b, 0x97, 0x67, 0xcc, 0xda, 0xb9, 0x78, 0xf9,
	0x27, 0x05, 0x98, 0x8f, 0x0c, 0xf5, 0x07, 0x65, 0xa5, 0x73, 0x04, 0x65, 0x91, 0x0f, 0x22, 0xe2,
	0xfa, 0x7a, 0x05, 0x66, 0x6d, 0xdc, 0x3f, 0xea, 0xf6, 0x54, 0xa3, 0xdb, 0xc7, 0xea, 0x29, 0xe6,
	0x69, 0x3d, 0xd3, 0xa4, 0x76, 0x4b, 0x35, 0xee, 0x91, 0x3a, 0x74, 0x13, 0x2e, 0xb8, 0xbd, 0x54,
	0x4d, 0xeb, 0x32, 0x7b, 0x9c, 0x8a, 0x4a, 0xad, 0xd3, 0xe0, 0x5d, 0x5b, 0x9a, 0xc6, 0x68, 0x45,
	0xb7, 0x60, 0xc9, 0xed, 0x6e, 0x51, 0x44, 0x89, 0x11, 0x2c, 0x95, 0xe5, 0x02, 0x1f, 0xc1, 0xd0,
	0xc6, 0x07, 0x5d, 0x84, 0xfa, 0x23, 0x53, 0x37, 0x98, 0xb7, 0xc6, 0x7d, 0x3d, 0x56, 0xd1, 0x72,
	0x94, 0x4f, 0x03, 0x2f, 0x97, 0x01, 0x6e, 0xf2, 0x63, 0x7c, 0x10, 0x74, 0x30, 0xd8, 0x61, 0xde,
	0xcc, 0xc1, 0x9f, 0x04, 0x3f, 0x43, 0x79, 0x93, 0xe6, 0x48, 0x7f, 0x80, 0x55, 0x67, 0x64, 0xe1,
	0x5d, 0x95, 0x5c, 0xe1, 0x0f, 0xd5, 0xfe, 0xc8, 0xc5, 0x72, 0x03, 0x8a, 0x8f, 0xb1, 0x30, 0x57,
	0xc9, 0xbf, 0xca, 0xef, 0xc0, 0xe5, 0x84, 0x11, 0x9c, 0xc6, 0xc8, 0x10, 0xa4, 0xc0, 0xcc, 0x29,
	0xe9, 0xd2, 0xd5, 0x8d, 0xee, 0xa1, 0x69, 0x8a, 0x90, 0xe8, 0x14, 0xad, 0x6c, 0x1b, 0x9b, 0xa6,
	0xd9, 0x47, 0xd7, 0xa0, 0x41, 0x8b, 0x36, 0xe9, 0x64, 0x3b, 0x16, 0xcb, 0xbd, 0x22, 0x9e, 0xc1,
	0x2c, 0xab, 0x6f, 0x1b, 0x7b, 0xb4, 0x56, 0xf9, 0x35, 0x62, 0x67, 0x07, 0x09, 0x20, 0x33, 0xa4,
	0x93, 0x9d, 0x87, 0x06, 0xe5, 0x1f, 0x25, 0xf1, 0x2e, 0x3a, 0x01, 0x43, 0xd0, 0x6b, 0x30, 0xe7,
	0xce, 0xcc, 0x09, 0x67, 0xd8, 0x9b, 0xe1, 0x73, 0x33, 0xba, 0x51, 0xc7, 0xcd, 0x52, 0x2c, 0x52,
	0xc5, 0x70, 0x27, 0x55, 0x06, 0x13, 0xc8, 0x60, 0x89, 0x90, 0x22, 0xc3, 0x91, 0x18, 0xe1, 0x5c,
	0x9b, 0x45, 0xcf, 0xf9, 0x85, 0xc4, 0x60, 0x76, 0x61, 0xb9, 0x6d, 0x73, 0xb2, 0x79, 0x52, 0x96,
	0x20, 0xe4, 0x06, 0xa0, 0x23, 0xd6, 0xd0, 0x3d, 0xa6, 0x1b, 0xea, 0x7a, 0x8c, 0x6c, 0x1c, 0xf9,
	0x77, 0xfa, 0x1d, 0x3c, 0x56, 0x36, 0x60, 0x29, 0x3c, 0x0d, 0xc7, 0x57, 0x13, 0xaa, 0x98, 0xa7,
	0x81, 0x31, 0xab, 0x5e, 0x14, 0x95, 0x01, 0x2c, 0xb6, 0x6d, 0xca, 0xa6, 0x2f, 0xb2, 0x74, 0xde,
	0x03, 0x55, 0xfe, 0x4d, 0x82, 0x65, 0x37, 0x5f, 0x7a, 0x33, 0xf0, 0x63, 0x11, 0x62, 0x4d, 0x7a,
	0x89, 0xc6, 0xbd, 0xbe, 0x8e, 0x99, 0x3b, 0xc1, 0xad, 0x49, 0xb7, 0x69, 0x8b, 0xb6, 0xb4, 0x35,
	0xf4, 0x2e, 0xac, 0x84, 0x7f, 0x88, 0x12, 0x3e, 0x96, 0xa5, 0xe0, 0xef, 0x51, 0xf6, 0xfd, 0xa1,
	0x2c, 0x2f, 0x42, 0x54, 0x4c, 0xcf, 0x10, 0x2a, 0x85, 0x32, 0x84, 0x94, 0x9f, 0x53, 0x2f, 0xd3,
	0x49, 0xd8, 0x87, 0xcf, 0x38, 0xfe, 0x65, 0x6d, 0x67, 0x72, 0xcc, 0x7d, 0x2e, 0x81, 0x92, 0xb6,
	0x05, 0x8e, 0x1b, 0x13, 0x56, 0xbc, 0x3d, 0x84, 0xa8, 0xe3, 0x37, 0xcd, 0xad, 0x5c, 0x19, 0xf4,
	0xa1, 0xf9, 0x97, 0x71, 0x7c, 0x83, 0xf2, 0xfb, 0x12, 0x5c, 0xdd, 0xfd, 0xd2, 0x59, 0x9b, 0xc4,
	0x9f, 0x42, 0x22, 0x7f, 0xfe, 0x5b, 0x02, 0x65, 0xf7, 0x7f, 0x1f, 0x7f, 0xd0, 0x87, 0xa0, 0xe8,
	0x76, 0x78, 0xa5, 0xae, 0x70, 0xbe, 0x35, 0xfa, 0xec, 0xa6, 0x71, 0x3d, 0x7d, 0x45, 0xb7, 0x83,
	0xa3, 0x5b, 0xac, 0x1b, 0x7b, 0x9c, 0xd3, 0x94, 0x9f, 0x48, 0xb0, 0x2a, 0x7e, 0x27, 0xc6, 0x55,
	0xe1, 0x83, 0x33, 0x63, 0x22, 0x4d, 0xf8, 0x1a, 0xcc, 0xd1, 0x5f, 0x5c, 0xd9, 0x5d, 0x03, 0x9f,
	0x75, 0x7d, 0x36, 0xc4, 0x0c, 0xab, 0xfe, 0x08, 0x9f, 0x11, 0x93, 0x0a, 0xbd, 0x01, 0x0b, 0x2e,
	0xd7, 0xbb, 0x8e, 0xd9, 0x1d, 0x5a, 0xe6, 0xc0, 0x74, 0x73, 0x5d, 0xe6, 0x85, 0xf2, 0xdc, 0x37,
	0x3f, 0x66, 0x0d, 0xd7, 0xef, 0xc2, 0x7c, 0xc4, 0xce, 0x43, 0x00, 0x95, 0x87, 0xed, 0x9d, 0x83,
	0x9d, 0x4e, 0xe3, 0x25, 0x34, 0x0f, 0x33, 0x7b, 0x3b, 0x5b, 0x9f, 0x74, 0x76, 0xba, 0xbc, 0x4a,
	0x42, 0x75, 0x28, 0xb7, 0xb6, 0xef, 0xb7, 0x3f, 0x6a, 0x14, 0xae, 0x5f, 0x81, 0xba, 0x1b, 0xae,
	0x44, 0x55, 0x28, 0xb6, 0xf6, 0xb6, 0x1a, 0x2f, 0xa1, 0x1a, 0x94, 0xb6, 0x77, 0xf6, 0xb6, 0x1a,
	0xd2, 0xf5, 0xaf, 0xc1, 0x95, 0xf4, 0xdb, 0x82, 0x0e, 0xda, 0xde, 0x6e, 0xbc, 0x44, 0x16, 0xed,
	0xec, 0xdc, 0x7f, 0xf0, 0x70, 0xa7, 0x21, 0x6d, 0xfc, 0xcd, 0xeb, 0x50, 0xea, 0x6c, 0xb6, 0xb6,
	0x90, 0x03, 0x33, 0x81, 0x94, 0x63, 0x94, 0xfa, 0xa2, 0x16, 0x97, 0x67, 0x2d, 0xbf, 0x35, 0xc1,
	0x08, 0x8e, 0xb6, 0x3f, 0x95, 0x60, 0x29, 0xde, 0xd8, 0x41, 0xef, 0xe6, 0x9b, 0x2d, 0xc6, 0xdc,
	0x94, 0xef, 0x9c, 0x67, 0x28, 0xa7, 0xe8, 0x29, 0xcc, 0x85, 0x82, 0x86, 0x68, 0x23, 0x35, 0x86,
	0x1c, 0x1b, 0xa7, 0x94, 0x6f, 0x4d, 0x34, 0x86, 0xaf, 0xfd, 0x5d, 0x80, 0x5d, 0x2c, 0x88, 0x43,
	0x57, 0xd2, 0xa6, 0x68, 0x6b, 0x72, 0x1e, 0x83, 0x18, 0x1d, 0xc1, 0x4c, 0x20, 0xc7, 0x2b, 0xfd,
	0x58, 0xe3, 0x12, 0xc0, 0xf3, 0xad, 0xf3, 0x87, 0x12, 0x34, 0x93, 0x52, 0x3f, 0xd1, 0x37, 0xb2,
	0xe3, 0x53, 0x89, 0x29, 0x68, 0xf2, 0x84, 0xd1, 0x4b, 0xa4, 0xc3, 0x4c, 0xe0, 0x15, 0x2a, 0x7d,
	0xc7, 0x71, 0x0f, 0x56, 0x72, 0xce, 0x58, 0x3d, 0xfa, 0x03, 0x09, 0x2e, 0xc4, 0x3c, 0x0c, 0xa0,
	0x77, 0x32, 0x56, 0x4c, 0x78, 0x15, 0x91, 0xbf, 0x3e, 0xf1, 0x38, 0x0e, 0x9c, 0x47, 0xd0, 0x08,
	0x47, 0x0a, 0x51, 0x2a, 0x02, 0x13, 0xe2, 0x8a, 0xf2, 0xd5, 0x54, 0xd5, 0x3e, 0x18, 0x3a, 0x63,
	0xf4, 0x04, 0x96, 0x13, 0x6c, 0x4d, 0x74, 0x27, 0x3d, 0x28, 0x90, 0x66, 0xa0, 0xe6, 0x59, 0xf9,
	0x37, 0x01, 0xbc, 0xe7, 0x0d, 0x74, 0x33, 0x1b, 0xc8, 0xbe, 0x80, 0x42, 0x9e, 0xf9, 0x1f, 0xc3,
	0x6c, 0xf0, 0xf9, 0x04, 0xbd, 0x95, 0x73, 0x0d, 0xcf, 0xed, 0xcf, 0x8d, 0x9d, 0x1e, 0x4c, 0xfb,
	0x1f, 0x44, 0x50, 0x36, 0x7d, 0x72, 0xa6, 0x46, 0x8e, 0xbc, 0xae, 0x0c, 0x00, 0x89, 0x60, 0xb8,
	0x97, 0x62, 0x84, 0x52, 0xdd, 0xfe, 0x40, 0x30, 0x5f, 0xbe, 0x91, 0xa7, 0xab, 0xbb, 0xdc, 0x19,
	0xcc, 0x06, 0xa3, 0x5c, 0xe9, 0x0c, 0x8c, 0x8d, 0xc5, 0xc9, 0x1b, 0x93, 0x0c, 0xe1, 0x0b, 0xf3,
	0xcb, 0xcb, 0x8d, 0x5c, 0x65, 0x5f, 0x5e, 0xe1, 0x70, 0x5b, 0xf6, 0xe5, 0x15, 0x0d, 0x8b, 0xfd,
	0x95, 0x04, 0x72, 0xb2, 0xc5, 0x89, 0xee, 0xa6, 0x5f, 0x01, 0x19, 0x16, 0xa1, 0xfc, 0xcd, 0xf3,
	0x0e, 0xf7, 0x51, 0xb7, 0x7b, 0x4e, 0xea, 0x76, 0xbf, 0x18, 0x75, 0x39, 0xcc, 0xcc, 0x11, 0xc8,
	0x91, 0x1f, 0xf4, 0x7b, 0xba, 0xeb, 0xed, 0xb4, 0xd9, 0x93, 0x3e, 0x04, 0x90, 0x47, 0xc4, 0x6d,
	0x90, 0x43, 0xbf, 0xdd, 0xff, 0xc0, 0x32, 0x07, 0x62, 0xd9, 0x8d, 0xf4, 0x24, 0xa2, 0xb8, 0xdf,
	0xfc, 0xe7, 0x59, 0xf4, 0x99, 0x04, 0xcb, 0x09, 0x59, 0xe0, 0x28, 0xaf, 0xa9, 0x12, 0xf3, 0x8c,
	0x28, 0x7f, 0xe3, 0x5c, 0x63, 0xf9, 0x01, 0xfc, 0x58, 0x82, 0x95, 0xc4, 0x77, 0x45, 0xf4, 0x5e,
	0x5e, 0xf3, 0x25, 0x96, 0xb0, 0xbb, 0xe7, 0x1c, 0xed, 0xe6, 0x7a, 0x2d, 0x7a, 0x66, 0x90, 0xff,
	0x6a, 0xcf, 0xb2, 0x88, 0x26, 0x35, 0x15, 0x88, 0xd1, 0x92, 0x94, 0x01, 0x9f, 0x6e, 0xb4, 0x64,
	0xe4, 0xcd, 0x4f, 0x4c, 0xc9, 0x53, 0x68, 0x26, 0xfd, 0x00, 0x22, 0x9d, 0x90, 0x8c, 0x9f, 0x4d,
	0xe4, 0x81, 0xe7, 0x19, 0xcc, 0x06, 0xb3, 0xaf, 0xd3, 0xb5, 0x76, 0x6c, 0x4a, 0x77, 0xba, 0xd6,
	0x4e, 0x48, 0xee, 0xfe, 0x21, 0x7f, 0xfa, 0x08, 0x67, 0x69, 0xa1, 0xaf, 0x67, 0x01, 0x3b, 0x21,
	0xbb, 0x4c, 0xbe, 0x3d, 0xf9, 0x40, 0x4e, 0xcb, 0x67, 0x12, 0x0d, 0x81, 0x26, 0x66, 0x63, 0x66,
	0x62, 0xef, 0xfd, 0x0c, 0x85, 0x98, 0x9d, 0xe7, 0xf9, 0x03, 0xf1, 0x3a, 0x15, 0xce, 0xd3, 0xbd,
	0x9d, 0x7d, 0x23, 0xc6, 0xa7, 0xb9, 0xca, 0x93, 0x24, 0xb3, 0x21, 0x07, 0x16, 0x63, 0x73, 0x66,
	0xd3, 0xd7, 0x4f, 0x4b, 0xb3, 0xcd, 0x83, 0x3e, 0x03, 0xa6, 0x7c, 0x0f, 0xa8, 0x68, 0x3d, 0x07,
	0x8e, 0x7c, 0xef, 0xb5, 0xf2, 0x1b, 0xb9, 0xfb, 0x73, 0x2e, 0x7f, 0x2e, 0x41, 0x33, 0x29, 0xdb,
	0x34, 0x5d, 0xd4, 0x32, 0x92, 0x62, 0xe5, 0xf7, 0xce, 0x37, 0xd8, 0x3d, 0x7d, 0x39, 0x39, 0xc5,
	0x38, 0xfd, 0xb6, 0xce, 0x4c, 0x4d, 0xce, 0x73, 0x0e, 0xbf, 0x0d, 0x8d, 0xf0, 0xc3, 0x6b, 0xba,
	0x0b, 0x91, 0xf0, 0x50, 0x2c, 0xbf, 0x3d, 0xd9, 0x20, 0xd7, 0x83, 0x99, 0x8f, 0xe4, 0xed, 0x67,
	0xca, 0xdc, 0xd7, 0x72, 0xc8, 0x5c, 0x8c, 0xa0, 0xf5, 0x01, 0x45, 0x13, 0xef, 0x33, 0x17, 0x7b,
	0x27, 0xdf, 0x62, 0x91, 0x44, 0xfe, 0xdf, 0xa0, 0x59, 0x91, 0x9c, 0x86, 0x09, 0xd6, 0xcb, 0xe5,
	0x76, 0xef, 0x43, 0x9d, 0x29, 0x80, 0x0f, 0x0f, 0xf6, 0x51, 0xaa, 0xeb, 0xe1, 0xa5, 0xab, 0xc8,
	0xab, 0x19, 0xfd, 0x84, 0x8c, 0xc4, 0xfe, 0x88, 0x23, 0x53, 0x46, 0xd2, 0x7e, 0x4b, 0x92, 0x29,
	0x23, 0xe9, 0xbf, 0x1b, 0xf9, 0x2d, 0x68, 0x84, 0x9f, 0x15, 0xd2, 0x31, 0x9a, 0xf0, 0x08, 0x91,
	0x7e, 0x5b, 0x25, 0x3c, 0x38, 0x9c, 0xc1, 0x6c, 0xf0, 0x59, 0x21, 0xfd, 0x9a, 0x8c, 0x7d, 0x82,
	0x38, 0xcf, 0xc2, 0x1b, 0x9f, 0x4d, 0x41, 0xbd, 0xb3, 0xd9, 0xda, 0x6a, 0x69, 0x03, 0xdd, 0x40,
	0x1a, 0xcc, 0x04, 0xee, 0x7c, 0xf4, 0x66, 0x6e, 0xf3, 0x60, 0x02, 0x6d, 0xf0, 0x08, 0x1a, 0xe1,
	0x4c, 0x94, 0x0c, 0x6d, 0x10, 0x9f, 0xb7, 0x92, 0x67, 0xad, 0xa7, 0xde, 0xb7, 0xbd, 0xc2, 0x31,
	0xdb, 0x74, 0xb0, 0x65, 0x44, 0x7a, 0xf3, 0xac, 0xad, 0xc1, 0x4c, 0x20, 0x28, 0x9b, 0xce, 0xcd,
	0xb8, 0x4c, 0x85, 0x89, 0x42, 0x26, 0x91, 0x64, 0x83, 0x3c, 0x21, 0x93, 0xa4, 0x0c, 0x85, 0x3c,
	0x2b, 0x0f, 0x61, 0x25, 0x18, 0xa6, 0x68, 0x1b, 0xde, 0xda, 0xcf, 0x65, 0xaf, 0xc2, 0xd9, 0x89,
	0x49, 0x43, 0xc8, 0x76, 0x76, 0x92, 0xd3, 0x29, 0xb2, 0x9d, 0x9d, 0xb4, 0xbc, 0x87, 0x67, 0x2c,
	0x83, 0x37, 0x1a, 0x1a, 0xe7, 0xcf, 0xce, 0xb7, 0x33, 0xd4, 0x52, 0xe2, 0x43, 0xb0, 0xfc, 0xee,
	0x39, 0x46, 0x72, 0xa2, 0xbe, 0x4f, 0x1c, 0xb0, 0x84, 0x17, 0xec, 0x2c, 0x07, 0x2c, 0xfd, 0xe1,
	0x3b, 0xcf, 0x39, 0x7d, 0x2e, 0xc1, 0x95, 0x04, 0x96, 0xb0, 0x87, 0x4d, 0xfb, 0xc5, 0x70, 0xe5,
	0x99, 0xeb, 0x93, 0x45, 0x3b, 0xe5, 0xf1, 0xc9, 0x9e, 0x07, 0x51, 0x1b, 0x7f, 0x27, 0xc1, 0x3c,
	0x55, 0xc1, 0x81, 0x0f, 0x10, 0x3d, 0x93, 0x60, 0x25, 0xf1, 0x4b, 0x4b, 0xe9, 0x27, 0x98, 0xf5,
	0x81, 0x26, 0x39, 0xd3, 0x05, 0x4a, 0xf8, 0xf8, 0xd2, 0xc6, 0x7f, 0x96, 0xa0, 0x11, 0xfa, 0x7c,
	0x97, 0x4d, 0xd4, 0x79, 0xf8, 0xd3, 0x81, 0x28, 0xe3, 0x85, 0x22, 0xf6, 0x43, 0x83, 0x79, 0x80,
	0xf5, 0x43, 0xf6, 0x33, 0x90, 0xc8, 0x07, 0xf7, 0x50, 0x56, 0x74, 0x3b, 0xe9, 0x7b, 0x80, 0xf2,
	0xed, 0xc9, 0x07, 0x72, 0x30, 0x61, 0x98, 0xf6, 0xc7, 0xa2, 0x50, 0xbe, 0x6f, 0xa3, 0xb9, 0x5f,
	0x93, 0x93, 0x5f, 0xcd, 0xd5, 0xdf, 0xcf, 0xde, 0xd6, 0x70, 0x68, 0x99, 0xa7, 0x59, 0x76, 0x49,
	0xc2, 0x87, 0xf7, 0xf2, 0xb0, 0xd7, 0x84, 0x45, 0x31, 0x9a, 0x7f, 0x2d, 0x88, 0x3f, 0xef, 0x3d,
	0xa7, 0x05, 0x37, 0xeb, 0xbf, 0x5e, 0xe5, 0xdf, 0xf1, 0x3c, 0xac, 0xd0, 0x0f, 0x79, 0xde, 0xfa,
	0x9f, 0x00, 0x00, 0x00, 0xff, 0xff, 0xb1, 0x54, 0xae, 0x53, 0xe5, 0x53, 0x00, 0x00,
}
