# DEPRECATED AND REMOVED

Piper and Piper-Service have been replaced by CommunityInsights: https://code.amazon.com/packages/TwitchCommunityInsights/trees/mainline

The README file is left intact below for reference, but links and referenced tools will be broken.

# Piper

Infrastructure to run [Airflow](https://airflow.apache.org/index.html) workflows to generate reports for developers using Twitch.

Airflow is organized with DAGs (Directed Acyclic Graphs). Each DAG is a list of tasks and its dependencies, schedulled to run like a cron job. For example, the games_overview DAG runs daily, starting with some tasks to check if previous runs are properly done, then a task to agregate data for that day from Redshift and save it to Aurora, then a task to start writing reports to S3.

Airflow admin on WPA2 (and Amazon VPN):

- staging: https://staging.piper-airflow.twitch.a2z.com/admin/
- production: https://prod.piper-airflow.twitch.a2z.com/admin/

Airflow admin on Twitch-VPN (Viscosity VPN):

- staging: https://twitchvpn.staging.piper-airflow.twitch.a2z.com/admin/
- production: https://twitchvpn.prod.piper-airflow.twitch.a2z.com/admin/

## Flower: celery workers monitoring tool

[Flower](https://flower.readthedocs.io/en/latest/) is a web interface to monitor Celery workers and jobs. Airflow can run with different task queue systems. We use the [CeleryExecutor](https://airflow.apache.org/howto/executor/use-celery.html). Flower is not part of Airflow, but sometimes is useful to debug issues in Celery.

Flower interface (WPA2 and Amazon VPN only):

- staging: https://flower.staging.piper-airflow.twitch.a2z.com/
- production: https://flower.prod.piper-airflow.twitch.a2z.com/

## OnCall Runbook

[Runbook](./docs/runbook.md)

## Develpment

### Python

Currently in production, piper runs with `python 3.5.2` and `pip 19.3.1`. Don't do `brew install python` because that will install the latest version only.

Install with pyenv:

- Python version 3.5.2 has issues with openssl in macOS, but to work localy you should be fine with version `3.6.11` instead.
- Install dependencies for python installer: `brew install openssl readline sqlite3 xz zlib`
- Install [pyenv](https://github.com/pyenv/pyenv): `brew install pyenv`
- `pyenv init` and add the suggested shim in to your `.bashrc` or `.zshrc` file.
- `pyenv install 3.6.11` to install Python in your machine.
- `python --version` to make sure it is the right version (restart terminal if not loaded yet).

Install requirements.txt:

- Install dependency for the `pymssql` package: `brew install freetds`
- `pip install -r codedeploy/requirements.txt` to install all dependencies.

Check if you can run the linter: `make lint`, and run python code: `make check`.


### AWS accounts

We use `twitch-service-piper-dev` for staging and `twitch-service-piper-aws` for production. In addition, you may need access to `twitch-web-dev` and `twitch-web-aws` to get credentials in sandstorm. We use [isengard](isengard.amazon.com) to manage AWS accounts and ARN roles.

### Sandstorm

[Sandstorm](https://wiki.twitch.com/display/SSE/Sandstorm%3A+Secret+Management+System) is used to manage secrets (passwords, access tokens, etc).

See wiki for setup instructions: https://wiki.twitch.com/x/nqBFD. On Mac OS, you should be able to install with homebrew:

```sh
brew tap twitch/internal git@git-aws.internal.justin.tv:common/homebrew-custom.git
brew install sandstorm
```

Usage example: get the password on the `piper-daily-incremental` database:

```sh
sandstorm get insights/piper-daily-incremental/staging/piper --role-arn "arn:aws:iam::734326455073:role/sandstorm/production/templated/role/piper-airflow-staging" --profile twitch-service-piper-dev
```

Sandstorm access is configured in the sandstorm tool: https://dashboard.xarth.tv/sandstorm/manage-roles. To have access, your IAM asumed-role ARN needs to be added to the `piper-airflow-staging` role in order to have access to the staging secrets.

Use your Isengard user for access: on Isengar AWS Console access, find the piper account (e.g. `twitch-service-piper-dev`) and click on the tiny icon next to the "Admin" access link. From the JSON data displayed, copy the `assumedRoleUser.arn`. Add that ARN to the sandstorm role. Then, to allow the `sandstorm` command to access your AWS account, make sure to add the credentials (key, secret, session token) into the `~/.aws/credentials` file, either using `mwinit` and `ada credentials`, or manually copy-pasting into the section `[twitch-service-piper-dev]`.

### Running locally

Piper doensn't have tests. Airflow DAGs depend on external dependencies. SQL queries can not be tested in isolation because they depend on production data and schemas (mostly Tahoe) that are outside of our control. Workers can not be easily tested because they also depend on the DAG's configuration. We also don't have fake data that could be used to verify the results of our reports.

The good news is that, since Airflow is based on worker jobs, if a new job fails we get an alert that can be resolved by rolling back the change that provoked the failure. This causes no user impact, except maybe a delay in the time that the new daily reports are available.

Being able to run some of your code locally is still very useful.

- `make lint`: run linters (this is also done in the CI server after every build).
- `make check`: loads the python code and runs a few little tests, useful to see if the code is able to load/start.
- `./test_task.sh <dag> <task> <date>`: script to run a signle task against the staging environment. Example: `./test_task.sh extensions_overview_v2 validate_fields 2018-09-28`. This is very useful when writing a new task. If you are using `virtualenvwrapper`, make sure to run `workon piper`.
- `./test_dag.sh <dag_file_path>`: script to build the DAG. Example: `./test_dag.sh dags/extensions_overview_v2.py`. It doesn't actually run the DAG, but it is useful to make sure that nothing is horribly wrong with it.
- UPDATE: running test_tasks.sh and test_dag.sh is broken because the sandstorm connection was not updated

In practice, the only way to really test your code is by deploying to staging (see Deploy section below), and runing the new/modified DAG in the staging environment. Staging queries are run against the production data lake (Tahoe).

## Infra

 * Piper runs in AWS together with piper-service infra, do not confuse with that when browsing in the AWS console.
 * A Ec2 instance for piper-master, that runs airflow web UI, airflow scheduler, and the flower web UI. This instance is managed by an ASG (Auto Scaling Group). To re-build this instances, terminate the previous one and let the ASG bring the new instance up.
 * Some Ec2 instances for piper-worker, that run airflow workers. Those are the ones that execure DAGs. Managed by its own ASG. To add more workers, increase the ASG target number. To replace worker instances, terminate existing ones and let the ASG bring back to the desired number.
 * Ec2 instances are based of a custom base AMI. See [New AMI docs](./docs/new-ami.md) for more info.
 * CodeDeploy is used to install python, airflow and all other dependencies. The ASG has a "Lyfecycle hook" to call into CodeDeploy when a new instance starts.
 * CodeDeploy runs pip install, which may fail if not run after a while. If an instance fails to start, check CodeDeploy Deployments and their event logs.
 * The Puppet agent is installed in the instances for legacy reasons (I'm not sure what it does exactly).
 * Different Load Balancers are used for access from WPA2 and TwitchVPN, and for the Flower UI, all with different certificates and DNS domains.
 * RDS DB instances are used for the airflow metadata db and the daily rollups (called `games-daily-incremental`, although it is used for all types of reports, not just games).


### Terraform

Requirements:

- Terraform `0.11.14`: Use `chtf` to install and use the right version: https://github.com/Yleisradio/homebrew-terraforms (note: `brew install terraform` works but installs the latest version).
- You need accesss to the AWS accounts for `twitch-service-piper-aws` (production) and `twitch-service-piper-dev` (staging). You should be using isengard, mwinit and ada. If not, you could edit your `~/.aws/credentials` file with access key id and secret from your IAM user on each account (not recommended).
- We use tfvars files with private keys (master_password and pagerduty_key) that are gitignored; you need to get them privately from someone in the team (e.g. private Slack message and then delete): `terraform/twitch-service-piper-aws/terraform.tfvars.json` (production) and `terraform/twitch-service-piper-dev/terraform.tfvars.json` (staging).

Run terraform commands from the terraform folder: [cd terraform/twitch-service-piper-aws](https://git-aws.internal.justin.tv/insights/piper/tree/master/terraform/twitch-service-piper-aws) (production) or [cd terraform/twitch-service-piper-dev](https://git-aws.internal.justin.tv/insights/piper/tree/master/terraform/twitch-service-piper-dev) (staging). For example, to work on staging:

```bash
cd terraform/twitch-service-piper-dev
# login with mwinit/adacreds/whatever ...
export AWS_PROFILE=twitch-service-piper-dev
```

Initiate terraform state (needs access to github to download other modules, you may need `teleport-bastion login`).

```bash
sh bootstrap.sh
```

Check if the plan needs to do any changes (NOTE: `terraform.tfvars.json` is not checked in, ask a team member for it).

```bash
terraform plan --out="plan.txt" -var-file=terraform.tfvars.json
```

Make sure the changes look good. Then to apply:

```bash
terraform apply "plan.txt"
```

### Databases and Connections

We use Redshift as data warehouse (`piper-games`), accessing Tahoe when possible. The aggregates are saved in Aurora (`games-daily-incremental-reader`, `games-daily-incremental-writer`). Airflow itself also has a DB to store config and the state of workflows.

We are storing all connections in JSON format as a Sandstorm secret, so passwords and other sensitive data is properly encrypted.

An example:

```
[{
  "conn_id": "test-extensions-connection",
  "conn_type": "postgres",
  "conn_host": "10.202.51.89",
  "conn_schema": "extensions",
  "conn_login": "piper",
  "conn_password": "12345",
  "conn_port": "5439"
},
(...)]
```

To see all the connections, use the `sandstorm` command:

```sh
# staging
sandstorm get insights/piper-airflow/staging/connections \
  --role-arn "arn:aws:iam::734326455073:role/sandstorm/production/templated/role/piper-airflow-staging" \
  --profile twitch-service-piper-dev

# production
sandstorm get insights/piper-airflow/production/connections \
  --role-arn "arn:aws:iam::734326455073:role/sandstorm/production/templated/role/piper-airflow-production" \
  --profile twitch-service-piper-aws
```

Note: Sandstorm secrets are managed in the sandstorm tool: https://dashboard.xarth.tv/sandstorm/manage-secrets.

Then you can use the connection info to connect to the given database. For example, to query the daily aggregates on `games-daily-incremental-reader`:

```
# make sure you are on the Twitch VPN
psql -h 'piper-daily-incremental-1.cluster-ro-cxgpuxtkiepo.us-west-2.rds.amazonaws.com' -p 5432 -U incremental_02 -d daily_incremental
```

Tips:

- Whenever you want to add a new connection, you will need to update the connection file stored in sandstorm with your new configuration, adding from the airflow UI will work, but will not make easy retrievable and secure for other people.
- Whenever you update the connection in sandstorm, you will need to redeploy to get that loaded into db and encrypted.


## Deploy

https://deploy.xarth.tv/#/insights/piper

There are a few gotchas when deploying changes in Airflow DAGs or Task operators: https://gtoonstra.github.io/etl-with-airflow/gotchas.html. This is because Airflow DAG definitions are taken from the Python files, but the state of their runs is saved in the airflow DB. In particular, don't change the start_date & interval properties of the DAG in code (instead, make a new version of the DAG).

### Deployment failures

If a deployment fails or a new instance fails to spin up and you are unsure why [test-instance](./terraform/test-instance/README.md) can be used to debug deployments.
