#!/bin/bash -e

BASEDIR=$(dirname "$0")
LOG_PATH="$BASEDIR/airflow_service.log"

dt=$(date '+%Y-%m-%d %H:%M:%S')

source "/var/lib/codedeploy_utils/load_fact_env.sh"

if [ "$CLUSTER" == "airflow-master" ] ; then
	if ! systemctl -q is-active airflow@webserver; then
		echo "$dt airflow@webserver is inactive! restarting service" >> $LOG_PATH
	  systemctl start airflow@webserver
	fi

	if ! systemctl -q is-active airflow@scheduler; then
	  echo "$dt airflow@scheduler is inactive! restarting service" >> $LOG_PATH
	  systemctl start airflow@scheduler
	fi

	if ! systemctl -q is-active airflow@flower; then
	  echo "$dt airflow@flower is inactive! restarting service" >> $LOG_PATH
	  systemctl start airflow@flower
	fi
fi
