import subprocess
from twitch import sandstorm
import yaml
import sys


def get_connections():
    env = sys.argv[1].replace("twitch_environment=", "")
    role = "arn:aws:iam::734326455073:role/sandstorm/production/templated/role/piper-airflow-{0}".format(env)
    sandstorm_client = sandstorm.SandstormClient(role)
    secret = "insights/piper-airflow/{0}/connections".format(env)
    connections = sandstorm_client.get_secret(secret).plaintext
    connections = connections.replace("\n", "")
    connections = connections.replace(" ", "")
    connections = connections.replace("\t", "")
    yaml_connection = yaml.load(connections)
    return yaml_connection


def clean_extra_params(params):
    # Converts '{'key_1': 'value_1'}' into '{"key_1": "value_1"}'

    # Replace all single quotes with double quotes
    params_as_list = list(params.replace("'", '"'))

    # Replace outer quotes with single quotes
    params_as_list[0] = "'"
    params_as_list[-1] = "'"

    # Convert back to string before returning
    return "".join(params_as_list)


def add_airflow_connection(args):
    airflow_connection_cmd_prefix = 'airflow connections -{} '

    # Delete the connection if it exists already
    delete_cmd = airflow_connection_cmd_prefix.format('d')
    delete_cmd += '--conn_id {}'.format(args.get('conn_id'))
    subprocess.call(delete_cmd, shell=True)

    # Construct the command and add the connection
    add_cmd = airflow_connection_cmd_prefix.format('a')
    for arg, value in args.items():
        arg_name = '--' + arg + ' '
        if arg == 'conn_extra':
            add_cmd += arg_name + clean_extra_params(value) + ' '
        else:
            add_cmd += arg_name + value + ' '
    subprocess.call(add_cmd, shell=True)


def main():
    for c in get_connections():
        add_airflow_connection(c)


if __name__ == '__main__':
    main()
