# Tricks and need-to-knows

## Admin password for piper daily incremental DB
You would rarely need the admin password (-U piper) for our daily incremental DB. The very few occasions you will need it are like modifying schemas. It is stored in `insights/piper-daily-incremental/staging/piper-user-key` and `insights/piper-daily-incremental/production/piper-user-key` for the two piper environments. 

You could get admin password from sandstorm by calling (if your profile for piper staging/prod is named differently, please substitute that with the right one):

```
sandstorm get insights/piper-daily-incremental/production/piper-user-key --role-arn arn:aws:iam::734326455073:role/sandstorm/production/templated/role/piper-airflow-production --profile twitch-service-piper-aws

sandstorm get insights/piper-daily-incremental/staging/piper-user-key --role-arn arn:aws:iam::734326455073:role/sandstorm/production/templated/role/piper-airflow-staging --profile twitch-service-piper-dev
```

Then you could retrieve daily incremental DB from connections below and be sure to stay on Twitch internal network for DB connection.

## Get piper connection info

The connections are stored in airflow database. They contain information like DB DNS and password. Be sure to stay on Twitch internal network for DB connection.

```
sandstorm get insights/piper-airflow/production/connections --role-arn arn:aws:iam::734326455073:role/sandstorm/production/templated/role/piper-airflow-production --profile twitch-service-piper-aws

sandstorm get insights/piper-airflow/staging/connections --role-arn arn:aws:iam::734326455073:role/sandstorm/production/templated/role/piper-airflow-staging --profile twitch-service-piper-dev

```

Most used connections are:

- `games-daily-incremental-reader`: This DB stores final result. Could be used to check insights result for daily report.
- `piper-games`: Could be used to interact with Tahoe and check raw data.
- `airflow_db`: This is airflow metadata DB, we could use it to check running tasks and clean up hanging tasks.

## Clean up hanging tasks

### Cancel running tasks to prevent follow up runs
Usually we do this in UI, but sometimes UI will stuck, so we could approach it from our airflow DB, specify the DAG id and set state to be running.

Select to make sure the results are correct.
```
select * from task_instance where dag_id='<your_dag_id>' and state='running';
```

Delete task instances.
```
delete from task_instance where dag_id='<your_dag_id>' and state='running';
```

### Cancel the whole DAG run

Similar to clean up running tasks, when UI stuck and you could not stop the DAG run, clean it up in the DB to prevent further steps.

Select to make sure results are correct.
```
SELECT * FROM dag_run WHERE dag_id = '<your_dag_id>' and state='running' ;
```

Clean up running DAGs.
```
DELETE FROM dag_run WHERE dag_id = '<your_dag_id>' and state='running' ;
```

If UI is not showing properly after DB clean up, needs to clean UI by operating on dag_stats:

```
UPDATE dag_stats SET count=0 WHERE state='running' and dag_id='<your_dag_id>';
```

### Select by datetime

The format for date time is YYYY-MM-DD in DB.

So for example, if you want to check runs after specific date, you could query like:

```
select * from task_instance where dag_id='games_overview_v2' and execution_date>='2019-07-30';
```

### Log location on box
If you would love to check codedeploy or daemon logs (or any logs you would need to), the location for logs on box is:

Note that, you would be needed for Twitch internal network.

For airflow application:
```
/var/log/piper-airflow/
```

Code deploy logs:

```
/var/log/aws/codedeploy-agent
```

Other logs are all under:

```
/var/log
```

### Virtual Python env for airflow on box
If you would need to test the virtual ENV set up on staging box (recommend not do it to prod box), to active our piper python env, please do:

Note that, you would be needed for Twitch internal network. 

```
source /opt/virtualenvs/airflow/bin/activate
```

Finish using, please deactivate:

```
deactivate
```

### DAGs location in box

```
cd /etc/piper-airflow/
```

## Grant permissions to newly created tables

Newly created tables in our production database will give default privileges, which is always all privileges, for the owner. To ensure that there are no `Permission denied errors` when DAGs are running in production, we might need to grant additional privileges to user `incremental`, if it hasn't been done already.

```
GRANT SELECT, INSERT, UPDATE, DELETE ON <table_name> TO incremental;
```

It's also recommended that we grant `SELECT` privilege to user `grafana` as well, to make sure our tables can be monitored by Grafana.
```
GRANT SELECT ON <table_name> TO grafana;
```

To check that privileges are what they should be, run `\z <table_name>`. The final result should look something like this: 

![Image](./images/privileges.png)