# Airflow upgrade guide

On Nov 2019 we updated Airflow from a customized in deveopment version around 1.10.0 to 1.10.5 official version on this PR: https://git-aws.internal.justin.tv/insights/piper/pull/278. Here are some instructions as reminders to future updates.

### Step 1: Follow official changelog

This [file](https://github.com/apache/airflow/blob/master/UPDATING.md) documents any backwards-incompatible changes in Airflow and assists users migrating to a new version. Before upgrading to a new version, you will need to read through it to check how we are impacted.

This is the most important and tedious step if the new version has many breaking changes. Follow this guide to fix our codebase accordingly.

### Step 2: Change the version and packages in requirements.txt

Navigate to [requirements.txt](https://git-aws.internal.justin.tv/insights/piper/blob/master/codedeploy/requirements.txt) file and upgrade the airflow version or other packages. 

### Step 3: Local testing

Test locally with installing this requirements with the desired version of Python. 

It is recommended to have a clean start by starting a [Python virtual environment](https://uoa-eresearch.github.io/eresearch-cookbook/recipe/2014/11/26/python-virtual-env/). 

The follow this [guide](https://airflow.apache.org/start.html) to start your airflow in the virtual env locally.

### Step 4: Run Airflow Clean up DAG to clean up DB before the actual upgrade

### Step 5: Deploy
After making sure local airflow start-up is all good. It would mean packages are roughly compatible with each other. Let's deploy this change to staging.

### Step 6: Airflow DB Upgrade

Navigate to staging airflow master box, ssh to it. Run commands to update the airflow DB for new version:

```aidl
sudo su airflow
source /opt/virtualenvs/airflow/bin/activate
export AIRFLOW_HOME=/home/airflow
export AIRFLOW_CONFIG=/home/airflow/airflow.cfg
airflow upgradedb
```

This will fix our current existing airflow metadata DB with updated schema. This process could take A WHILE, so stay tuned.

### Step 7: Go to staging to re-run the last day of every DAG
Making sure upgrades are not breaking DAG functionalities, re-run those DAGs and make sure all passed. 

Please note that mod DAG on staging was expected to fail, so could skip mod DAG until we fix that on staging.

### Step 8: File PR and go to prod, baby sit prod runs
Before doing this, pause all DAG runs. Ideally this step should be done outside usual DAG running ours.

Get your change approved and to prod, re-run that airflow DB upgrade step on prod airflow master. Clean at least one DAG's latest run and let it run again to make sure prod as expected. Then monitor this upgrade for 2 days to make sure all report up to date.

Note: remember to resume pausing for all DAGs after done validations.
