job {
    name 'insights-piper'
    using 'TEMPLATE-autobuild'

    scm {
        git {
            remote {
                github 'insights/piper', 'ssh', 'git.xarth.tv'
                credentials 'git-aws-read-key'
            }
            clean true
        }
    }

    wrappers {
        credentialsBinding {
            file('AWS_CONFIG_FILE', 'd8a-deploy-credentials')
        }
    }

    steps {
        shell 'make test'
        shell "./godeploygo/upload.sh '.' 'd8a' 'piper-airflow'"
    }
}

job {
    name 'insights-piper-deploy'
    using 'TEMPLATE-skadi-deploy'

    parameters {
        stringParam 'ACCOUNT_ID'
    }

    scm {
        git {
            remote {
                github 'insights/piper', 'ssh', 'git.xarth.tv'
                credentials 'git-aws-read-key'
            }
            clean true
            githubPolling(false)
        }
    }
    
   triggers {
      githubPush {
        githubPolling(false)
      }
    }

    wrappers {
        credentialsBinding {
            file('AWS_CONFIG_FILE', 'd8a-deploy-credentials')
        }
    }

    steps {
        shell "./godeploygo/deploy.sh 'd8a' 'piper-airflow'"
    }
}
