from datetime import timedelta

import pendulum


# DAGs can run once per day at different hours of the day.
# Put it in a normalized format where year, month, date are only left.
def normalize_datetime(date):
    utc = pendulum.timezone('UTC')
    return date.replace(tzinfo=utc, hour=0, minute=0, second=0, microsecond=0)


# takes date and returns - 1 day
def get_execution_date(date):
    utc = pendulum.timezone('UTC')
    yesterday = date - timedelta(days=1)
    return yesterday.replace(tzinfo=utc)


def is_backfill(report_execution_date, today):
    yesterday = normalize_datetime(get_execution_date(today))
    return normalize_datetime(report_execution_date).isoformat() != yesterday.isoformat()
