import time
import redis

from airflow.models import BaseOperator
from airflow.utils.decorators import apply_defaults
from airflow.hooks.base_hook import BaseHook


class ClearCache(BaseOperator):
    """
    update piper service cache when daily reports are refreshed
    """

    @apply_defaults
    def __init__(
            self,
            *args,
            conn_id,
            **kwargs):
        super(ClearCache, self).__init__(*args, **kwargs)
        self.conn_id = conn_id

    def execute(self, context):  # pylint: disable=unused-argument
        redis_conn = BaseHook.get_connection(self.conn_id).extra_dejson

        flag = False
        while flag is False:
            myredis = redis.Redis(host=redis_conn['host'], port=redis_conn['port'])
            try:
                flag = myredis.flushdb()
                print('cache cleared')
            except redis.exceptions.ReadOnlyError as ex:
                print(ex)
            except redis.exceptions.ConnectionError as ex:
                raise ex
            time.sleep(3)
