from piper.operators.validators.base_postgres_data_validator import BasePostgresDataValidator


# Validate fields
class ValidateDropsCampaignsOverviewFields(BasePostgresDataValidator):
    block_dag_if_invalid = True
    conn_id = 'games-daily-incremental-reader'
    query = """
        SELECT * FROM drops_campaigns_overview
        WHERE record_date >= %(start_date)s AND record_date < %(end_date)s
    """

    query_params = {
        'start_date': '{{ yesterday_ds }}',
        'end_date': '{{ ds }}',
    }

    def validate(self):
        # pylint: disable=attribute-defined-outside-init
        self.row_id_field = 'campaign_id'

        # for some days there might not be drops data
        if self.rows:
            self.validate_non_negative('streamers_eligible')
            self.validate_non_negative('viewers_eligible')
            self.validate_non_negative('event_drops_earned')
            self.validate_non_negative('mw_drops_earned')
            self.validate_non_negative('viewers_claimed')
            self.validate_non_negative('viewers_linked_and_claimed')

            self.validate_non_negative('streamers_eligible_accum')
            self.validate_non_negative('viewers_eligible_accum')
            self.validate_non_negative('event_drops_earned_accum')
            self.validate_non_negative('mw_drops_earned_accum')
            self.validate_non_negative('viewers_claimed_accum')
            self.validate_non_negative('viewers_linked_and_claimed_accum')

            self.validate_greather_or_equal('viewers_claimed', 'viewers_linked_and_claimed')
            self.validate_greather_or_equal('viewers_eligible', 'mw_drops_earned')
            self.validate_greather_or_equal('viewers_eligible', 'event_drops_earned')

            self.validate_greather_or_equal('viewers_claimed_accum', 'viewers_linked_and_claimed_accum')
            self.validate_greather_or_equal('viewers_eligible_accum', 'mw_drops_earned_accum')
            self.validate_greather_or_equal('viewers_eligible_accum', 'event_drops_earned_accum')
