resource "aws_elasticache_subnet_group" "celery_subnet_group" {
  name = "piper-airflow-celery-subnets"
  description = "subnets for piper-airflow's celery cache"
  subnet_ids = ["${split(",", var.subnets)}"]
}

resource "aws_elasticache_cluster" "celery_cache" {
    cluster_id = "piper-airflow-celery"
    engine = "redis"
    engine_version = "2.8.24"
    node_type = "cache.m3.medium"
    port = 6379
    num_cache_nodes = 1
    parameter_group_name = "default.redis2.8"
    security_group_ids  = ["${var.security_group}"]
    subnet_group_name = "${aws_elasticache_subnet_group.celery_subnet_group.name}"

    tags {
        Name = "piper-airflow-celery"
        Environment = "${var.environment}"
        Owner = "twitch-insights-prod-alerts@amazon.com"
        Project = "piper"
    }
}

resource "aws_cloudwatch_metric_alarm" "elasticache_cpu" {
    alarm_name = "piper-airflow-elasticache-cpu"
    comparison_operator = "GreaterThanOrEqualToThreshold"
    evaluation_periods = "3"
    metric_name = "CPUUtilization"
    namespace = "AWS/ElastiCache"
    period = "300"
    statistic = "Maximum"
    threshold = "75"
    alarm_actions = ["${var.alert_arn}"]
    ok_actions = ["${var.alert_arn}"]
    alarm_description = "Notify pagerduty if CPU sustains above 75% for 15 minutes."

    dimensions {
        CacheClusterId = "piper-airflow-celery"
    }
}
