resource "aws_db_subnet_group" "airflow_db_subnets" {
  name = "piper-airflow-subnets"
  subnet_ids = ["${split(",", var.subnets)}"]

  tags {
    Name = "piper-airflow-subnets"
    Environment = "${var.environment}"
    Owner = "baynhams@justin.tv"
    Project = "piper"
  }
}

resource "aws_db_instance" "airflow_db" {
  identifier = "piper-airflow-master"
  final_snapshot_identifier = "piper-airflow-master"
  backup_retention_period = 7

  allocated_storage = "${var.db_allocated_storage}"
  storage_type = "gp2"

  engine = "postgres"
  engine_version = "9.6"
  instance_class = "${var.db_instance_class}"

  name = "airflow"
  username = "airflow"
  password = "${var.db_password}"

  multi_az = true
  skip_final_snapshot = false

  db_subnet_group_name="${aws_db_subnet_group.airflow_db_subnets.name}"
  vpc_security_group_ids = ["${var.security_group}"]
  port = "5432"

  tags {
    Name = "piper-airflow-db"
    Environment = "${var.environment}"
    Owner = "baynhams@justin.tv"
    Project = "piper"
    rds-buddy-data-eng-managed = "piper-airflow"
  }
}
