variable "environment" {}
variable "subnets" {}
variable "subnets_public" {}

variable "security_group" {
  description = "twitch_subnets to allow all traffic between twitch IP space"
}
variable "security_group_wpa2" {
  description = "allows traffic from Amazon CORP fabric"
}

variable "db_allocated_storage" {}
variable "db_instance_class" {}
variable "db_password" {}
variable "account" {}
variable "owner" {}
variable "vpc" {}
variable "service" {}
variable "sandstorm_assume_arn" {}

variable "ami" {}

variable "min_workers" {
  default = 1
}

variable "max_workers" {
  default = 6
}

variable "desired_workers" {
  default = 6
}

variable "region" {
  default = "us-west-2"
}

variable "deploy_bucket" {
  default = ""
}

variable "alert_arn" {}

provider "aws" {
  version = "~> 1.4"
  profile = "${var.account}"
  region  = "${var.region}"
}

variable "worker_type" {
  default = "m5.4xlarge"
}

variable "master_type" {
  default = "m5.4xlarge"
}

variable "airflow_certificate_arn" {}
variable "flower_certificate_arn" {}
variable "twvpn_certificate_arn" {}
