variable "pagerduty_key" {}
variable "pagerduty_service" {}
variable "environment" {}

provider "pagerduty" {
    token = "${var.pagerduty_key}"
}

data "pagerduty_vendor" "cloudwatch" {
  name = "Amazon CloudWatch"
}

resource "pagerduty_service_integration" "cloudwatch_alarms" {
    name = "Piper (${var.environment})"
    service = "${var.pagerduty_service}"
    vendor  = "${data.pagerduty_vendor.cloudwatch.id}"
}

resource "aws_sns_topic" "cloudwatch_alarms" {
    name = "piper-${var.environment}-alerts"
}

resource "aws_sns_topic_subscription" "alarms_subscription" {
    topic_arn = "${aws_sns_topic.cloudwatch_alarms.arn}"
    endpoint_auto_confirms = true
    protocol = "https"
    endpoint = "https://events.pagerduty.com/integration/${pagerduty_service_integration.cloudwatch_alarms.integration_key}/enqueue"
}

output "topic_arn" {
    value = "${aws_sns_topic.cloudwatch_alarms.arn}"
}
