# AWS Connection
variable "account" {}
variable "region" {
    default = "us-west-2"
}

provider "aws" {
    region = "${var.region}"
    profile = "${var.account}"
}

# Required cluster variables
variable subnet_ids {
    type = "list"
}

variable "vpc_security_group_ids" {
    type = "list"
}

variable "service" {}
variable "role" {}
variable "deploy_group" {
    default = "main"
}
variable "cluster" {
    default = ""
}
variable "environment" {}
variable "ami" {}
variable "owner" {}
variable "sandstorm_assume_arn" {}

# Optional cluster variables
variable "instance_type" {
    default = "m4.large"
}

variable "puppet" {
    default = "puppet"
}

variable "root_block_device_size" {
    default = 32
}

variable "min_count" {
    default = 1
}

variable "max_count" {
    default = 1
}

variable "desired_capacity" {
    default = 1
}

variable "target_group_arns" {
    type = "list"
}

variable "min_elb_capacity" {}

# Internal mapping variables

# Maps above optional puppet var -> `--server` value in puppet call
variable "puppet_server" {
    type = "map"
    default = {
        puppet = "puppet.internal.justin.tv"
        puppet-ci = "puppet.prod.us-west2.justin.tv"
    }
}

# Region qualifier to put in URLs
variable "dns_region" {
    type = "map"
    default = {
        "us-west-2" = "us-west2"
        "us-east-1" = "us-east1"
    }
}

# Environment qualifiers to put in URLs
variable "environment_tagname" {
    type = "map"
    default = {
        production = "prod"
        staging = "stage"
        development = "dev"
    }
}

#Outputs
output "asg_iam_role" { value = "${aws_iam_role.iam_role.id}"}
output "asg_iam_role_arn" { value = "${aws_iam_role.iam_role.arn}"}
output "asg_name" { value = "${aws_autoscaling_group.asg.name}"}
output "asg_arn" { value = "${aws_autoscaling_group.asg.arn}"}
