variable "owner" {}
variable "service" {}
variable "environment" {}
variable "account" {}
variable "region" {
    default = "us-west-2"
}
variable "deploy_bucket" {
    default = ""
}
variable "deploy_group" {
    default = "main"
}

data "null_data_source" "config" {
    inputs = {
        bucket_name = "${var.deploy_bucket == "" ? "${var.owner}-deploy" : var.deploy_bucket}"
    }
}

variable "asgs" {
    type = "list"
    default = []
}

variable "instance_role_count" {
    default = 1
}
variable "instance_roles" {
    type = "list"
}

# For use with tagging semantics as laid out
# by the capacity planing team. Used as the Environment
# tag given to the EC2 instance
variable "environment_tagname" {
  type = "map"
  default = {
    production = "prod"
    staging = "stage"
    development = "dev"
  }
}

provider "aws" {
    profile = "${var.account}"
    region = "${var.region}"
}
