variable "account" {}

variable "environment" {}
variable "name" {}
variable "vpc" {}

variable "internal" {
  description = "if true, the LB will be internal, if false, the LB will be internet-facing"
}

variable "protocol" {
  description = "protocol that the service supports"
}

variable "subnets" {
  type = "list"
}

variable "security_groups" {
  type = "list"
}

variable "target_group_port" {}

variable "healthy_threshold" {}
variable "unhealthy_threshold" {}
variable "health_check_timeout" {}
variable "health_check_path" {}
variable "health_check_interval" {}
variable "health_check_port" {}

variable "certificate_arn" {}

variable "region" {
  default = "us-west-2"
}

variable "alert_arn" {
  type = "list"
}

output "alb_name" {
  value = "${aws_lb.alb.name}"
}

output "target_group_arn" {
  value = "${aws_lb_target_group.alb_target_group.arn}"
}
