data "aws_ami" "amiid" {
  most_recent = true
  owners      = ["043714768218"]

  filter {
    name   = "name"
    values = ["devtools-baseami-xenial-consulfree-*"]
  }
}

resource "aws_instance" "web" {
  ami           = "${data.aws_ami.amiid.id}"
  instance_type = "m4.large"

  subnet_id              = "subnet-518f0b0a"
  vpc_security_group_ids = ["sg-804df7fa"]

  associate_public_ip_address = "false"

  tags = {
    Name = "piper-new-image"
  }
}

output "id" {
  value = "${aws_instance.web.id}"
}

output "private_ip" {
  value = "${aws_instance.web.private_ip}"
}
