resource "aws_s3_bucket" "bucket" {
    bucket = "${var.bucket_name}"
    acl = "private"

    lifecycle_rule {
        id = "expiration"
        enabled = true
        prefix = ""
        abort_incomplete_multipart_upload_days = 7

        noncurrent_version_expiration {
            days = 90
        }

        expiration {
            days = 60
        }
    }

    cors_rule = "${var.cors_rules}"
}

data "aws_iam_policy_document" "bucket_policy_doc" {
    statement {
        actions = ["s3:*"]
        principals {
            type="AWS"
            identifiers = ["${var.permitted_roles}"]
        }
        resources = [
            "arn:aws:s3:::${var.bucket_name}",
            "arn:aws:s3:::${var.bucket_name}/*"
        ]
    }
}

resource "aws_s3_bucket_policy" "bucket_policy" {
    bucket = "${aws_s3_bucket.bucket.id}"
    policy = "${data.aws_iam_policy_document.bucket_policy_doc.json}"
}
