data "aws_iam_policy_document" "s3_assume_role_doc" {
    statement {
        actions=["sts:AssumeRole"]
        principals {
            type = "AWS"
            identifiers = ["${var.piper_roles}"]
        }
    }
}

resource "aws_iam_role" "s3_assume_role" {
    name = "piper-extern-s3-${var.environment}"
    path = "/"

    assume_role_policy = "${data.aws_iam_policy_document.s3_assume_role_doc.json}"
}

data "aws_iam_policy_document" "all_s3_access_doc" {
    statement {
        actions=["s3:*"]
        resources=["*"]
    }
}

resource "aws_iam_role_policy" "all_s3_access" {
    name="piper-extern-s3-${var.environment}-access"
    role="${aws_iam_role.s3_assume_role.id}"

    policy="${data.aws_iam_policy_document.all_s3_access_doc.json}"
}

variable "environment" {}
variable "piper_roles" {
    type="list"
}
