resource "aws_sns_topic" "update_events" {
  name = "${var.name}"
}

resource "aws_sns_topic_policy" "update_events_policy" {
  arn = "${aws_sns_topic.update_events.arn}"
  policy = "${data.aws_iam_policy_document.update_events.json}"
}

data "aws_iam_policy_document" "update_events" {
  statement {
    sid = "AllowSubscriptionsFromOtherTwitchAWSAccounts"
    effect = "Allow"
    principals {
      identifiers = ["${var.edge_iam_arn}"]
      type = "AWS"
    }

    actions = [
      "SNS:Subscribe",
      "SNS:Receive",
      "SNS:ListSubscriptionsByTopic"
    ]

    resources = [
      "${aws_sns_topic.update_events.arn}"
    ]
  }
}
