
# test-instance

this is terraform that spins up a airflow instance for testing that puppet and codedeploy still work.

## why?

this is needed because when codedeploy deployments fail to new instance, the instances are immediately destroyed. codedeploy has logs that will tell you why it failed. however, the feedback cycle using the ASG is:

1. update your code, push it to branch
1. deploy that branch to staging. if it's successful, that's the code that will be deployed to new instances
1. scale up the ASG
1. wait for the new instance to fail or succeed

that's a painfully long feedback cycle. this aims to shorten by letting you iterate on failures on an instance. the steps below may not work out of the box but they should get you pretty darn close.

## Steps

spin up the instance. note the `private_ip` it outputs. note: after you done, delete the instance with `terraform destroy`.

```bash
cd terraform/test-instance
terraform init
terraform plan
terraform apply
```

using `./run.sh`, zip your assets, scp them, run codedeploy-local, and view the logs.

```bash
./run.sh <private_ip>
```

If it succeeds you'll see the following in the log:

```bash
AppSpec file valid. Local deployment successful
```

if it succeeded, the service _should_ be running. you can check with `sudo systemctl status airflow@worker`.

if it fails, you'll see something similar to the following in the log:

```bash
Your local deployment failed while trying to execute your script at /opt/codedeploy-agent/deployment-root/default-local-deployment-group/d-NZW4H8XAS-local/deployment-archive/hook_scripts/validate_loop.sh
```

you can see the logs by `cat codedeploy.log` locally:

```text
2019-01-17 18:52:49 [stdout]No csm configuration found.
2019-01-17 18:52:49 [stdout]Configuration validation first phase succeeded
2019-01-17 18:52:49 [stdout]/opt/aws/amazon-cloudwatch-agent/bin/amazon-cloudwatch-agent -schematest -config /opt/aws/amazon-cloudwatch-agent/etc/amazon-cloudwatch-agent.toml
2019-01-17 18:52:49 [stdout]Configuration validation second phase succeeded
2019-01-17 18:52:49 [stdout]Configuration validation succeeded
2019-01-17 18:52:49 [stderr]Created symlink from /etc/systemd/system/multi-user.target.wants/amazon-cloudwatch-agent.service to /etc/systemd/system/amazon-cloudwatch-agent.service.
2019-01-17 18:52:49 LifecycleEvent - ValidateService
2019-01-17 18:52:49 Script - hook_scripts/validate_loop.sh
2019-01-17 18:53:00 [stdout]enabled
2019-01-17 18:53:00 [stdout]failed
```

you can iterate on the install scripts locally and re-run `./run.sh`

when you're done, delete the instance

```bash
terraform destroy
```

## FAQ

_Why doesn't codedeploy-local exist on my host?_

Older devtools images had a really old version of codedeploy. To update it, use the following steps. This shouldn't be necessary with the latest images as of writing this.

uninstall version of codedeploy-agentbuild if it exists. codedeploy-agentbuild doesn't have codedeploy-local.

```bash
sudo dpkg --purge codedeploy-agentbuild
```

if  codedeploy-agentbuild exists, install codedeploy-agent
https://docs.aws.amazon.com/codedeploy/latest/userguide/codedeploy-agent-operations-install-ubuntu.html

```bash
wget https://aws-codedeploy-us-west-2.s3.amazonaws.com/latest/install
chmod +x ./install
sudo ./install auto
```