provider "aws" {
  profile = "twitch-service-piper-dev"
  region  = "us-west-2"
}

variable "ami_id" {
  default = "ami-0360e77dcdb515466"
}

variable "role" {
  default = "worker"
}

data "template_file" "user_data" {
  template = "${file("user_data.tpl")}"

  vars {
    role           = "airflow-${var.role}"
    cluster        = "airflow-${var.role}"
    env            = "stage"
    owner          = "insights"
    environment    = "staging"
    puppet         = "puppet.internal.justin.tv"
    dns_region     = "us-west2"
    region         = "us-west-2"
    sandstorm_role = "arn:aws:iam::734326455073:role/sandstorm/production/templated/role/piper-airflow-staging"
  }
}

resource "aws_instance" "web" {
  ami           = "${var.ami_id}"
  instance_type = "m4.large"

  subnet_id              = "subnet-518f0b0a"
  vpc_security_group_ids = ["sg-804df7fa"]

  user_data = "${data.template_file.user_data.rendered}"

  associate_public_ip_address = "false"

  iam_instance_profile = "piper-airflow-airflow-worker-staging"

  tags = {
    Name = "piper-test"
  }
}

output "id" {
  value = "${aws_instance.web.id}"
}

output "private_ip" {
  value = "${aws_instance.web.private_ip}"
}
